/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class WolvesEventsProcedure {
    private static final double BASE_PROB_PHASE1 = 4.0E-5;
    private static final double MAX_PROB_PHASE1 = 4.5E-5;
    private static final double BASE_PROB_PHASE2 = 5.0E-5;
    private static final double MAX_PROB_PHASE2 = 5.5E-5;
    private static final int SCAN_RADIUS = 20;
    private static final int DURATION_TICKS = 200;
    private static final int MIN_DELAY_TICKS = 200;
    private static final int MAX_DELAY_TICKS = 600;
    private static final Map<Integer, WolfState> active = new HashMap<Integer, WolfState>();
    private static int counter = 0;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = ev.player;
        Level level = player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server);
        if (phase < 1 || phase > 2) {
            return;
        }
        double baseProb = phase == 1 ? 4.0E-5 : 5.0E-5;
        double maxProb = phase == 1 ? 4.5E-5 : 5.5E-5;
        double dynamicProb = ChunkTensionProcedure.getDynamicProbability(server, player, baseProb, maxProb);
        if (server.m_213780_().m_188500_() >= dynamicProb) {
            return;
        }
        List<Entity> wolves = WolvesEventsProcedure.findTamedWolves(server, player);
        if (wolves.isEmpty()) {
            return;
        }
        WolfEvent choice = WolfEvent.values()[server.m_213780_().m_188503_(WolfEvent.values().length)];
        float yaw = server.m_213780_().m_188501_() * 360.0f - 180.0f;
        active.put(counter++, new WolfState(choice, player, wolves, yaw));
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Iterator<Map.Entry<Integer, WolfState>> it = active.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Integer, WolfState> entry = it.next();
            WolfState s = entry.getValue();
            if (!(s.player.m_9236_() instanceof ServerLevel)) {
                it.remove();
                continue;
            }
            ServerLevel server = (ServerLevel)s.player.m_9236_();
            ++s.tickCount;
            long now = server.m_46467_();
            for (UUID id : new ArrayList<UUID>(s.wolves)) {
                ResourceLocation rl;
                SoundEvent sound;
                Wolf w;
                Entity en = WolvesEventsProcedure.findEntityByUUID(server, s.player, id, 20.0);
                if (en == null || en.m_213877_() || en.m_6095_() != EntityType.f_20499_ || !(w = (Wolf)en).m_6084_()) continue;
                w.m_20256_(Vec3.f_82478_);
                w.m_146922_(s.yaw);
                w.f_20885_ = s.yaw;
                w.f_20883_ = s.yaw;
                if (s.event != WolfEvent.GROWL_AT_OWNER || now < s.nextSoundTick) continue;
                if (w.m_21805_() != null && w.m_21805_().equals(s.player.m_20148_()) && (sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(rl = new ResourceLocation("minecraft", "entity.wolf.growl"))) != null) {
                    server.m_5594_(null, w.m_20183_(), sound, SoundSource.NEUTRAL, 1.0f, 1.0f);
                }
                int delay = 200 + server.m_213780_().m_188503_(401);
                s.nextSoundTick = now + (long)delay;
            }
            if (s.tickCount < 200) continue;
            it.remove();
        }
    }

    private static List<Entity> findTamedWolves(ServerLevel server, Player player) {
        AABB box = player.m_20191_().m_82400_(20.0);
        return server.m_6443_(Entity.class, box, e -> {
            Wolf w;
            return e.m_6095_() == EntityType.f_20499_ && e instanceof Wolf && (w = (Wolf)e).m_21824_();
        });
    }

    private static Entity findEntityByUUID(ServerLevel server, Player player, UUID id, double radius) {
        AABB box = player.m_20191_().m_82400_(radius);
        for (Entity en : server.m_6443_(Entity.class, box, e -> true)) {
            if (!en.m_20148_().equals(id)) continue;
            return en;
        }
        return null;
    }

    private static enum WolfEvent {
        SIT_AND_STARE,
        GROWL_AT_OWNER;

    }

    private static class WolfState {
        WolfEvent event;
        Player player;
        List<UUID> wolves;
        int tickCount;
        float yaw;
        long nextSoundTick;

        WolfState(WolfEvent event, Player player, List<Entity> wolves, float yaw) {
            this.event = event;
            this.player = player;
            this.wolves = new ArrayList<UUID>();
            for (Entity e : wolves) {
                this.wolves.add(e.m_20148_());
            }
            this.tickCount = 0;
            this.yaw = yaw;
            this.nextSoundTick = 0L;
        }
    }
}

