/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.mcreator.fromthecaves.entity.FROMTHECAVESSIGNEntity;
import net.mcreator.fromthecaves.init.FromTheCavesModEntities;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class SpawnSignMobProcedure {
    private static final double SPAWN_CHANCE = 3.0E-4;
    private static final int MIN_DIST = 10;
    private static final int MAX_DIST = 20;
    private static final String[] MESSAGES = new String[]{"behind you", "it's watching", "look over there", "I'm closer", "do you like my eyes?", "..."};
    private static final List<BlockPos> activeSigns = new ArrayList<BlockPos>();
    private static final List<Pending> pendingSpawns = new ArrayList<Pending>();

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = ev.player;
        Level lvl = player.m_9236_();
        if (lvl.m_5776_()) {
            return;
        }
        if (!(lvl instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)lvl;
        if (PhaseManagerProcedure.getCurrentPhase((LevelAccessor)serverLevel) != 2) {
            return;
        }
        long time = serverLevel.m_46468_() % 24000L;
        if (time <= 12000L) {
            return;
        }
        RandomSource rand = serverLevel.m_213780_();
        if (rand.m_188500_() < 3.0E-4) {
            double angle = rand.m_188500_() * Math.PI * 2.0;
            double dist = 10.0 + rand.m_188500_() * 10.0;
            int dx = (int)Math.round(Math.cos(angle) * dist);
            int dz = (int)Math.round(Math.sin(angle) * dist);
            BlockPos base = player.m_20183_().m_7918_(dx, 0, dz);
            int y = serverLevel.m_6924_(Heightmap.Types.WORLD_SURFACE, base.m_123341_(), base.m_123343_());
            BlockPos signPos = new BlockPos(base.m_123341_(), y, base.m_123343_());
            serverLevel.m_7731_(signPos, (BlockState)Blocks.f_50095_.m_49966_().m_61124_((Property)StandingSignBlock.f_56987_, (Comparable)Integer.valueOf(rand.m_188503_(16))), 3);
            BlockEntity be = serverLevel.m_7702_(signPos);
            if (be instanceof SignBlockEntity) {
                SignBlockEntity sign = (SignBlockEntity)be;
                CompoundTag tag = sign.m_187482_();
                CompoundTag front = new CompoundTag();
                ListTag msgs = new ListTag();
                String randomMsg = MESSAGES[rand.m_188503_(MESSAGES.length)];
                msgs.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)Component.m_237113_((String)randomMsg))));
                msgs.add((Object)StringTag.m_129297_((String)"\"\""));
                msgs.add((Object)StringTag.m_129297_((String)"\"\""));
                msgs.add((Object)StringTag.m_129297_((String)"\"\""));
                front.m_128365_("messages", (Tag)msgs);
                tag.m_128365_("front_text", (Tag)front);
                tag.m_128359_("id", "minecraft:sign");
                sign.m_142466_(tag);
                sign.m_6596_();
                serverLevel.m_7260_(signPos, sign.m_58900_(), sign.m_58900_(), 3);
            }
            activeSigns.add(signPos);
        }
        long now = serverLevel.m_46467_();
        Iterator<Pending> pit = pendingSpawns.iterator();
        while (pit.hasNext()) {
            Pending p = pit.next();
            if (now < p.detectTick + 20L) continue;
            Player target = serverLevel.m_46003_(p.playerId);
            if (target != null) {
                Vec3 spawnPos = target.m_20182_().m_82546_(target.m_20154_().m_82541_().m_82490_(2.0));
                FROMTHECAVESSIGNEntity mob = (FROMTHECAVESSIGNEntity)((EntityType)FromTheCavesModEntities.FROMTHECAVESSIGN.get()).m_20615_((Level)serverLevel);
                if (mob != null) {
                    float yaw = target.m_146908_() + 180.0f;
                    mob.m_7678_(spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_, yaw, 0.0f);
                    CompoundTag mnbt = mob.getPersistentData();
                    mnbt.m_128356_("spawnTick", now);
                    mnbt.m_128379_("soundPlayed", false);
                    mnbt.m_128356_("soundTick", 0L);
                    mnbt.m_128405_("signX", p.signPos.m_123341_());
                    mnbt.m_128405_("signY", p.signPos.m_123342_());
                    mnbt.m_128405_("signZ", p.signPos.m_123343_());
                    mnbt.m_128362_("targetUUID", p.playerId);
                    serverLevel.m_7967_((Entity)mob);
                }
            }
            pit.remove();
        }
    }

    @SubscribeEvent
    public static void onPlayerInFrontOfSign(TickEvent.PlayerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = ev.player;
        Level lvl = player.m_9236_();
        if (lvl.m_5776_() || !(lvl instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)lvl;
        long now = serverLevel.m_46467_();
        Iterator<BlockPos> it = activeSigns.iterator();
        while (it.hasNext()) {
            Vec3 toPlayer;
            SignBlockEntity sign;
            int rot;
            double yaw;
            Vec3 frontDir;
            BlockEntity be;
            double dz;
            BlockPos signPos = it.next();
            double dx = player.m_20185_() - ((double)signPos.m_123341_() + 0.5);
            if (dx * dx + (dz = player.m_20189_() - ((double)signPos.m_123343_() + 0.5)) * dz > 9.0 || !((be = serverLevel.m_7702_(signPos)) instanceof SignBlockEntity) || (frontDir = new Vec3(-Math.sin(Math.toRadians(yaw = (double)(rot = ((Integer)(sign = (SignBlockEntity)be).m_58900_().m_61143_((Property)StandingSignBlock.f_56987_)).intValue()) * 22.5)), 0.0, Math.cos(Math.toRadians(yaw)))).m_82526_(toPlayer = new Vec3(dx, 0.0, dz).m_82541_()) <= 0.0) continue;
            pendingSpawns.add(new Pending(signPos, player.m_20148_(), now));
            it.remove();
        }
    }

    @SubscribeEvent
    public static void onMobTick(LivingEvent.LivingTickEvent ev) {
        LivingEntity e = ev.getEntity();
        if (!(e instanceof FROMTHECAVESSIGNEntity)) {
            return;
        }
        FROMTHECAVESSIGNEntity mob = (FROMTHECAVESSIGNEntity)e;
        Level lvl = mob.m_9236_();
        if (lvl.m_5776_() || !(lvl instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)lvl;
        CompoundTag nbt = mob.getPersistentData();
        if (!nbt.m_128441_("targetUUID") || !nbt.m_128441_("spawnTick")) {
            return;
        }
        long now = serverLevel.m_46467_();
        UUID targetId = nbt.m_128342_("targetUUID");
        Player player = serverLevel.m_46003_(targetId);
        if (player == null) {
            return;
        }
        Vec3 diff = player.m_20182_().m_82546_(mob.m_20182_());
        float yaw = (float)Math.toDegrees(Math.atan2(diff.f_82481_, diff.f_82479_)) - 90.0f;
        mob.m_146922_(yaw);
        mob.f_20885_ = yaw;
        mob.f_20883_ = yaw;
        boolean played = nbt.m_128471_("soundPlayed");
        if (!played) {
            Vec3 eye = player.m_20299_(1.0f);
            Vec3 mobEye = mob.m_20182_().m_82520_(0.0, (double)mob.m_20192_() * 0.9, 0.0);
            Vec3 toMob = mobEye.m_82546_(eye).m_82541_();
            Vec3 look = player.m_20154_().m_82541_();
            double dot = look.m_82526_(toMob);
            if (dot > 0.87) {
                nbt.m_128379_("soundPlayed", true);
                nbt.m_128356_("soundTick", now);
                SoundEvent cave = SpawnSignMobProcedure.resolveSound(SoundEvents.f_11689_);
                if (cave != null) {
                    serverLevel.m_5594_(null, BlockPos.m_274446_((Position)mobEye), cave, SoundSource.AMBIENT, 1.0f, 1.0f);
                }
            } else {
                mob.m_21563_().m_148051_((Entity)player);
            }
            return;
        }
        long soundTick = nbt.m_128454_("soundTick");
        if (now >= soundTick + 14L && !nbt.m_128441_("blindApplied")) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 80, 0, false, true));
            nbt.m_128379_("blindApplied", true);
        }
        if (now >= soundTick + 40L) {
            int sx = nbt.m_128451_("signX");
            int sy = nbt.m_128451_("signY");
            int sz = nbt.m_128451_("signZ");
            serverLevel.m_7471_(new BlockPos(sx, sy, sz), false);
            mob.m_146870_();
        }
    }

    private static SoundEvent resolveSound(Object soundConst) {
        Object res;
        Method m2;
        if (soundConst instanceof SoundEvent) {
            SoundEvent se = (SoundEvent)soundConst;
            return se;
        }
        try {
            m2 = soundConst.getClass().getMethod("get", new Class[0]);
            res = m2.invoke(soundConst, new Object[0]);
            if (res instanceof SoundEvent) {
                return (SoundEvent)res;
            }
        }
        catch (Exception m2) {
            // empty catch block
        }
        try {
            m2 = soundConst.getClass().getMethod("value", new Class[0]);
            res = m2.invoke(soundConst, new Object[0]);
            if (res instanceof SoundEvent) {
                return (SoundEvent)res;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static class Pending {
        BlockPos signPos;
        UUID playerId;
        long detectTick;

        Pending(BlockPos p, UUID id, long t) {
            this.signPos = p;
            this.playerId = id;
            this.detectTick = t;
        }
    }
}

