/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetSubtitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitlesAnimationPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class AngerSystemProcedure {
    private static final double CROSS_USE_ANGER = 0.1;
    private static final double WOLF_KILL_ANGER = 0.8;
    private static final double VILLAGER_KILL_ANGER = 0.9;
    private static final double EXORCISM_ANGER = 23.0;
    private static final double ENCLOSED_ANGER_PER_INTERVAL = 3.0;
    private static final double BELOW_Y45_ANGER_PER_INTERVAL = 8.0;
    private static final double INSIDE_HOUSE_ANGER_PER_INTERVAL = 1.0;
    private static final int CAVE_Y_THRESHOLD = 55;
    private static final int DEEP_CAVE_Y_THRESHOLD = 45;
    private static final int ENCLOSED_CHECK_TICKS = 2400;
    private static final int BELOW_Y45_CHECK_TICKS = 12000;
    private static final int INSIDE_HOUSE_CHECK_TICKS = 1200;
    private static final int DEBUG_UPDATE_TICKS = 20;
    private static final double ANGER_THRESHOLD_PHASE2 = 50.0;

    private static AngerSavedData getAngerData(ServerLevel level) {
        DimensionDataStorage storage = level.m_7654_().m_129783_().m_8895_();
        return (AngerSavedData)storage.m_164861_(AngerSavedData::load, AngerSavedData::new, "fromthecaves_anger_data");
    }

    public static double getAngerLevel(ServerLevel level) {
        return AngerSystemProcedure.getAngerData(level).getAngerLevel();
    }

    public static void addAnger(ServerLevel level, double amount) {
        if (PhaseManagerProcedure.getCurrentPhase((LevelAccessor)level) < 1) {
            return;
        }
        AngerSavedData data = AngerSystemProcedure.getAngerData(level);
        double previousAnger = data.getAngerLevel();
        data.addAnger(amount);
        double currentAnger = data.getAngerLevel();
        if (previousAnger < 50.0 && currentAnger >= 50.0) {
            PhaseManagerProcedure.setManualPhase((LevelAccessor)level, 2);
        }
    }

    public static void setAngerLevel(ServerLevel level, double amount) {
        AngerSystemProcedure.getAngerData(level).setAngerLevel(amount);
    }

    public static void resetAnger(ServerLevel level) {
        AngerSystemProcedure.getAngerData(level).resetAnger();
    }

    @SubscribeEvent
    public static void onServerStarting(ServerStartingEvent event) {
        CommandDispatcher dispatcher = event.getServer().m_129892_().m_82094_();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"fromthecaves").then(Commands.m_82127_((String)"angerDebug").executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            ServerPlayer player = source.m_230896_();
            if (player == null) {
                source.m_81352_((Component)Component.m_237113_((String)"This command can only be executed by a player."));
                return 0;
            }
            boolean current = player.getPersistentData().m_128471_("debugAnger");
            boolean newState = !current;
            player.getPersistentData().m_128379_("debugAnger", newState);
            source.m_288197_(() -> Component.m_237113_((String)("Anger Debug mode " + (newState ? "enabled" : "disabled"))), false);
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"resetAnger").requires(source -> source.m_6761_(2))).executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            ServerLevel level = source.m_81372_();
            if (level instanceof ServerLevel) {
                ServerLevel server = level;
                AngerSystemProcedure.resetAnger(server);
                source.m_288197_(() -> Component.m_237113_((String)"Anger level has been reset to 0"), true);
                return 1;
            }
            return 0;
        }))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"getAnger").requires(source -> source.m_6761_(2))).executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            ServerLevel level = source.m_81372_();
            if (level instanceof ServerLevel) {
                ServerLevel server = level;
                double anger = AngerSystemProcedure.getAngerLevel(server);
                source.m_288197_(() -> Component.m_237113_((String)("Current Anger Level: " + String.format("%.2f", anger))), false);
                return 1;
            }
            return 0;
        })));
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        Entity sourceEntity = event.getSource().m_7639_();
        if (!(sourceEntity instanceof Player)) {
            return;
        }
        LivingEntity deadEntity = event.getEntity();
        Level level = deadEntity.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        if (PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server) < 1) {
            return;
        }
        EntityType type = deadEntity.m_6095_();
        if (type == EntityType.f_20499_) {
            AngerSystemProcedure.addAnger(server, 0.8);
            AngerSystemProcedure.sendAngerNotification(server, "Wolf killed", 0.8);
        } else if (type == EntityType.f_20492_) {
            AngerSystemProcedure.addAnger(server, 0.9);
            AngerSystemProcedure.sendAngerNotification(server, "Villager killed", 0.9);
        }
    }

    public static void onCrossUsed(ServerLevel server) {
        if (PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server) < 1) {
            return;
        }
        AngerSystemProcedure.addAnger(server, 0.1);
        AngerSystemProcedure.sendAngerNotification(server, "Cross used", 0.1);
    }

    public static void onExorcism(ServerLevel server) {
        if (PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server) < 1) {
            return;
        }
        AngerSystemProcedure.addAnger(server, 23.0);
        AngerSystemProcedure.sendAngerNotification(server, "Exorcism performed", 23.0);
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = event.player;
        Level level = player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        if (PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server) < 1) {
            return;
        }
        CompoundTag nbt = player.getPersistentData();
        BlockPos playerPos = player.m_20183_();
        boolean isEnclosed = AngerSystemProcedure.isPlayerEnclosed(server, playerPos, player);
        boolean isInCave = AngerSystemProcedure.isPlayerInCave(server, playerPos, player);
        boolean isInsideHouse = AngerSystemProcedure.isPlayerInsideHouse(server, playerPos, player);
        int enclosedTicks = nbt.m_128451_("ftc_enclosedTicks");
        if (isEnclosed) {
            nbt.m_128405_("ftc_enclosedTicks", ++enclosedTicks);
            if (enclosedTicks >= 2400) {
                AngerSystemProcedure.addAnger(server, 3.0);
                AngerSystemProcedure.sendAngerNotification(server, "Player enclosed", 3.0);
                nbt.m_128405_("ftc_enclosedTicks", 0);
            }
        } else if (enclosedTicks > 0) {
            nbt.m_128405_("ftc_enclosedTicks", 0);
        }
        int belowY45Ticks = nbt.m_128451_("ftc_belowY45Ticks");
        if (isInCave) {
            nbt.m_128405_("ftc_belowY45Ticks", ++belowY45Ticks);
            if (belowY45Ticks >= 12000) {
                AngerSystemProcedure.addAnger(server, 8.0);
                AngerSystemProcedure.sendAngerNotification(server, "Player in caves", 8.0);
                nbt.m_128405_("ftc_belowY45Ticks", 0);
            }
        } else if (belowY45Ticks > 0) {
            nbt.m_128405_("ftc_belowY45Ticks", 0);
        }
        int insideHouseTicks = nbt.m_128451_("ftc_insideHouseTicks");
        if (isInsideHouse) {
            nbt.m_128405_("ftc_insideHouseTicks", ++insideHouseTicks);
            if (insideHouseTicks >= 1200) {
                AngerSystemProcedure.addAnger(server, 1.0);
                AngerSystemProcedure.sendAngerNotification(server, "Player inside house", 1.0);
                nbt.m_128405_("ftc_insideHouseTicks", 0);
            }
        } else if (insideHouseTicks > 0) {
            nbt.m_128405_("ftc_insideHouseTicks", 0);
        }
        if (player.f_19797_ % 20 == 0 && nbt.m_128471_("debugAnger")) {
            AngerSystemProcedure.sendDebugInfo(server, player, isEnclosed, isInCave, isInsideHouse, enclosedTicks, belowY45Ticks, insideHouseTicks);
        }
    }

    private static boolean isPlayerEnclosed(ServerLevel level, BlockPos playerPos, Player player) {
        int[][] horizontalOffsets;
        if (playerPos.m_123342_() >= 55) {
            return false;
        }
        if (player.m_5833_() || !player.m_20096_()) {
            return false;
        }
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        int solidBlocksAround = 0;
        int totalChecks = 0;
        int airOrTransparentBlocks = 0;
        for (int dx = -2; dx <= 2; ++dx) {
            for (int dy = -1; dy <= 3; ++dy) {
                for (int dz = -2; dz <= 2; ++dz) {
                    if (dx == 0 && dz == 0 && dy >= 0 && dy <= 2) continue;
                    mutable.m_122178_(playerPos.m_123341_() + dx, playerPos.m_123342_() + dy, playerPos.m_123343_() + dz);
                    BlockState state = level.m_8055_((BlockPos)mutable);
                    ++totalChecks;
                    if (state.m_60795_() || !state.m_280296_() || !state.m_60815_()) {
                        ++airOrTransparentBlocks;
                        continue;
                    }
                    if (!state.m_280296_()) continue;
                    ++solidBlocksAround;
                }
            }
        }
        if ((double)airOrTransparentBlocks > (double)totalChecks * 0.4) {
            return false;
        }
        int skyVisibilityChecks = 0;
        for (int y = playerPos.m_123342_() + 3; y <= Math.min(playerPos.m_123342_() + 15, level.m_151558_()); ++y) {
            mutable.m_122178_(playerPos.m_123341_(), y, playerPos.m_123343_());
            BlockState state = level.m_8055_((BlockPos)mutable);
            if (state.m_60795_()) {
                ++skyVisibilityChecks;
                continue;
            }
            if (state.m_280296_()) break;
        }
        if (skyVisibilityChecks > 8) {
            return false;
        }
        int horizontalSolidCount = 0;
        for (int[] offset : horizontalOffsets = new int[][]{{-3, 0}, {3, 0}, {0, -3}, {0, 3}, {-2, -2}, {2, -2}, {-2, 2}, {2, 2}}) {
            mutable.m_122178_(playerPos.m_123341_() + offset[0], playerPos.m_123342_() + 1, playerPos.m_123343_() + offset[1]);
            if (!level.m_8055_((BlockPos)mutable).m_280296_()) continue;
            ++horizontalSolidCount;
        }
        return horizontalSolidCount >= 6 && (double)solidBlocksAround > (double)totalChecks * 0.55;
    }

    private static boolean isPlayerInCave(ServerLevel level, BlockPos playerPos, Player player) {
        boolean isDeepUnderground;
        if (player.m_5833_()) {
            return false;
        }
        int playerY = playerPos.m_123342_();
        if (playerY >= 55) {
            return false;
        }
        boolean hasRoofAbove = false;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int y = playerY + 3; y <= Math.min(playerY + 20, level.m_151558_()); ++y) {
            mutable.m_122178_(playerPos.m_123341_(), y, playerPos.m_123343_());
            BlockState state = level.m_8055_((BlockPos)mutable);
            if (!state.m_280296_() || state.m_204336_(BlockTags.f_13035_)) continue;
            hasRoofAbove = true;
            break;
        }
        if (!hasRoofAbove) {
            return false;
        }
        int naturalBlocksNearby = 0;
        int placedBlocksNearby = 0;
        int totalSolidBlocks = 0;
        for (int dx = -4; dx <= 4; ++dx) {
            for (int dy = -2; dy <= 2; ++dy) {
                for (int dz = -4; dz <= 4; ++dz) {
                    if (dx == 0 && dy == 0 && dz == 0) continue;
                    mutable.m_122178_(playerPos.m_123341_() + dx, playerPos.m_123342_() + dy, playerPos.m_123343_() + dz);
                    BlockState state = level.m_8055_((BlockPos)mutable);
                    if (!state.m_280296_()) continue;
                    ++totalSolidBlocks;
                    if (state.m_204336_(BlockTags.f_13061_) || state.m_204336_(BlockTags.f_144274_) || state.m_204336_(BlockTags.f_144266_) || state.m_204336_(BlockTags.f_144267_)) {
                        ++naturalBlocksNearby;
                        continue;
                    }
                    if (state.m_204336_(BlockTags.f_13106_) || state.m_204336_(BlockTags.f_13090_)) continue;
                    ++placedBlocksNearby;
                }
            }
        }
        if (placedBlocksNearby > naturalBlocksNearby && placedBlocksNearby > 30) {
            return false;
        }
        int lightLevel = level.m_46803_(playerPos);
        boolean isDark = lightLevel <= 7;
        boolean bl = isDeepUnderground = playerY < 45;
        if (isDeepUnderground && hasRoofAbove && totalSolidBlocks > 40) {
            return true;
        }
        return hasRoofAbove && naturalBlocksNearby > 25 && isDark;
    }

    private static boolean isPlayerInsideHouse(ServerLevel level, BlockPos playerPos, Player player) {
        if (player.m_5833_()) {
            return false;
        }
        int structureBlocksNearby = 0;
        int totalChecks = 0;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int dx = -3; dx <= 3; ++dx) {
            for (int dy = -2; dy <= 2; ++dy) {
                for (int dz = -3; dz <= 3; ++dz) {
                    if (dx == 0 && dy == 0 && dz == 0) continue;
                    mutable.m_122178_(playerPos.m_123341_() + dx, playerPos.m_123342_() + dy, playerPos.m_123343_() + dz);
                    if (!level.m_46749_((BlockPos)mutable)) continue;
                    ++totalChecks;
                    BlockState state = level.m_8055_((BlockPos)mutable);
                    if (!AngerSystemProcedure.isStructureBlock(state)) continue;
                    ++structureBlocksNearby;
                }
            }
        }
        if (totalChecks == 0) {
            return false;
        }
        double ratio = (double)structureBlocksNearby / (double)totalChecks;
        return ratio > 0.25;
    }

    private static boolean isStructureBlock(BlockState state) {
        return state.m_204336_(BlockTags.f_13090_) || state.m_204336_(BlockTags.f_13106_) || state.m_204336_(BlockTags.f_13097_) || state.m_204336_(BlockTags.f_13096_) || state.m_204336_(BlockTags.f_13098_) || state.m_60734_() == Blocks.f_50069_ || state.m_60734_() == Blocks.f_50652_ || state.m_60734_() == Blocks.f_50079_ || state.m_60734_() == Blocks.f_50222_ || state.m_60734_() == Blocks.f_50223_ || state.m_60734_() == Blocks.f_50224_ || state.m_60734_() == Blocks.f_50225_ || state.m_60734_() == Blocks.f_50076_ || state.m_60734_() == Blocks.f_50334_ || state.m_60734_() == Blocks.f_50387_ || state.m_60734_() == Blocks.f_50228_ || state.m_60734_() == Blocks.f_50281_ || state.m_60734_() == Blocks.f_50122_ || state.m_60734_() == Blocks.f_50175_ || state.m_60734_() == Blocks.f_152550_ || state.m_60734_() == Blocks.f_152555_ || state.m_60734_() == Blocks.f_152589_ || state.m_60734_() == Blocks.f_152559_ || state.m_60734_() == Blocks.f_50062_ || state.m_60734_() == Blocks.f_50394_ || state.m_60734_() == Blocks.f_50471_ || state.m_60734_() == Blocks.f_50473_ || state.m_60734_() == Blocks.f_50064_ || state.m_60734_() == Blocks.f_50396_ || state.m_60734_() == Blocks.f_50377_ || state.m_60734_() == Blocks.f_50378_ || state.m_60734_() == Blocks.f_50379_ || state.m_60734_() == Blocks.f_50730_ || state.m_60734_() == Blocks.f_50734_ || state.m_60734_() == Blocks.f_50735_ || state.m_60734_() == Blocks.f_50197_ || state.m_60734_() == Blocks.f_50452_ || state.m_60734_() == Blocks.f_50259_ || state.m_60734_() == Blocks.f_50443_ || state.m_60734_() == Blocks.f_50492_ || state.m_60734_() == Blocks.f_50333_ || state.m_60734_() == Blocks.f_50472_ || state.m_60734_() == Blocks.f_50352_ || state.m_204336_(BlockTags.f_198156_) || state.m_204336_(BlockTags.f_13103_) || state.m_204336_(BlockTags.f_13036_) || state.m_204336_(BlockTags.f_13055_) || state.m_204336_(BlockTags.f_13032_) || state.m_204336_(BlockTags.f_13089_);
    }

    private static void sendAngerNotification(ServerLevel server, String cause, double amount) {
        for (ServerPlayer player : server.m_6907_()) {
            if (!player.getPersistentData().m_128471_("debugAnger")) continue;
            player.m_213846_((Component)Component.m_237113_((String)("\u00a7c[ANGER] " + cause + ": +" + String.format("%.2f", amount))));
        }
    }

    private static void sendDebugInfo(ServerLevel server, Player player, boolean enclosed, boolean inCave, boolean insideHouse, int enclosedTicks, int caveTicks, int houseTicks) {
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sp = (ServerPlayer)player;
        double angerLevel = AngerSystemProcedure.getAngerLevel(server);
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server);
        double enclosedProgress = (double)enclosedTicks / 2400.0 * 100.0;
        double caveProgress = (double)caveTicks / 12000.0 * 100.0;
        double houseProgress = (double)houseTicks / 1200.0 * 100.0;
        sp.f_8906_.m_9829_((Packet)new ClientboundSetTitlesAnimationPacket(0, 40, 0));
        sp.f_8906_.m_9829_((Packet)new ClientboundSetTitleTextPacket((Component)Component.m_237113_((String)("\u00a7cANGER: " + String.format("%.2f", angerLevel) + " / 50.0"))));
        String subtitle = "Phase: " + phase + " | Enclosed: " + (enclosed ? "\u00a7aYES" : "\u00a77NO") + " | Cave: " + (inCave ? "\u00a7aYES" : "\u00a77NO") + " | House: " + (insideHouse ? "\u00a7aYES" : "\u00a77NO");
        sp.f_8906_.m_9829_((Packet)new ClientboundSetSubtitleTextPacket((Component)Component.m_237113_((String)subtitle)));
        String actionBar = "Enclosed: " + String.format("%.1f", enclosedProgress) + "% | Cave: " + String.format("%.1f", caveProgress) + "% | House: " + String.format("%.1f", houseProgress) + "%";
        sp.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237113_((String)actionBar)));
    }

    public static class AngerSavedData
    extends SavedData {
        public static final String NAME = "fromthecaves_anger_data";
        private double angerLevel = 0.0;

        public static AngerSavedData load(CompoundTag tag) {
            AngerSavedData data = new AngerSavedData();
            data.angerLevel = tag.m_128459_("angerLevel");
            return data;
        }

        public CompoundTag m_7176_(CompoundTag tag) {
            tag.m_128347_("angerLevel", this.angerLevel);
            return tag;
        }

        public double getAngerLevel() {
            return this.angerLevel;
        }

        public void addAnger(double amount) {
            this.angerLevel += amount;
            this.m_77762_();
        }

        public void setAngerLevel(double level) {
            this.angerLevel = level;
            this.m_77762_();
        }

        public void resetAnger() {
            this.angerLevel = 0.0;
            this.m_77762_();
        }
    }
}

