/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import net.mcreator.fromthecaves.init.FromTheCavesModEntities;
import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class HouseCornerStalkerProcedure {
    private static final double BASE_PROB = 1.5E-4;
    private static final double MAX_PROB = 3.0E-4;
    private static final double MIN_DIST = 5.0;
    private static final double MAX_DIST = 25.0;
    private static final double WATCH_DISTANCE = 60.0;
    private static final double CHASE_TRIGGER_DIST = 4.0;
    private static final int LOOK_TRIGGER_TICKS = 140;
    private static final double RUN_SPEED = 0.75;
    private static final int RUN_DURATION_TICKS = 240;
    private static final double GRAVITY = 0.42;
    private static final int MAX_LIGHT_LEVEL = 5;
    private static final int CORNER_SEARCH_RADIUS = 20;
    private static final int MAX_CORNER_ATTEMPTS = 30;
    private static final double NOCLIP_SPEED = 0.6;
    private static final double DESPAWN_BEHIND_COVER_DIST = 25.0;
    private static final int DESPAWN_HIDDEN_TICKS = 60;
    private static final int DESPAWN_DELAY_TICKS = 20;
    private static final String KEY_HOUSE_CORNER = "hcs_houseCorner";
    private static final String KEY_SPAWN_TIME = "hcs_spawnTime";
    private static final String KEY_LOOK_START = "hcs_lookStart";
    private static final String KEY_RUNNING = "hcs_running";
    private static final String KEY_RUN_START = "hcs_runStart";
    private static final String KEY_FROZEN = "hcs_frozen";
    private static final String KEY_FADE_START = "hcs_fadeStart";
    private static final String KEY_HIDDEN_START = "hcs_hiddenStart";
    private static final String KEY_DESPAWN_STARTED = "hcs_despawnStarted";
    private static final String KEY_DESPAWN_DELAY = "hcs_despawnDelay";

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = ev.player;
        if (player.m_9236_().m_5776_()) {
            return;
        }
        ServerLevel level = (ServerLevel)player.m_9236_();
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)level);
        if (phase != 1 && phase != 2) {
            return;
        }
        double dynamicProb = ChunkTensionProcedure.getDynamicProbability(level, player, 1.5E-4, 3.0E-4);
        if (Math.random() >= dynamicProb) {
            return;
        }
        EntityType<?> chosenEntity = HouseCornerStalkerProcedure.chooseRandomEntity();
        BlockPos cornerPos = HouseCornerStalkerProcedure.findDarkCornerInHouse(level, player);
        if (cornerPos == null) {
            return;
        }
        Mob mob = (Mob)chosenEntity.m_262496_(level, cornerPos, MobSpawnType.MOB_SUMMONED);
        if (mob == null) {
            return;
        }
        mob.m_20242_(false);
        mob.m_21557_(false);
        mob.m_21530_();
        mob.f_19794_ = false;
        HouseCornerStalkerProcedure.makeEntityLookAtPlayer(mob, player);
        CompoundTag data = mob.getPersistentData();
        data.m_128379_(KEY_HOUSE_CORNER, true);
        data.m_128356_(KEY_SPAWN_TIME, level.m_46467_());
        data.m_128379_(KEY_RUNNING, false);
        data.m_128473_(KEY_LOOK_START);
        data.m_128473_(KEY_RUN_START);
        data.m_128379_(KEY_FROZEN, false);
        data.m_128379_(KEY_DESPAWN_STARTED, false);
    }

    private static EntityType<?> chooseRandomEntity() {
        double roll = Math.random();
        if (roll < 0.4) {
            return (EntityType)FromTheCavesModEntities.WATCHEYES.get();
        }
        if (roll < 0.7) {
            return (EntityType)FromTheCavesModEntities.FROMTHECAVESSHADOWLARGE.get();
        }
        return (EntityType)FromTheCavesModEntities.FROMTHECAVESSHADOWSPIDER.get();
    }

    private static BlockPos findDarkCornerInHouse(ServerLevel level, Player player) {
        BlockPos playerPos = player.m_20183_();
        for (int attempt = 0; attempt < 30; ++attempt) {
            double angle = Math.random() * Math.PI * 2.0;
            double dist = 5.0 + Math.random() * 20.0;
            int dx = (int)Math.round(Math.cos(angle) * dist);
            int dz = (int)Math.round(Math.sin(angle) * dist);
            for (int dy = -3; dy <= 3; ++dy) {
                double distance;
                BlockPos above;
                BlockState stateAt;
                BlockPos testPos = playerPos.m_7918_(dx, dy, dz);
                if (!level.m_46749_(testPos) || !HouseCornerStalkerProcedure.isInDarkCorner(level, testPos) || !HouseCornerStalkerProcedure.isInsideStructure(level, testPos) || !(stateAt = level.m_8055_(testPos)).m_60795_() || !level.m_8055_(above = testPos.m_7494_()).m_60795_() || !((distance = Math.sqrt(testPos.m_203193_((Position)player.m_20182_()))) >= 5.0) || !(distance <= 25.0)) continue;
                return testPos;
            }
        }
        return null;
    }

    private static boolean isInDarkCorner(ServerLevel level, BlockPos pos) {
        int[][] directions;
        int lightLevel = level.m_46803_(pos);
        if (lightLevel > 5) {
            return false;
        }
        int wallsNearby = 0;
        for (int[] dir : directions = new int[][]{{1, 0}, {-1, 0}, {0, 1}, {0, -1}}) {
            BlockState state;
            BlockPos wallCheck = pos.m_7918_(dir[0], 0, dir[1]);
            if (!level.m_46749_(wallCheck) || !HouseCornerStalkerProcedure.isStructureBlock(state = level.m_8055_(wallCheck))) continue;
            ++wallsNearby;
        }
        return wallsNearby >= 2;
    }

    private static boolean isInsideStructure(ServerLevel level, BlockPos pos) {
        int structureBlocksNearby = 0;
        int totalChecks = 0;
        for (int dx = -3; dx <= 3; ++dx) {
            for (int dy = -2; dy <= 2; ++dy) {
                for (int dz = -3; dz <= 3; ++dz) {
                    BlockPos checkPos;
                    if (dx == 0 && dy == 0 && dz == 0 || !level.m_46749_(checkPos = pos.m_7918_(dx, dy, dz))) continue;
                    ++totalChecks;
                    BlockState state = level.m_8055_(checkPos);
                    if (!HouseCornerStalkerProcedure.isStructureBlock(state)) continue;
                    ++structureBlocksNearby;
                }
            }
        }
        if (totalChecks == 0) {
            return false;
        }
        double ratio = (double)structureBlocksNearby / (double)totalChecks;
        return ratio > 0.25;
    }

    private static boolean isStructureBlock(BlockState state) {
        return state.m_204336_(BlockTags.f_13090_) || state.m_204336_(BlockTags.f_13106_) || state.m_204336_(BlockTags.f_13097_) || state.m_204336_(BlockTags.f_13096_) || state.m_204336_(BlockTags.f_13098_) || state.m_60734_() == Blocks.f_50652_ || state.m_60734_() == Blocks.f_50079_ || state.m_60734_() == Blocks.f_50222_ || state.m_60734_() == Blocks.f_50223_ || state.m_60734_() == Blocks.f_50224_ || state.m_60734_() == Blocks.f_50225_ || state.m_60734_() == Blocks.f_50076_ || state.m_60734_() == Blocks.f_50387_ || state.m_60734_() == Blocks.f_50281_ || state.m_60734_() == Blocks.f_50175_ || state.m_60734_() == Blocks.f_152555_ || state.m_60734_() == Blocks.f_152589_ || state.m_60734_() == Blocks.f_152559_ || state.m_60734_() == Blocks.f_50062_ || state.m_60734_() == Blocks.f_50394_ || state.m_60734_() == Blocks.f_50471_ || state.m_60734_() == Blocks.f_50473_ || state.m_60734_() == Blocks.f_50064_ || state.m_60734_() == Blocks.f_50396_ || state.m_60734_() == Blocks.f_50377_ || state.m_60734_() == Blocks.f_50378_ || state.m_60734_() == Blocks.f_50379_ || state.m_60734_() == Blocks.f_50734_ || state.m_60734_() == Blocks.f_50735_ || state.m_60734_() == Blocks.f_50197_ || state.m_60734_() == Blocks.f_50452_ || state.m_60734_() == Blocks.f_50259_ || state.m_60734_() == Blocks.f_50443_ || state.m_60734_() == Blocks.f_50492_ || state.m_60734_() == Blocks.f_50333_ || state.m_60734_() == Blocks.f_50472_ || state.m_60734_() == Blocks.f_50352_ || state.m_60734_() == Blocks.f_50287_ || state.m_60734_() == Blocks.f_50288_ || state.m_60734_() == Blocks.f_50289_ || state.m_60734_() == Blocks.f_50290_ || state.m_60734_() == Blocks.f_50291_ || state.m_60734_() == Blocks.f_50292_ || state.m_60734_() == Blocks.f_50293_ || state.m_60734_() == Blocks.f_50294_ || state.m_60734_() == Blocks.f_50295_ || state.m_60734_() == Blocks.f_50296_ || state.m_60734_() == Blocks.f_50297_ || state.m_60734_() == Blocks.f_50298_ || state.m_60734_() == Blocks.f_50299_ || state.m_60734_() == Blocks.f_50300_ || state.m_60734_() == Blocks.f_50301_ || state.m_60734_() == Blocks.f_50302_ || state.m_204336_(BlockTags.f_13103_) || state.m_204336_(BlockTags.f_13036_) || state.m_204336_(BlockTags.f_13100_) || state.m_204336_(BlockTags.f_13092_) || state.m_204336_(BlockTags.f_13102_) || state.m_204336_(BlockTags.f_13055_) || state.m_204336_(BlockTags.f_13032_) || state.m_204336_(BlockTags.f_13049_) || state.m_204336_(BlockTags.f_13089_) || state.m_60734_() == Blocks.f_50058_ || state.m_60734_() == Blocks.f_50147_ || state.m_60734_() == Blocks.f_50148_ || state.m_60734_() == Blocks.f_50202_ || state.m_60734_() == Blocks.f_50203_ || state.m_60734_() == Blocks.f_50204_ || state.m_60734_() == Blocks.f_50205_ || state.m_60734_() == Blocks.f_50206_ || state.m_60734_() == Blocks.f_50207_ || state.m_60734_() == Blocks.f_50208_ || state.m_60734_() == Blocks.f_50209_ || state.m_60734_() == Blocks.f_50210_ || state.m_60734_() == Blocks.f_50211_ || state.m_60734_() == Blocks.f_50212_ || state.m_60734_() == Blocks.f_50213_ || state.m_60734_() == Blocks.f_50214_ || state.m_60734_() == Blocks.f_50215_ || state.m_60734_() == Blocks.f_50303_ || state.m_60734_() == Blocks.f_50304_ || state.m_60734_() == Blocks.f_50305_ || state.m_60734_() == Blocks.f_50306_ || state.m_60734_() == Blocks.f_50307_ || state.m_60734_() == Blocks.f_50361_ || state.m_60734_() == Blocks.f_50362_ || state.m_60734_() == Blocks.f_50363_ || state.m_60734_() == Blocks.f_50364_ || state.m_60734_() == Blocks.f_50365_ || state.m_60734_() == Blocks.f_50366_ || state.m_60734_() == Blocks.f_50367_ || state.m_60734_() == Blocks.f_50368_ || state.m_60734_() == Blocks.f_50369_ || state.m_60734_() == Blocks.f_50370_ || state.m_60734_() == Blocks.f_50371_ || state.m_60734_() == Blocks.f_50185_ || state.m_60734_() == Blocks.f_50183_ || state.m_60734_() == Blocks.f_50087_ || state.m_60734_() == Blocks.f_50325_ || state.m_60734_() == Blocks.f_50094_ || state.m_60734_() == Blocks.f_50620_ || state.m_60734_() == Blocks.f_50619_ || state.m_60734_() == Blocks.f_50091_ || state.m_60734_() == Blocks.f_50078_ || state.m_60734_() == Blocks.f_50201_ || state.m_60734_() == Blocks.f_50322_ || state.m_60734_() == Blocks.f_50323_ || state.m_60734_() == Blocks.f_50324_ || state.m_60734_() == Blocks.f_50255_ || state.m_60734_() == Blocks.f_50256_ || state.m_60734_() == Blocks.f_152476_ || state.m_60734_() == Blocks.f_152477_ || state.m_60734_() == Blocks.f_152478_ || state.m_60734_() == Blocks.f_50618_ || state.m_60734_() == Blocks.f_50715_ || state.m_60734_() == Blocks.f_50623_ || state.m_60734_() == Blocks.f_50617_ || state.m_60734_() == Blocks.f_50679_ || state.m_60734_() == Blocks.f_50621_ || state.m_60734_() == Blocks.f_50622_ || state.m_60734_() == Blocks.f_50625_ || state.m_60734_() == Blocks.f_50066_ || state.m_60734_() == Blocks.f_50067_ || state.m_60734_() == Blocks.f_50068_ || state.m_60734_() == Blocks.f_50017_ || state.m_60734_() == Blocks.f_50018_ || state.m_60734_() == Blocks.f_50019_ || state.m_60734_() == Blocks.f_50020_ || state.m_60734_() == Blocks.f_50021_ || state.m_60734_() == Blocks.f_50022_ || state.m_60734_() == Blocks.f_50023_ || state.m_60734_() == Blocks.f_50024_ || state.m_60734_() == Blocks.f_50025_ || state.m_60734_() == Blocks.f_50026_ || state.m_60734_() == Blocks.f_50027_ || state.m_60734_() == Blocks.f_50028_ || state.m_60734_() == Blocks.f_50029_ || state.m_60734_() == Blocks.f_50155_ || state.m_60734_() == Blocks.f_50616_ || state.m_60734_() == Blocks.f_50542_ || state.m_60734_() == Blocks.f_50543_ || state.m_60734_() == Blocks.f_50544_ || state.m_60734_() == Blocks.f_50545_ || state.m_60734_() == Blocks.f_50494_ || state.m_60734_() == Blocks.f_50495_ || state.m_60734_() == Blocks.f_50496_ || state.m_60734_() == Blocks.f_50497_ || state.m_60734_() == Blocks.f_50498_ || state.m_60734_() == Blocks.f_50499_ || state.m_60734_() == Blocks.f_50500_ || state.m_60734_() == Blocks.f_50501_ || state.m_60734_() == Blocks.f_50502_ || state.m_60734_() == Blocks.f_50503_ || state.m_60734_() == Blocks.f_50504_ || state.m_60734_() == Blocks.f_50505_ || state.m_60734_() == Blocks.f_50506_ || state.m_60734_() == Blocks.f_50507_ || state.m_60734_() == Blocks.f_50508_ || state.m_60734_() == Blocks.f_50509_ || state.m_60734_() == Blocks.f_50510_ || state.m_60734_() == Blocks.f_50511_ || state.m_60734_() == Blocks.f_50512_ || state.m_60734_() == Blocks.f_50513_ || state.m_60734_() == Blocks.f_50514_ || state.m_60734_() == Blocks.f_50515_ || state.m_60734_() == Blocks.f_50516_ || state.m_60734_() == Blocks.f_50517_ || state.m_60734_() == Blocks.f_50518_ || state.m_60734_() == Blocks.f_50519_ || state.m_60734_() == Blocks.f_50573_ || state.m_60734_() == Blocks.f_50574_ || state.m_60734_() == Blocks.f_50526_ || state.m_60734_() == Blocks.f_50527_ || state.m_60734_() == Blocks.f_50528_ || state.m_60734_() == Blocks.f_50529_ || state.m_60734_() == Blocks.f_50530_ || state.m_60734_() == Blocks.f_50531_ || state.m_60734_() == Blocks.f_50532_ || state.m_60734_() == Blocks.f_50533_ || state.m_60734_() == Blocks.f_50534_ || state.m_60734_() == Blocks.f_50535_ || state.m_60734_() == Blocks.f_50536_ || state.m_60734_() == Blocks.f_50537_ || state.m_60734_() == Blocks.f_50538_ || state.m_60734_() == Blocks.f_50539_ || state.m_60734_() == Blocks.f_50540_ || state.m_60734_() == Blocks.f_50541_ || state.m_60734_() == Blocks.f_50274_ || state.m_60734_() == Blocks.f_50275_ || state.m_60734_() == Blocks.f_50609_ || state.m_60734_() == Blocks.f_50607_ || state.m_60734_() == Blocks.f_50611_ || state.m_60734_() == Blocks.f_50615_ || state.m_60734_() == Blocks.f_50608_ || state.m_60734_() == Blocks.f_50605_ || state.m_60734_() == Blocks.f_50613_ || state.m_60734_() == Blocks.f_50606_ || state.m_60734_() == Blocks.f_50604_ || state.m_60734_() == Blocks.f_50610_ || state.m_60734_() == Blocks.f_50612_ || state.m_60734_() == Blocks.f_50614_ || state.m_60734_() == Blocks.f_50732_ || state.m_60734_() == Blocks.f_50711_ || state.m_60734_() == Blocks.f_50740_ || state.m_60734_() == Blocks.f_152592_ || state.m_60734_() == Blocks.f_152562_ || state.m_60734_() == Blocks.f_152554_ || state.m_60734_() == Blocks.f_152558_ || state.m_60734_() == Blocks.f_152594_ || state.m_60734_() == Blocks.f_152595_ || state.m_60734_() == Blocks.f_50224_ || state.m_60734_() == Blocks.f_50713_ || state.m_60734_() == Blocks.f_50736_ || state.m_60734_() == Blocks.f_152593_ || state.m_60734_() == Blocks.f_50712_ || state.m_60734_() == Blocks.f_50737_ || state.m_60734_() == Blocks.f_50282_ || state.m_60734_() == Blocks.f_50395_ || state.m_60734_() == Blocks.f_50063_ || state.m_60734_() == Blocks.f_50714_ || state.m_60734_() == Blocks.f_50283_ || state.m_60734_() == Blocks.f_50284_ || state.m_60734_() == Blocks.f_50637_ || state.m_60734_() == Blocks.f_50413_ || state.m_60734_() == Blocks.f_50650_ || state.m_60734_() == Blocks.f_50441_ || state.m_60734_() == Blocks.f_50469_ || state.m_60734_() == Blocks.f_50442_ || state.m_60734_() == Blocks.f_50041_ || state.m_60734_() == Blocks.f_50042_ || state.m_60734_() == Blocks.f_50096_ || state.m_60734_() == Blocks.f_50097_ || state.m_60734_() == Blocks.f_50098_ || state.m_60734_() == Blocks.f_50099_ || state.m_60734_() == Blocks.f_50100_ || state.m_60734_() == Blocks.f_50101_ || state.m_60734_() == Blocks.f_50102_ || state.m_60734_() == Blocks.f_50103_ || state.m_60734_() == Blocks.f_50104_ || state.m_60734_() == Blocks.f_50105_ || state.m_60734_() == Blocks.f_50106_ || state.m_60734_() == Blocks.f_50107_ || state.m_60734_() == Blocks.f_50108_ || state.m_60734_() == Blocks.f_50109_ || state.m_60734_() == Blocks.f_50336_ || state.m_60734_() == Blocks.f_50337_ || state.m_60734_() == Blocks.f_50338_ || state.m_60734_() == Blocks.f_50339_ || state.m_60734_() == Blocks.f_50340_ || state.m_60734_() == Blocks.f_50341_ || state.m_60734_() == Blocks.f_50342_ || state.m_60734_() == Blocks.f_50343_ || state.m_60734_() == Blocks.f_50344_ || state.m_60734_() == Blocks.f_50345_ || state.m_60734_() == Blocks.f_50346_ || state.m_60734_() == Blocks.f_50347_ || state.m_60734_() == Blocks.f_50348_ || state.m_60734_() == Blocks.f_50349_ || state.m_60734_() == Blocks.f_50350_ || state.m_60734_() == Blocks.f_50351_;
    }

    private static void makeEntityLookAtPlayer(Mob mob, Player player) {
        double dx = player.m_20185_() - mob.m_20185_();
        double dz = player.m_20189_() - mob.m_20189_();
        float yaw = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - 90.0f;
        mob.m_146922_(yaw);
        mob.f_20883_ = yaw;
        mob.f_20885_ = yaw;
        double dy = player.m_20188_() - mob.m_20188_();
        double horizontalDist = Math.sqrt(dx * dx + dz * dz);
        float pitch = (float)(Math.atan2(dy, horizontalDist) * 180.0 / Math.PI);
        mob.m_146926_(pitch);
    }

    @SubscribeEvent
    public static void onMobTick(LivingEvent.LivingTickEvent ev) {
        LivingEntity ent = ev.getEntity();
        if (!(ent instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)ent;
        EntityType type = mob.m_6095_();
        if (!(type.equals(FromTheCavesModEntities.WATCHEYES.get()) || type.equals(FromTheCavesModEntities.FROMTHECAVESSHADOWLARGE.get()) || type.equals(FromTheCavesModEntities.FROMTHECAVESSHADOWSPIDER.get()))) {
            return;
        }
        CompoundTag data = mob.getPersistentData();
        if (!data.m_128471_(KEY_HOUSE_CORNER)) {
            return;
        }
        if (mob.m_9236_().f_46443_) {
            return;
        }
        ServerLevel level = (ServerLevel)mob.m_9236_();
        long now = level.m_46467_();
        Player player = level.m_45930_((Entity)mob, 60.0);
        if (player == null) {
            mob.m_146870_();
            return;
        }
        double dist = mob.m_20270_((Entity)player);
        boolean running = data.m_128471_(KEY_RUNNING);
        boolean frozen = data.m_128471_(KEY_FROZEN);
        if (frozen) {
            HouseCornerStalkerProcedure.handleFrozenBehavior(mob, data, level, player, now);
            return;
        }
        if (!running) {
            HouseCornerStalkerProcedure.handleWatchingBehavior(mob, data, level, player, now, dist);
            return;
        }
        HouseCornerStalkerProcedure.handleFleeingBehavior(mob, data, level, player, now);
    }

    private static void handleWatchingBehavior(Mob mob, CompoundTag data, ServerLevel level, Player player, long now, double dist) {
        double vanishRoll;
        boolean inSightCone;
        HouseCornerStalkerProcedure.makeEntityLookAtPlayer(mob, player);
        mob.m_20334_(0.0, mob.m_20184_().f_82480_, 0.0);
        if (dist <= 4.0) {
            HouseCornerStalkerProcedure.startRunning(mob, data, now);
            return;
        }
        boolean hasLOS = player.m_142582_((Entity)mob);
        Vec3 playerLook = player.m_20252_(1.0f).m_82541_();
        Vec3 toMob = new Vec3(mob.m_20185_() - player.m_20185_(), mob.m_20186_() - player.m_20186_(), mob.m_20189_() - player.m_20189_());
        if (toMob.m_82553_() == 0.0) {
            data.m_128473_(KEY_LOOK_START);
            return;
        }
        Vec3 toMobNorm = toMob.m_82541_();
        double dot = playerLook.f_82479_ * toMobNorm.f_82479_ + playerLook.f_82480_ * toMobNorm.f_82480_ + playerLook.f_82481_ * toMobNorm.f_82481_;
        boolean bl = inSightCone = dot > 0.9 && hasLOS;
        if (inSightCone) {
            if (!data.m_128441_(KEY_LOOK_START)) {
                data.m_128356_(KEY_LOOK_START, now);
            } else {
                long started = data.m_128454_(KEY_LOOK_START);
                if (now - started >= 140L) {
                    double freezeRoll = Math.random();
                    if (freezeRoll < 0.2) {
                        data.m_128379_(KEY_FROZEN, true);
                        data.m_128356_(KEY_FADE_START, now);
                    } else {
                        HouseCornerStalkerProcedure.startRunning(mob, data, now);
                    }
                    return;
                }
            }
        } else {
            data.m_128473_(KEY_LOOK_START);
        }
        long spawnTime = data.m_128454_(KEY_SPAWN_TIME);
        if (now - spawnTime > 800L && (vanishRoll = Math.random()) < 0.03 && !hasLOS) {
            mob.m_146870_();
            return;
        }
    }

    private static void handleFrozenBehavior(Mob mob, CompoundTag data, ServerLevel level, Player player, long now) {
        mob.m_20334_(0.0, mob.m_20184_().f_82480_, 0.0);
        mob.m_21557_(true);
        long fadeStart = data.m_128454_(KEY_FADE_START);
        long fadeDuration = 80L;
        if (now - fadeStart >= fadeDuration) {
            mob.m_146870_();
            return;
        }
        boolean hasLOS = player.m_142582_((Entity)mob);
        if (!hasLOS) {
            mob.m_146870_();
            return;
        }
    }

    private static void handleFleeingBehavior(Mob mob, CompoundTag data, ServerLevel level, Player player, long now) {
        boolean despawnStarted = data.m_128471_(KEY_DESPAWN_STARTED);
        boolean hasLOS = player.m_142582_((Entity)mob);
        double dist = mob.m_20270_((Entity)player);
        if (!hasLOS && dist > 25.0) {
            if (!data.m_128441_(KEY_HIDDEN_START)) {
                data.m_128356_(KEY_HIDDEN_START, now);
            } else {
                long hiddenTime = now - data.m_128454_(KEY_HIDDEN_START);
                if (hiddenTime >= 60L) {
                    if (!despawnStarted) {
                        data.m_128379_(KEY_DESPAWN_STARTED, true);
                        data.m_128356_(KEY_DESPAWN_DELAY, now);
                    } else {
                        long despawnTime = now - data.m_128454_(KEY_DESPAWN_DELAY);
                        if (despawnTime >= 20L) {
                            mob.m_146870_();
                            return;
                        }
                    }
                }
            }
        } else {
            data.m_128473_(KEY_HIDDEN_START);
            data.m_128379_(KEY_DESPAWN_STARTED, false);
        }
        Vec3 fleeDir = new Vec3(mob.m_20185_() - player.m_20185_(), 0.0, mob.m_20189_() - player.m_20189_());
        if (fleeDir.m_82556_() < 1.0E-6) {
            Vec3 look = player.m_20252_(1.0f).m_82541_();
            fleeDir = new Vec3(-look.f_82479_, 0.0, -look.f_82481_);
        }
        Vec3 targetDir = new Vec3(fleeDir.f_82479_, 0.0, fleeDir.f_82481_).m_82541_();
        mob.m_21557_(true);
        mob.m_20242_(false);
        mob.f_19794_ = true;
        double speedFactor = 0.6;
        BlockPos belowPos = mob.m_20183_().m_7495_();
        boolean onGround = true;
        if (level.m_46749_(belowPos)) {
            BlockState belowState = level.m_8055_(belowPos);
            onGround = !belowState.m_60795_();
        }
        double currentY = mob.m_20184_().f_82480_;
        double newY = onGround ? Math.min(currentY, 0.0) : currentY - 0.21;
        Vec3 motion = new Vec3(targetDir.f_82479_ * speedFactor, newY, targetDir.f_82481_ * speedFactor);
        mob.m_20256_(motion);
        double newX = mob.m_20185_() + motion.f_82479_;
        double newY_pos = mob.m_20186_() + motion.f_82480_;
        double newZ = mob.m_20189_() + motion.f_82481_;
        mob.m_6021_(newX, newY_pos, newZ);
        if (data.m_128441_(KEY_RUN_START)) {
            long runStart = data.m_128454_(KEY_RUN_START);
            if (now - runStart >= 240L) {
                mob.m_146870_();
                return;
            }
        } else {
            data.m_128356_(KEY_RUN_START, now);
        }
    }

    private static void startRunning(Mob mob, CompoundTag data, long now) {
        data.m_128379_(KEY_RUNNING, true);
        data.m_128356_(KEY_RUN_START, now);
        mob.m_21557_(true);
        mob.m_20242_(false);
        data.m_128379_(KEY_DESPAWN_STARTED, false);
    }
}

