/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.mcreator.fromthecaves.init.FromTheCavesModEntities;
import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.mcreator.fromthecaves.procedures.PhotosensitiveSafetyProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="from_the_caves", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class RunParticlesProcedure {
    private static final double BASE_PROB = 5.0E-6;
    private static final double MAX_PROB = 2.0E-5;
    private static final int PARTICLE_COUNT = 8;
    private static final int MIN_TICKS_BETWEEN = 15;
    private static final int MAX_TICKS_BETWEEN = 25;
    private static final double PARTICLE_DISTANCE = 2.0;
    private static final double DISTANCE_JITTER = 0.4;
    private static final double HEIGHT_JITTER = 0.5;
    private static final Map<UUID, SequenceState> activeFootsteps = new ConcurrentHashMap<UUID, SequenceState>();
    private static final Map<UUID, EventState> activeEvents = new ConcurrentHashMap<UUID, EventState>();
    private static final Map<BlockPos, Long> lightCooldowns = new ConcurrentHashMap<BlockPos, Long>();

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        EventState eventState;
        SequenceState state;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (event.player.m_9236_().m_5776_()) {
            return;
        }
        Level level = event.player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        ServerPlayer player = (ServerPlayer)event.player;
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server);
        if (phase != 1 && phase != 2) {
            activeFootsteps.remove(player.m_20148_());
            return;
        }
        UUID pid = player.m_20148_();
        if (!activeFootsteps.containsKey(pid)) {
            double dynamicProb = ChunkTensionProcedure.getDynamicProbability(server, (Player)player, 5.0E-6, 2.0E-5);
            if (server.f_46441_.m_188500_() < dynamicProb) {
                SequenceState newState = new SequenceState();
                newState.nextDelay = 15 + server.f_46441_.m_188503_(11);
                activeFootsteps.put(pid, newState);
            }
        }
        if ((state = activeFootsteps.get(pid)) != null) {
            ++state.tickCounter;
            if (state.tickCounter >= state.nextDelay) {
                SoundEvent stepSound;
                BlockParticleOption dust;
                int offsetZ;
                int offsetY;
                int offsetX;
                state.tickCounter = 0;
                Vec3 base = player.m_20182_().m_82520_(0.0, 0.25, 0.0);
                double angle = server.f_46441_.m_188500_() * Math.PI * 2.0;
                double radius = 2.0 + (server.f_46441_.m_188500_() * 2.0 - 1.0) * 0.4;
                double px = base.f_82479_ + Math.cos(angle) * radius;
                double pz = base.f_82481_ + Math.sin(angle) * radius;
                double py = player.m_20186_() + server.f_46441_.m_188500_() * 0.5;
                BlockPos playerBlock = player.m_20183_();
                BlockPos nearbyPos = playerBlock.m_7918_(offsetX = server.f_46441_.m_188503_(3) - 1, offsetY = server.f_46441_.m_188503_(3) - 1, offsetZ = server.f_46441_.m_188503_(3) - 1);
                BlockState nearbyState = server.m_8055_(nearbyPos);
                if (!nearbyState.m_60795_()) {
                    dust = new BlockParticleOption(ParticleTypes.f_123794_, nearbyState);
                    stepSound = nearbyState.m_60827_().m_56776_();
                } else {
                    BlockPos floorPos = player.m_20183_().m_7495_();
                    BlockState floorState = server.m_8055_(floorPos);
                    dust = new BlockParticleOption(ParticleTypes.f_123794_, floorState);
                    stepSound = floorState.m_60827_().m_56776_();
                }
                server.m_8767_((ParticleOptions)dust, px, py, pz, 2, 0.0, 0.0, 0.0, 0.0);
                if (stepSound != null) {
                    BlockPos soundPos = new BlockPos((int)Math.floor(px), (int)Math.floor(py), (int)Math.floor(pz));
                    float volume = 0.7f + server.f_46441_.m_188501_() * 0.4f;
                    float pitch = 0.8f + server.f_46441_.m_188501_() * 0.4f;
                    server.m_5594_(null, soundPos, stepSound, SoundSource.BLOCKS, volume, pitch);
                }
                ++state.spawned;
                if (state.spawned >= 8) {
                    activeFootsteps.remove(pid);
                    if (!activeEvents.containsKey(pid)) {
                        int eventType = server.f_46441_.m_188503_(15);
                        Vec3 eventPos = RunParticlesProcedure.calculateEventPosition(player, server, eventType);
                        activeEvents.put(pid, new EventState(eventType, eventPos, server.m_46467_()));
                    }
                } else {
                    state.nextDelay = 15 + server.f_46441_.m_188503_(11);
                }
            }
        }
        if ((eventState = activeEvents.get(pid)) != null) {
            ++eventState.tickCounter;
            switch (eventState.eventType) {
                case 0: {
                    RunParticlesProcedure.handleStaticWatcher(player, server, eventState);
                    break;
                }
                case 1: {
                    RunParticlesProcedure.handleCirclingShadow(player, server, eventState);
                    break;
                }
                case 2: {
                    RunParticlesProcedure.handleCornerLurker(player, server, eventState);
                    break;
                }
                case 3: {
                    RunParticlesProcedure.handleBehindStalker(player, server, eventState);
                    break;
                }
                case 4: {
                    RunParticlesProcedure.handleDistantObserver(player, server, eventState);
                    break;
                }
                case 5: {
                    RunParticlesProcedure.handleSideDasher(player, server, eventState);
                    break;
                }
                case 6: {
                    RunParticlesProcedure.handlePeekAndHide(player, server, eventState);
                    break;
                }
                case 7: {
                    RunParticlesProcedure.handleMimicMovement(player, server, eventState);
                    break;
                }
                case 8: {
                    RunParticlesProcedure.handleFlickeringLights(player, server, eventState);
                    break;
                }
                case 9: {
                    RunParticlesProcedure.handleWhisperCircle(player, server, eventState);
                    break;
                }
                case 10: {
                    RunParticlesProcedure.handleSlowApproach(player, server, eventState);
                    break;
                }
                case 11: {
                    RunParticlesProcedure.handleTeleportStalker(player, server, eventState);
                    break;
                }
                case 12: {
                    RunParticlesProcedure.handleRoamingWatcher(player, server, eventState);
                    break;
                }
                case 13: {
                    RunParticlesProcedure.handleDarknessEvent(player, server, eventState);
                    break;
                }
                case 14: {
                    RunParticlesProcedure.handleBreathingPresence(player, server, eventState);
                }
            }
            if (eventState.tickCounter > 600) {
                RunParticlesProcedure.cleanupEvent(eventState, player.m_20148_());
            }
        }
    }

    private static Vec3 calculateEventPosition(ServerPlayer player, ServerLevel server, int eventType) {
        double angle = server.f_46441_.m_188500_() * Math.PI * 2.0;
        double distance = eventType == 4 || eventType == 12 ? 20.0 + server.f_46441_.m_188500_() * 15.0 : (eventType == 5 ? 12.0 : 8.0 + server.f_46441_.m_188500_() * 8.0);
        double x = player.m_20185_() + Math.cos(angle) * distance;
        double z = player.m_20189_() + Math.sin(angle) * distance;
        double y = player.m_20186_();
        return new Vec3(x, y, z);
    }

    private static void handleStaticWatcher(ServerPlayer player, ServerLevel server, EventState state) {
        Mob entity;
        if (!state.spawned && (entity = RunParticlesProcedure.spawnShadowMob(server, state.targetPos)) != null) {
            entity.m_21557_(true);
            state.spawned = true;
            state.spawnedMob = entity;
        }
        if (RunParticlesProcedure.checkDespawnConditions(state, player, server, 4.0)) {
            return;
        }
        if (state.tickCounter % 30 == 0) {
            RunParticlesProcedure.playCustomSound(server, player.m_20183_(), "one_heart", 0.5f, 0.8f);
        }
    }

    private static void handleCirclingShadow(ServerPlayer player, ServerLevel server, EventState state) {
        Mob entity;
        if (!state.spawned && (entity = RunParticlesProcedure.spawnShadowMob(server, state.targetPos)) != null) {
            state.spawned = true;
            state.spawnedMob = entity;
        }
        if (state.spawnedMob != null && state.spawnedMob.m_6084_()) {
            state.circleAngle += 3.0;
            if (state.circleAngle >= 360.0) {
                state.circleAngle -= 360.0;
            }
            double angleRad = Math.toRadians(state.circleAngle);
            double radius = 10.0;
            double newX = player.m_20185_() + Math.cos(angleRad) * radius;
            double newZ = player.m_20189_() + Math.sin(angleRad) * radius;
            state.spawnedMob.m_7678_(newX, player.m_20186_(), newZ, 0.0f, 0.0f);
        }
        if (RunParticlesProcedure.checkDespawnConditions(state, player, server, 6.0)) {
            return;
        }
        if (state.tickCounter % 25 == 0) {
            RunParticlesProcedure.playCustomSound(server, player.m_20183_(), "one_heart", 0.6f, 1.0f);
        }
    }

    private static void handleCornerLurker(ServerPlayer player, ServerLevel server, EventState state) {
        Vec3 right;
        if (!state.spawned) {
            right = player.m_20154_().m_82524_((float)Math.toRadians(90.0)).m_82490_(8.0);
            Vec3 spawnPos = player.m_20182_().m_82549_(right);
            Mob entity = RunParticlesProcedure.spawnShadowMob(server, spawnPos);
            if (entity != null) {
                state.spawned = true;
                state.spawnedMob = entity;
                state.targetPos = spawnPos;
            }
        }
        if (state.spawnedMob != null && state.spawnedMob.m_6084_() && state.tickCounter % 80 == 0) {
            right = player.m_20154_().m_82524_((float)Math.toRadians(server.f_46441_.m_188499_() ? 90.0 : -90.0)).m_82490_(8.0);
            Vec3 newPos = player.m_20182_().m_82549_(right);
            state.spawnedMob.m_7678_(newPos.f_82479_, newPos.f_82480_, newPos.f_82481_, 0.0f, 0.0f);
            RunParticlesProcedure.playCustomSound(server, player.m_20183_(), "it_28", 0.5f, 1.0f);
        }
        if (RunParticlesProcedure.checkDespawnConditions(state, player, server, 4.5)) {
            return;
        }
        if (state.tickCounter % 30 == 0) {
            RunParticlesProcedure.playCustomSound(server, player.m_20183_(), "one_heart", 0.5f, 0.9f);
        }
    }

    private static void handleBehindStalker(ServerPlayer player, ServerLevel server, EventState state) {
        if (!state.spawned && state.tickCounter == 60) {
            Vec3 behind = player.m_20182_().m_82549_(player.m_20154_().m_82490_(-6.0));
            Mob entity = (Mob)((EntityType)FromTheCavesModEntities.FROMTHECAVESBEHIND.get()).m_262496_(server, BlockPos.m_274446_((Position)behind), MobSpawnType.MOB_SUMMONED);
            if (entity != null) {
                entity.m_7678_(behind.f_82479_, behind.f_82480_, behind.f_82481_, 0.0f, 0.0f);
                server.m_7967_((Entity)entity);
                state.spawned = true;
                state.spawnedMob = entity;
                RunParticlesProcedure.makeAlwaysSeePlayer(entity);
            }
        }
        if (RunParticlesProcedure.checkDespawnConditions(state, player, server, 5.0)) {
            return;
        }
        if (state.tickCounter % 25 == 0) {
            RunParticlesProcedure.playCustomSound(server, player.m_20183_(), "one_heart", 0.6f, 1.0f);
        }
    }

    private static void handleDistantObserver(ServerPlayer player, ServerLevel server, EventState state) {
        Mob entity;
        if (!state.spawned && (entity = (Mob)((EntityType)FromTheCavesModEntities.FROMTHECAVESBEHIND.get()).m_262496_(server, BlockPos.m_274446_((Position)state.targetPos), MobSpawnType.MOB_SUMMONED)) != null) {
            entity.m_7678_(state.targetPos.f_82479_, state.targetPos.f_82480_, state.targetPos.f_82481_, 0.0f, 0.0f);
            entity.m_21557_(true);
            server.m_7967_((Entity)entity);
            state.spawned = true;
            state.spawnedMob = entity;
            RunParticlesProcedure.makeAlwaysSeePlayer(entity);
        }
        if (RunParticlesProcedure.checkDespawnConditions(state, player, server, 8.0)) {
            return;
        }
        if (state.tickCounter % 35 == 0) {
            RunParticlesProcedure.playCustomSound(server, player.m_20183_(), "one_heart", 0.4f, 0.8f);
        }
    }

    private static void handleSideDasher(ServerPlayer player, ServerLevel server, EventState state) {
        Vec3 right;
        if (state.tickCounter == 1) {
            right = player.m_20154_().m_82524_((float)Math.toRadians(90.0)).m_82490_(12.0);
            Vec3 startPos = player.m_20182_().m_82549_(right);
            Mob entity = RunParticlesProcedure.spawnShadowMob(server, startPos);
            if (entity != null) {
                state.spawned = true;
                state.spawnedMob = entity;
                state.targetPos = startPos;
            }
        }
        if (state.tickCounter >= 20 && state.tickCounter <= 60 && state.spawnedMob != null && state.spawnedMob.m_6084_()) {
            Vec3 currentPos;
            right = player.m_20154_().m_82524_((float)Math.toRadians(90.0));
            state.targetPos = currentPos = state.targetPos.m_82549_(right.m_82490_(-0.6));
            state.spawnedMob.m_7678_(currentPos.f_82479_, currentPos.f_82480_, currentPos.f_82481_, 0.0f, 0.0f);
        }
        if (state.tickCounter >= 65) {
            RunParticlesProcedure.cleanupEvent(state, player.m_20148_());
            return;
        }
        if (state.tickCounter % 25 == 0) {
            RunParticlesProcedure.playCustomSound(server, player.m_20183_(), "one_heart", 0.6f, 1.0f);
        }
    }

    private static void handlePeekAndHide(ServerPlayer player, ServerLevel server, EventState state) {
        Mob entity;
        if (!state.spawned && (entity = RunParticlesProcedure.spawnShadowMob(server, state.targetPos)) != null) {
            state.spawned = true;
            state.spawnedMob = entity;
        }
        if (state.spawnedMob != null && state.spawnedMob.m_6084_()) {
            int phase = state.tickCounter / 60 % 2;
            if (phase == 0 && state.tickCounter % 60 == 0) {
                Vec3 awayDir = state.spawnedMob.m_20182_().m_82546_(player.m_20182_()).m_82541_();
                Vec3 hidePos = state.spawnedMob.m_20182_().m_82549_(awayDir.m_82490_(3.0));
                state.spawnedMob.m_7678_(hidePos.f_82479_, hidePos.f_82480_, hidePos.f_82481_, 0.0f, 0.0f);
            } else if (phase == 1 && state.tickCounter % 60 == 30) {
                Vec3 towardsDir = player.m_20182_().m_82546_(state.spawnedMob.m_20182_()).m_82541_();
                Vec3 peekPos = state.spawnedMob.m_20182_().m_82549_(towardsDir.m_82490_(2.0));
                state.spawnedMob.m_7678_(peekPos.f_82479_, peekPos.f_82480_, peekPos.f_82481_, 0.0f, 0.0f);
            }
        }
        if (RunParticlesProcedure.checkDespawnConditions(state, player, server, 5.0)) {
            return;
        }
        if (state.tickCounter % 30 == 0) {
            RunParticlesProcedure.playCustomSound(server, player.m_20183_(), "one_heart", 0.5f, 0.9f);
        }
    }

    private static void handleMimicMovement(ServerPlayer player, ServerLevel server, EventState state) {
        Vec3 playerMovement;
        Mob entity;
        if (!state.spawned && (entity = RunParticlesProcedure.spawnShadowMob(server, state.targetPos)) != null) {
            state.spawned = true;
            state.spawnedMob = entity;
        }
        if (state.spawnedMob != null && state.spawnedMob.m_6084_() && state.tickCounter % 20 == 0 && (playerMovement = player.m_20184_()).m_82556_() > 0.01) {
            Vec3 mirroredMovement = playerMovement.m_82490_(-3.0);
            Vec3 newPos = state.spawnedMob.m_20182_().m_82549_(mirroredMovement);
            state.spawnedMob.m_7678_(newPos.f_82479_, newPos.f_82480_, newPos.f_82481_, 0.0f, 0.0f);
        }
        if (RunParticlesProcedure.checkDespawnConditions(state, player, server, 5.0)) {
            return;
        }
        if (state.tickCounter % 30 == 0) {
            RunParticlesProcedure.playCustomSound(server, player.m_20183_(), "one_heart", 0.5f, 1.0f);
        }
    }

    private static void handleFlickeringLights(ServerPlayer player, ServerLevel server, EventState state) {
        BlockState newState;
        Block current;
        if (PhotosensitiveSafetyProcedure.isPhotosensitiveModeEnabled((LevelAccessor)server)) {
            activeEvents.remove(player.m_20148_());
            return;
        }
        if (state.tickCounter == 1) {
            state.torches = RunParticlesProcedure.findNearbyTorches(server, player);
            if (state.torches.isEmpty()) {
                activeEvents.remove(player.m_20148_());
                return;
            }
            long currentTime = server.m_46467_();
            state.torches.removeIf(torch -> lightCooldowns.containsKey(torch.pos) && currentTime < lightCooldowns.get(torch.pos));
            if (state.torches.isEmpty()) {
                activeEvents.remove(player.m_20148_());
                return;
            }
            state.torches.forEach(torch -> lightCooldowns.put(torch.pos, currentTime + 600L));
        }
        Block unlitFloor = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("from_the_caves", "ftcunlittorch"));
        Block unlitWall = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("from_the_caves", "ftcunlittorchwall"));
        if (unlitFloor == null || unlitWall == null) {
            activeEvents.remove(player.m_20148_());
            return;
        }
        if (state.tickCounter % 15 == 0) {
            state.flickerPhase = (state.flickerPhase + 1) % 2;
            if (state.flickerPhase == 0) {
                for (TorchInfo torch2 : state.torches) {
                    BlockState newState2;
                    if (torch2.isWall) {
                        newState2 = (BlockState)unlitWall.m_49966_().m_61124_((Property)WallTorchBlock.f_58119_, (Comparable)torch2.facing);
                        server.m_7731_(torch2.pos, newState2, 3);
                        continue;
                    }
                    if (torch2.isCandle || torch2.isCandleCake) {
                        newState2 = (BlockState)torch2.state.m_61124_((Property)CandleBlock.f_152791_, (Comparable)Boolean.valueOf(false));
                        server.m_7731_(torch2.pos, newState2, 3);
                        continue;
                    }
                    server.m_7731_(torch2.pos, unlitFloor.m_49966_(), 3);
                }
            } else {
                for (TorchInfo torch2 : state.torches) {
                    current = server.m_8055_(torch2.pos).m_60734_();
                    if (current == unlitFloor || current == unlitWall) {
                        server.m_7731_(torch2.pos, torch2.state, 3);
                        continue;
                    }
                    if (!torch2.isCandle && !torch2.isCandleCake) continue;
                    newState = (BlockState)torch2.state.m_61124_((Property)CandleBlock.f_152791_, (Comparable)Boolean.valueOf(true));
                    server.m_7731_(torch2.pos, newState, 3);
                }
            }
        }
        if (state.tickCounter % 25 == 0) {
            RunParticlesProcedure.playCustomSound(server, player.m_20183_(), "one_heart", 0.6f, 1.0f);
        }
        if (state.tickCounter >= 300) {
            for (TorchInfo torch2 : state.torches) {
                current = server.m_8055_(torch2.pos).m_60734_();
                if (current == unlitFloor || current == unlitWall) {
                    server.m_7731_(torch2.pos, torch2.state, 3);
                    continue;
                }
                if (!torch2.isCandle && !torch2.isCandleCake) continue;
                newState = (BlockState)torch2.state.m_61124_((Property)CandleBlock.f_152791_, (Comparable)Boolean.valueOf(true));
                server.m_7731_(torch2.pos, newState, 3);
            }
            activeEvents.remove(player.m_20148_());
        }
    }

    private static void handleWhisperCircle(ServerPlayer player, ServerLevel server, EventState state) {
        if (state.tickCounter % 40 == 0) {
            double angle = server.f_46441_.m_188500_() * Math.PI * 2.0;
            double radius = 6.0 + server.f_46441_.m_188500_() * 4.0;
            double px = player.m_20185_() + Math.cos(angle) * radius;
            double pz = player.m_20189_() + Math.sin(angle) * radius;
            RunParticlesProcedure.playCustomSound(server, BlockPos.m_274561_((double)px, (double)player.m_20186_(), (double)pz), "it_6", 0.3f, 0.5f + server.f_46441_.m_188501_() * 0.3f);
        }
        if (state.tickCounter % 30 == 0) {
            RunParticlesProcedure.playCustomSound(server, player.m_20183_(), "one_heart", 0.5f, 0.8f);
        }
    }

    private static void handleSlowApproach(ServerPlayer player, ServerLevel server, EventState state) {
        Mob entity;
        if (!state.spawned && (entity = RunParticlesProcedure.spawnShadowMob(server, state.targetPos)) != null) {
            state.spawned = true;
            state.spawnedMob = entity;
        }
        if (state.spawnedMob != null && state.spawnedMob.m_6084_() && state.tickCounter % 40 == 0) {
            Vec3 toPlayer = player.m_20182_().m_82546_(state.spawnedMob.m_20182_()).m_82541_();
            Vec3 newPos = state.spawnedMob.m_20182_().m_82549_(toPlayer.m_82490_(1.0));
            state.spawnedMob.m_7678_(newPos.f_82479_, newPos.f_82480_, newPos.f_82481_, 0.0f, 0.0f);
        }
        if (RunParticlesProcedure.checkDespawnConditions(state, player, server, 3.0)) {
            return;
        }
        if (state.tickCounter % 25 == 0) {
            RunParticlesProcedure.playCustomSound(server, player.m_20183_(), "one_heart", 0.6f, 1.0f);
        }
    }

    private static void handleTeleportStalker(ServerPlayer player, ServerLevel server, EventState state) {
        Mob entity;
        if (!state.spawned && (entity = RunParticlesProcedure.spawnShadowMob(server, state.targetPos)) != null) {
            state.spawned = true;
            state.spawnedMob = entity;
        }
        if (state.spawnedMob != null && state.spawnedMob.m_6084_() && state.tickCounter % 100 == 0) {
            double angle = server.f_46441_.m_188500_() * Math.PI * 2.0;
            double distance = 8.0 + server.f_46441_.m_188500_() * 6.0;
            double newX = player.m_20185_() + Math.cos(angle) * distance;
            double newZ = player.m_20189_() + Math.sin(angle) * distance;
            state.spawnedMob.m_6021_(newX, player.m_20186_(), newZ);
            RunParticlesProcedure.playCustomSound(server, player.m_20183_(), "it_28", 0.7f, 1.0f);
        }
        if (RunParticlesProcedure.checkDespawnConditions(state, player, server, 4.0)) {
            return;
        }
        if (state.tickCounter % 30 == 0) {
            RunParticlesProcedure.playCustomSound(server, player.m_20183_(), "one_heart", 0.5f, 0.9f);
        }
    }

    private static void handleRoamingWatcher(ServerPlayer player, ServerLevel server, EventState state) {
        Mob entity;
        if (!state.spawned && (entity = (Mob)((EntityType)FromTheCavesModEntities.FROMTHECAVESBEHIND.get()).m_262496_(server, BlockPos.m_274446_((Position)state.targetPos), MobSpawnType.MOB_SUMMONED)) != null) {
            entity.m_7678_(state.targetPos.f_82479_, state.targetPos.f_82480_, state.targetPos.f_82481_, 0.0f, 0.0f);
            server.m_7967_((Entity)entity);
            state.spawned = true;
            state.spawnedMob = entity;
            RunParticlesProcedure.makeAlwaysSeePlayer(entity);
        }
        if (state.spawnedMob != null && state.spawnedMob.m_6084_() && state.tickCounter % 80 == 0) {
            double angle = server.f_46441_.m_188500_() * Math.PI * 2.0;
            double radius = 15.0 + server.f_46441_.m_188500_() * 10.0;
            double newX = player.m_20185_() + Math.cos(angle) * radius;
            double newZ = player.m_20189_() + Math.sin(angle) * radius;
            state.spawnedMob.m_7678_(newX, player.m_20186_(), newZ, 0.0f, 0.0f);
        }
        if (RunParticlesProcedure.checkDespawnConditions(state, player, server, 10.0)) {
            return;
        }
        if (state.tickCounter % 35 == 0) {
            RunParticlesProcedure.playCustomSound(server, player.m_20183_(), "one_heart", 0.4f, 0.8f);
        }
    }

    private static void handleDarknessEvent(ServerPlayer player, ServerLevel server, EventState state) {
        if (state.tickCounter == 1) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_216964_, 100, 0, false, false));
        }
        if (state.tickCounter % 40 == 0) {
            RunParticlesProcedure.playCustomSound(server, player.m_20183_(), "it_6", 0.5f, 0.6f);
        }
        if (state.tickCounter % 30 == 0) {
            RunParticlesProcedure.playCustomSound(server, player.m_20183_(), "one_heart", 0.6f, 1.0f);
        }
        if (state.tickCounter >= 200) {
            activeEvents.remove(player.m_20148_());
        }
    }

    private static void handleBreathingPresence(ServerPlayer player, ServerLevel server, EventState state) {
        if (state.tickCounter % 50 == 0) {
            double angle = server.f_46441_.m_188500_() * Math.PI * 2.0;
            double radius = 4.0 + server.f_46441_.m_188500_() * 3.0;
            double px = player.m_20185_() + Math.cos(angle) * radius;
            double pz = player.m_20189_() + Math.sin(angle) * radius;
            RunParticlesProcedure.playCustomSound(server, BlockPos.m_274561_((double)px, (double)player.m_20186_(), (double)pz), "it_28", 0.4f, 0.5f);
        }
        if (state.tickCounter % 25 == 0) {
            RunParticlesProcedure.playCustomSound(server, player.m_20183_(), "one_heart", 0.5f, 0.7f);
        }
    }

    private static boolean checkDespawnConditions(EventState state, ServerPlayer player, ServerLevel server, double distanceThreshold) {
        if (state.spawnedMob != null && state.spawnedMob.m_6084_()) {
            long currentTime = server.m_46467_();
            if (currentTime - state.spawnTime >= 100L) {
                RunParticlesProcedure.cleanupEvent(state, player.m_20148_());
                return true;
            }
            double distance = state.spawnedMob.m_20270_((Entity)player);
            if (distance < distanceThreshold) {
                RunParticlesProcedure.cleanupEvent(state, player.m_20148_());
                return true;
            }
        }
        return false;
    }

    private static void cleanupEvent(EventState state, UUID playerUUID) {
        if (state.spawnedMob != null && state.spawnedMob.m_6084_()) {
            state.spawnedMob.m_146870_();
        }
        activeEvents.remove(playerUUID);
    }

    private static Mob spawnShadowMob(ServerLevel server, Vec3 pos) {
        Mob entity = (Mob)((EntityType)FromTheCavesModEntities.FROMTHECAVESSHADOW.get()).m_262496_(server, BlockPos.m_274446_((Position)pos), MobSpawnType.MOB_SUMMONED);
        if (entity != null) {
            entity.m_7678_(pos.f_82479_, pos.f_82480_, pos.f_82481_, 0.0f, 0.0f);
            server.m_7967_((Entity)entity);
            RunParticlesProcedure.makeAlwaysSeePlayer(entity);
        }
        return entity;
    }

    private static void playCustomSound(ServerLevel server, BlockPos pos, String soundName, float volume, float pitch) {
        SoundEvent customSound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("from_the_caves", soundName));
        if (customSound != null) {
            server.m_5594_(null, pos, customSound, SoundSource.AMBIENT, volume, pitch);
        }
    }

    private static List<TorchInfo> findNearbyTorches(ServerLevel server, ServerPlayer player) {
        ArrayList<TorchInfo> torches = new ArrayList<TorchInfo>();
        int radiusBlocks = 16;
        int minX = player.m_20183_().m_123341_() - radiusBlocks;
        int maxX = player.m_20183_().m_123341_() + radiusBlocks;
        int minZ = player.m_20183_().m_123343_() - radiusBlocks;
        int maxZ = player.m_20183_().m_123343_() + radiusBlocks;
        int minY = Math.max(0, player.m_20183_().m_123342_() - 6);
        int maxY = Math.min(server.m_151558_() - 1, player.m_20183_().m_123342_() + 6);
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                for (int y = minY; y <= maxY; ++y) {
                    BlockPos pos = new BlockPos(x, y, z);
                    BlockState state = server.m_8055_(pos);
                    Block block = state.m_60734_();
                    if (block instanceof TorchBlock && !(block instanceof WallTorchBlock)) {
                        torches.add(new TorchInfo(pos.m_7949_(), state, false, null, false, false));
                        continue;
                    }
                    if (block instanceof WallTorchBlock) {
                        Direction facing = (Direction)state.m_61143_((Property)WallTorchBlock.f_58119_);
                        torches.add(new TorchInfo(pos.m_7949_(), state, true, facing, false, false));
                        continue;
                    }
                    if (block instanceof CandleBlock) {
                        torches.add(new TorchInfo(pos.m_7949_(), state, false, null, true, false));
                        continue;
                    }
                    if (!(block instanceof CandleCakeBlock)) continue;
                    torches.add(new TorchInfo(pos.m_7949_(), state, false, null, false, true));
                }
            }
        }
        return torches;
    }

    private static void makeAlwaysSeePlayer(Mob mob) {
        try {
            mob.f_21346_.m_25352_(0, (Goal)new NearestAttackableTargetGoal(mob, Player.class, 0, true, true, null));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class SequenceState {
        int spawned = 0;
        int tickCounter = 0;
        int nextDelay = 20;

        private SequenceState() {
        }
    }

    private static class EventState {
        int eventType;
        int tickCounter = 0;
        Vec3 targetPos;
        boolean spawned = false;
        Mob spawnedMob = null;
        List<TorchInfo> torches = new ArrayList<TorchInfo>();
        int flickerPhase = 0;
        long spawnTime = 0L;
        double circleAngle = 0.0;

        EventState(int type, Vec3 pos, long time) {
            this.eventType = type;
            this.targetPos = pos;
            this.spawnTime = time;
        }
    }

    private static class TorchInfo {
        final BlockPos pos;
        final BlockState state;
        final boolean isWall;
        final Direction facing;
        final boolean isCandle;
        final boolean isCandleCake;

        TorchInfo(BlockPos pos, BlockState state, boolean isWall, Direction facing, boolean isCandle, boolean isCandleCake) {
            this.pos = pos;
            this.state = state;
            this.isWall = isWall;
            this.facing = facing;
            this.isCandle = isCandle;
            this.isCandleCake = isCandleCake;
        }
    }
}

