/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class WarnPhaseCommandProcedure {
    private static final Map<ResourceKey<Level>, Boolean> WARN_ENABLED_MAP = new HashMap<ResourceKey<Level>, Boolean>();
    private static final Map<ResourceKey<Level>, Integer> LAST_KNOWN_PHASE = new HashMap<ResourceKey<Level>, Integer>();

    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)Commands.m_82127_((String)"fromthecaves").then(Commands.m_82127_((String)"warnphase").then(Commands.m_82129_((String)"enabled", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> {
            MinecraftServer server;
            boolean enabled = BoolArgumentType.getBool((CommandContext)ctx, (String)"enabled");
            CommandSourceStack src = (CommandSourceStack)ctx.getSource();
            ServerLevel level = null;
            try {
                level = src.m_81372_();
                if (!(level instanceof ServerLevel)) {
                    level = null;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (level == null && (server = src.m_81377_()) != null) {
                level = server.m_129880_(Level.f_46428_);
            }
            if (level == null) {
                src.m_81352_((Component)Component.m_237113_((String)"Could not determine a dimension to set warnphase."));
                return 0;
            }
            ResourceKey dim = level.m_46472_();
            WARN_ENABLED_MAP.put((ResourceKey<Level>)dim, enabled);
            int curPhase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)level);
            LAST_KNOWN_PHASE.putIfAbsent((ResourceKey<Level>)dim, curPhase);
            src.m_288197_(() -> Component.m_237113_((String)("from_the_caves: warnphase for dimension '" + String.valueOf(dim.m_135782_()) + "' set to " + enabled)), true);
            return 1;
        }))));
    }

    @SubscribeEvent
    public static void onLevelTick(TickEvent.LevelTickEvent event) {
        if (event.level.f_46443_) {
            return;
        }
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        try {
            if (event.level.m_46467_() % 20L != 0L) {
                return;
            }
        }
        catch (Throwable t) {
            return;
        }
        Level level = event.level;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ResourceKey dim = serverLevel.m_46472_();
        int currentPhase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)serverLevel);
        int last = LAST_KNOWN_PHASE.getOrDefault(dim, currentPhase);
        if (currentPhase != last) {
            LAST_KNOWN_PHASE.put((ResourceKey<Level>)dim, currentPhase);
            boolean warn = WARN_ENABLED_MAP.getOrDefault(dim, false);
            if (warn) {
                String titleText = "{\"text\":\"From the Caves\",\"bold\":true}";
                String subtitleText = "{\"text\":\"Phase " + currentPhase + " started\",\"italic\":true}";
                List players = serverLevel.m_6907_();
                for (ServerPlayer player : players) {
                    CommandSourceStack playerSrc = player.m_20203_().m_81325_(4);
                    try {
                        MinecraftServer srv = serverLevel.m_7654_();
                        if (srv == null) continue;
                        srv.m_129892_().m_82094_().execute("title @s times 10 70 20", (Object)playerSrc);
                        srv.m_129892_().m_82094_().execute("title @s title " + titleText, (Object)playerSrc);
                        srv.m_129892_().m_82094_().execute("title @s subtitle " + subtitleText, (Object)playerSrc);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
    }

    public static void setWarnForDimension(LevelAccessor worldAcc, boolean enabled) {
        if (!(worldAcc instanceof Level)) {
            return;
        }
        Level level = (Level)worldAcc;
        WARN_ENABLED_MAP.put((ResourceKey<Level>)level.m_46472_(), enabled);
    }

    public static boolean isWarnEnabledForDimension(LevelAccessor worldAcc) {
        if (!(worldAcc instanceof Level)) {
            return false;
        }
        Level level = (Level)worldAcc;
        return WARN_ENABLED_MAP.getOrDefault(level.m_46472_(), false);
    }
}

