/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.BeaconBlock;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.BlastFurnaceBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BrewingStandBlock;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.CommandBlock;
import net.minecraft.world.level.block.ComparatorBlock;
import net.minecraft.world.level.block.DaylightDetectorBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DropperBlock;
import net.minecraft.world.level.block.EnderChestBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FurnaceBlock;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.JukeboxBlock;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.LightBlock;
import net.minecraft.world.level.block.NoteBlock;
import net.minecraft.world.level.block.ObserverBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RedStoneOreBlock;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.RedstoneLampBlock;
import net.minecraft.world.level.block.RedstoneTorchBlock;
import net.minecraft.world.level.block.RedstoneWallTorchBlock;
import net.minecraft.world.level.block.RepeaterBlock;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.SmokerBlock;
import net.minecraft.world.level.block.StructureBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.TripWireBlock;
import net.minecraft.world.level.block.TripWireHookBlock;
import net.minecraft.world.level.block.WeightedPressurePlateBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.piston.PistonBaseBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ProtectedBlocksProcedure {
    private static final Map<BlockPos, BlockData> blockDataCache = new HashMap<BlockPos, BlockData>();
    private static long tickCounter = 0L;
    private static final long CLEANUP_INTERVAL = 1200L;
    private static final long MAX_CACHE_AGE = 2400L;
    private static final int MAX_CACHE_SIZE = 1000;

    public static boolean isProtected(BlockState state) {
        if (state == null) {
            return false;
        }
        Block b = state.m_60734_();
        if (b instanceof ChestBlock || b instanceof ShulkerBoxBlock || b instanceof BarrelBlock || b instanceof EnderChestBlock || b instanceof BedBlock || b instanceof FurnaceBlock || b instanceof LecternBlock || b instanceof BlastFurnaceBlock || b instanceof SmokerBlock || b instanceof DispenserBlock || b instanceof DropperBlock || b instanceof HopperBlock || b instanceof BrewingStandBlock || b instanceof BeaconBlock || b instanceof JukeboxBlock || b instanceof RedStoneWireBlock || b instanceof RedstoneTorchBlock || b instanceof RedstoneWallTorchBlock || b instanceof RepeaterBlock || b instanceof ComparatorBlock || b instanceof ObserverBlock || b instanceof PistonBaseBlock || b instanceof NoteBlock || b instanceof DaylightDetectorBlock || b instanceof TrapDoorBlock || b instanceof DoorBlock || b instanceof FenceGateBlock || b instanceof LeverBlock || b instanceof ButtonBlock || b instanceof PressurePlateBlock || b instanceof WeightedPressurePlateBlock || b instanceof TripWireBlock || b instanceof TripWireHookBlock || b instanceof RedStoneOreBlock || b instanceof RedstoneLampBlock || b instanceof CommandBlock || b instanceof StructureBlock || b instanceof JigsawBlock || b instanceof LightBlock) {
            return true;
        }
        try {
            Holder blockHolder = state.m_222976_();
            TagKey redstoneTag = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("minecraft", "redstone"));
            if (blockHolder.m_203656_(redstoneTag)) {
                return true;
            }
            TagKey createTag = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("create", "all"));
            if (blockHolder.m_203656_(createTag)) {
                return true;
            }
        }
        catch (Exception blockHolder) {
            // empty catch block
        }
        ResourceLocation blockId = ForgeRegistries.BLOCKS.getKey((Object)b);
        if (blockId != null) {
            String blockIdStr = blockId.toString();
            if (blockIdStr.startsWith("create:")) {
                return true;
            }
            if (blockIdStr.contains("mechanical") || blockIdStr.contains("kinetic") || blockIdStr.contains("cogwheel") || blockIdStr.contains("gearbox") || blockIdStr.contains("clutch") || blockIdStr.contains("gearshift") || blockIdStr.contains("sequenced_gearshift") || blockIdStr.contains("rotation_speed_controller") || blockIdStr.contains("belt") || blockIdStr.contains("motor") || blockIdStr.contains("encased") || blockIdStr.contains("shaft") || blockIdStr.contains("deployer") || blockIdStr.contains("harvester") || blockIdStr.contains("plough") || blockIdStr.contains("saw") || blockIdStr.contains("drill") || blockIdStr.contains("millstone") || blockIdStr.contains("crushing_wheel") || blockIdStr.contains("mechanical_press") || blockIdStr.contains("mechanical_mixer") || blockIdStr.contains("basin") || blockIdStr.contains("blaze_burner") || blockIdStr.contains("flywheel") || blockIdStr.contains("speedometer") || blockIdStr.contains("stressometer") || blockIdStr.contains("gauge") || blockIdStr.contains("fluid_tank") || blockIdStr.contains("item_vault") || blockIdStr.contains("andesite_funnel") || blockIdStr.contains("brass_funnel") || blockIdStr.contains("andesite_tunnel") || blockIdStr.contains("brass_tunnel") || blockIdStr.contains("chute") || blockIdStr.contains("smart_chute") || blockIdStr.contains("depot") || blockIdStr.contains("weighted_ejector") || blockIdStr.contains("contraption") || blockIdStr.contains("piston_extension_pole") || blockIdStr.contains("mechanical_piston") || blockIdStr.contains("sticky_mechanical_piston") || blockIdStr.contains("windmill_bearing") || blockIdStr.contains("mechanical_bearing") || blockIdStr.contains("clockwork_bearing") || blockIdStr.contains("rope_pulley") || blockIdStr.contains("hose_pulley") || blockIdStr.contains("cart_assembler") || blockIdStr.contains("linear_chassis") || blockIdStr.contains("radial_chassis") || blockIdStr.contains("super_glue") || blockIdStr.contains("sticker") || blockIdStr.contains("redstone_link") || blockIdStr.contains("analog_lever") || blockIdStr.contains("powered_toggle_latch") || blockIdStr.contains("powered_latch") || blockIdStr.contains("pulse_repeater") || blockIdStr.contains("flex_crate") || blockIdStr.contains("adjustable_crate") || blockIdStr.contains("stockpile_switch") || blockIdStr.contains("content_observer") || blockIdStr.contains("mechanical_arm") || blockIdStr.contains("spout") || blockIdStr.contains("item_drain") || blockIdStr.contains("smart_observer") || blockIdStr.contains("threshold_switch") || blockIdStr.contains("nixie_tube") || blockIdStr.contains("display_link") || blockIdStr.contains("display_board") || blockIdStr.contains("schematicannon") || blockIdStr.contains("schematic_table") || blockIdStr.contains("creative_motor") || blockIdStr.contains("creative_fluid_tank") || blockIdStr.contains("creative_crate")) {
                return true;
            }
        }
        return false;
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        ServerLevel server;
        BlockEntity blockEntity;
        if (event.getPlayer() != null) {
            return;
        }
        BlockState state = event.getState();
        if (!ProtectedBlocksProcedure.isProtected(state)) {
            return;
        }
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel && (blockEntity = (server = (ServerLevel)levelAccessor).m_7702_(event.getPos())) != null) {
            CompoundTag data = ProtectedBlocksProcedure.saveContainerContents(blockEntity);
            blockDataCache.put(event.getPos().m_7949_(), new BlockData(state, data, server.m_46467_()));
        }
        event.setCanceled(true);
        if (event.hasResult()) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void onExplosionDetonate(ExplosionEvent.Detonate event) {
        if (event.getLevel() == null) {
            return;
        }
        Level level = event.getLevel();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        List affectedBlocks = event.getAffectedBlocks();
        Iterator iterator = affectedBlocks.iterator();
        while (iterator.hasNext()) {
            BlockPos pos = (BlockPos)iterator.next();
            BlockState state = server.m_8055_(pos);
            if (!ProtectedBlocksProcedure.isProtected(state)) continue;
            iterator.remove();
            BlockEntity blockEntity = server.m_7702_(pos);
            CompoundTag data = ProtectedBlocksProcedure.saveContainerContents(blockEntity);
            blockDataCache.put(pos.m_7949_(), new BlockData(state, data, server.m_46467_()));
        }
    }

    @SubscribeEvent
    public static void onBlockChange(BlockEvent.NeighborNotifyEvent event) {
        BlockData data;
        if (event.getLevel() == null) {
            return;
        }
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)levelAccessor;
        BlockPos pos = event.getPos();
        if (!blockDataCache.containsKey(pos)) {
            return;
        }
        BlockState currentState = level.m_8055_(pos);
        if (currentState.m_60795_() && (data = blockDataCache.get(pos)) != null && ProtectedBlocksProcedure.isProtected(data.state)) {
            ProtectedBlocksProcedure.restoreProtectedBlock(level, pos, data.state, data.data);
        }
    }

    @SubscribeEvent
    public static void onChunkUnload(ChunkEvent.Unload event) {
        if (!(event.getLevel() instanceof ServerLevel)) {
            return;
        }
        ChunkAccess chunk = event.getChunk();
        int chunkX = chunk.m_7697_().f_45578_;
        int chunkZ = chunk.m_7697_().f_45579_;
        blockDataCache.entrySet().removeIf(entry -> {
            BlockPos pos = (BlockPos)entry.getKey();
            return pos.m_123341_() >> 4 == chunkX && pos.m_123343_() >> 4 == chunkZ;
        });
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (++tickCounter < 1200L) {
            return;
        }
        tickCounter = 0L;
        long currentTime = event.getServer().m_129783_().m_46467_();
        blockDataCache.entrySet().removeIf(entry -> currentTime - ((BlockData)entry.getValue()).timestamp > 2400L);
        if (blockDataCache.size() > 1000) {
            Iterator<Map.Entry<BlockPos, BlockData>> iterator = blockDataCache.entrySet().iterator();
            int toRemove = blockDataCache.size() - 1000;
            for (int i = 0; i < toRemove && iterator.hasNext(); ++i) {
                iterator.next();
                iterator.remove();
            }
        }
    }

    public static void cacheBlockData(ServerLevel level, BlockPos pos) {
        if (level == null || pos == null) {
            return;
        }
        BlockState state = level.m_8055_(pos);
        if (!ProtectedBlocksProcedure.isProtected(state)) {
            return;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        CompoundTag data = ProtectedBlocksProcedure.saveContainerContents(blockEntity);
        blockDataCache.put(pos.m_7949_(), new BlockData(state, data, level.m_46467_()));
    }

    private static CompoundTag saveContainerContents(BlockEntity blockEntity) {
        if (blockEntity == null) {
            return null;
        }
        CompoundTag tag = new CompoundTag();
        if (blockEntity instanceof Container) {
            Container container = (Container)blockEntity;
            CompoundTag items = new CompoundTag();
            for (int i = 0; i < container.m_6643_(); ++i) {
                ItemStack stack = container.m_8020_(i);
                if (stack.m_41619_()) continue;
                CompoundTag itemTag = new CompoundTag();
                stack.m_41739_(itemTag);
                items.m_128365_("Slot" + i, (Tag)itemTag);
            }
            tag.m_128365_("Items", (Tag)items);
            tag.m_128405_("Size", container.m_6643_());
        }
        return tag;
    }

    private static void restoreContainerContents(BlockEntity blockEntity, CompoundTag tag) {
        if (blockEntity == null || tag == null) {
            return;
        }
        if (blockEntity instanceof Container && tag.m_128441_("Items")) {
            Container container = (Container)blockEntity;
            CompoundTag items = tag.m_128469_("Items");
            for (int i = 0; i < container.m_6643_(); ++i) {
                String slotKey = "Slot" + i;
                if (!items.m_128441_(slotKey)) continue;
                CompoundTag itemTag = items.m_128469_(slotKey);
                ItemStack stack = ItemStack.m_41712_((CompoundTag)itemTag);
                container.m_6836_(i, stack);
            }
            blockEntity.m_6596_();
        }
    }

    public static void restoreProtectedBlock(ServerLevel level, BlockPos pos, BlockState state, CompoundTag savedData) {
        BlockEntity blockEntity;
        if (level == null || pos == null || state == null) {
            return;
        }
        level.m_7731_(pos, state, 3);
        if (savedData != null && (blockEntity = level.m_7702_(pos)) != null) {
            ProtectedBlocksProcedure.restoreContainerContents(blockEntity, savedData);
        }
        blockDataCache.remove(pos);
    }

    private static class BlockData {
        BlockState state;
        CompoundTag data;
        long timestamp;

        BlockData(BlockState state, CompoundTag data, long timestamp) {
            this.state = state;
            this.data = data;
            this.timestamp = timestamp;
        }
    }
}

