/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class Phase2PossessionProcedure {
    private static final double CHANCE_PER_TICK = 8.0E-5;
    private static final double SCAN_RADIUS = 20.0;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = ev.player;
        if (player.m_9236_().m_5776_()) {
            return;
        }
        ServerLevel level = (ServerLevel)player.m_9236_();
        if (PhaseManagerProcedure.getCurrentPhase((LevelAccessor)level) != 2) {
            return;
        }
        if (Math.random() >= 8.0E-5) {
            return;
        }
        level.m_6443_(Mob.class, player.m_20191_().m_82400_(20.0), m -> true).stream().findAny().ifPresent(orig -> {
            ResourceLocation possRL = Phase2PossessionProcedure.mapToPossessedRL(orig.m_6095_());
            if (possRL == null) {
                return;
            }
            EntityType possType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(possRL);
            if (possType == null) {
                return;
            }
            Entity raw = possType.m_20615_((Level)level);
            if (!(raw instanceof Mob)) {
                return;
            }
            Mob possessed = (Mob)raw;
            CompoundTag origNBT = new CompoundTag();
            orig.m_20240_(origNBT);
            possessed.getPersistentData().m_128365_("origNBT", (Tag)origNBT);
            ResourceLocation origKey = ForgeRegistries.ENTITY_TYPES.getKey((Object)orig.m_6095_());
            if (origKey != null) {
                possessed.getPersistentData().m_128359_("origID", origKey.toString());
            }
            possessed.getPersistentData().m_128356_("possessStart", level.m_46467_());
            possessed.m_20049_("phase2Possessed");
            possessed.m_20225_(true);
            possessed.m_21557_(false);
            possessed.m_7678_(orig.m_20185_(), orig.m_20186_(), orig.m_20189_(), orig.m_146908_(), orig.m_146909_());
            level.m_7967_((Entity)possessed);
            orig.m_142687_(Entity.RemovalReason.DISCARDED);
        });
    }

    private static ResourceLocation mapToPossessedRL(EntityType<?> vanillaType) {
        ResourceLocation id = ForgeRegistries.ENTITY_TYPES.getKey(vanillaType);
        if (id == null) {
            return null;
        }
        switch (id.m_135815_()) {
            case "pig": {
                return new ResourceLocation("from_the_caves", "pig_possesed");
            }
            case "cow": {
                return new ResourceLocation("from_the_caves", "cow_possesed");
            }
            case "iron_golem": {
                return new ResourceLocation("from_the_caves", "iron_golem_possesed");
            }
            case "villager": {
                return new ResourceLocation("from_the_caves", "villager_possesed");
            }
            case "sheep": {
                return new ResourceLocation("from_the_caves", "sheep_possesed");
            }
            case "wolf": {
                return new ResourceLocation("from_the_caves", "wolf_possesed");
            }
        }
        return null;
    }
}

