/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PossesedBehaviorProcedure {
    private static final int LIFETIME_TICKS = 1200;
    private static final double SEARCH_RADIUS = 50.0;
    private static final double CHASE_SPEED = 0.5;
    private static final double ATTACK_RANGE = 2.0;
    private static final float ATTACK_DAMAGE = 3.0f;

    @SubscribeEvent
    public static void onPossessedTick(LivingEvent.LivingTickEvent ev) {
        LivingEntity ent = ev.getEntity();
        if (!(ent instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)ent;
        if (!mob.m_19880_().contains("phase2Possessed")) {
            return;
        }
        if (mob.m_9236_().m_5776_()) {
            return;
        }
        ServerLevel level = (ServerLevel)mob.m_9236_();
        CompoundTag data = mob.getPersistentData();
        long start = data.m_128454_("possessStart");
        long now = level.m_46467_();
        Player target = level.m_45930_((Entity)mob, 50.0);
        if (target != null) {
            mob.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            mob.m_21573_().m_5624_((Entity)target, 0.5);
            if ((double)mob.m_20270_((Entity)target) <= 2.0) {
                target.m_6469_(target.m_269291_().m_269333_((LivingEntity)mob), 3.0f);
            }
        }
        if (now - start >= 1200L) {
            Entity raw;
            EntityType vanillaType;
            CompoundTag origNBT = data.m_128469_("origNBT");
            ResourceLocation vanillaRL = PossesedBehaviorProcedure.mapToVanillaRL(mob.m_6095_());
            if (vanillaRL != null && (vanillaType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(vanillaRL)) != null && (raw = vanillaType.m_20615_((Level)level)) instanceof Mob) {
                Mob original = (Mob)raw;
                original.m_20258_(origNBT);
                original.m_7678_(mob.m_20185_(), mob.m_20186_(), mob.m_20189_(), mob.m_146908_(), mob.m_146909_());
                level.m_7967_((Entity)original);
            }
            mob.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    @SubscribeEvent
    public static void onPossessedAttack(LivingAttackEvent ev) {
        Mob m;
        Entity src = ev.getSource().m_7639_();
        if (src instanceof Mob && (m = (Mob)src).m_19880_().contains("phase2Possessed") && ev.getEntity() instanceof IronGolem) {
            ev.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onChangeTarget(LivingChangeTargetEvent ev) {
        Mob m;
        LivingEntity attacker = ev.getEntity();
        LivingEntity newTarget = ev.getNewTarget();
        if (attacker instanceof IronGolem && newTarget instanceof Mob && (m = (Mob)newTarget).m_19880_().contains("phase2Possessed")) {
            ev.setNewTarget(null);
        }
    }

    private static ResourceLocation mapToVanillaRL(EntityType<?> possessedType) {
        ResourceLocation id = ForgeRegistries.ENTITY_TYPES.getKey(possessedType);
        if (id == null) {
            return null;
        }
        switch (id.m_135815_()) {
            case "pig_possesed": {
                return new ResourceLocation("minecraft", "pig");
            }
            case "cow_possesed": {
                return new ResourceLocation("minecraft", "cow");
            }
            case "iron_golem_possesed": {
                return new ResourceLocation("minecraft", "iron_golem");
            }
            case "villager_possesed": {
                return new ResourceLocation("minecraft", "villager");
            }
            case "sheep_possesed": {
                return new ResourceLocation("minecraft", "sheep");
            }
            case "wolf_possesed": {
                return new ResourceLocation("minecraft", "wolf");
            }
        }
        return null;
    }
}

