/*
 * Decompiled with CFR 0.152.
 */
package io.github.notenoughupdates.moulconfig.common.text;

import io.github.notenoughupdates.moulconfig.internal.ColourUtil;
import io.github.notenoughupdates.moulconfig.internal.MathUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public final class DefaultFormattingColour
extends Enum<DefaultFormattingColour> {
    public static final /* enum */ DefaultFormattingColour BLACK = new DefaultFormattingColour(0, 0);
    public static final /* enum */ DefaultFormattingColour DARK_BLUE = new DefaultFormattingColour(170, 1);
    public static final /* enum */ DefaultFormattingColour DARK_GREEN = new DefaultFormattingColour(43520, 2);
    public static final /* enum */ DefaultFormattingColour DARK_AQUA = new DefaultFormattingColour(43690, 3);
    public static final /* enum */ DefaultFormattingColour DARK_RED = new DefaultFormattingColour(0xAA0000, 4);
    public static final /* enum */ DefaultFormattingColour DARK_PURPLE = new DefaultFormattingColour(0xAA00AA, 5);
    public static final /* enum */ DefaultFormattingColour GOLD = new DefaultFormattingColour(0xFFAA00, 6);
    public static final /* enum */ DefaultFormattingColour GREY = new DefaultFormattingColour(0xAAAAAA, 7);
    public static final /* enum */ DefaultFormattingColour DARK_GREY = new DefaultFormattingColour(0x555555, 8);
    public static final /* enum */ DefaultFormattingColour BLUE = new DefaultFormattingColour(0x5555FF, 9);
    public static final /* enum */ DefaultFormattingColour GREEN = new DefaultFormattingColour(0x55FF55, 10);
    public static final /* enum */ DefaultFormattingColour AQUA = new DefaultFormattingColour(0x55FFFF, 11);
    public static final /* enum */ DefaultFormattingColour RED = new DefaultFormattingColour(0xFF5555, 12);
    public static final /* enum */ DefaultFormattingColour LIGHT_PURPLE = new DefaultFormattingColour(0xFF55FF, 13);
    public static final /* enum */ DefaultFormattingColour YELLOW = new DefaultFormattingColour(0xFFFF55, 14);
    public static final /* enum */ DefaultFormattingColour WHITE = new DefaultFormattingColour(0xFFFFFF, 15);
    final int rgb;
    final int colorHexDigit;
    @NotNull
    public static final @Unmodifiable @NotNull List<@NotNull DefaultFormattingColour> ALL_COLOURS;
    private static final /* synthetic */ DefaultFormattingColour[] $VALUES;

    public static DefaultFormattingColour[] values() {
        return (DefaultFormattingColour[])$VALUES.clone();
    }

    public static DefaultFormattingColour valueOf(String name) {
        return Enum.valueOf(DefaultFormattingColour.class, name);
    }

    private DefaultFormattingColour(int rgb, int colorHexDigit) {
        this.rgb = rgb;
        this.colorHexDigit = colorHexDigit;
    }

    @NotNull
    public static DefaultFormattingColour estimate(int rgb) {
        int r = ColourUtil.unpackARGBRedI(rgb);
        int g = ColourUtil.unpackARGBGreenI(rgb);
        int b = ColourUtil.unpackARGBBlueI(rgb);
        int minDistance = Integer.MAX_VALUE;
        DefaultFormattingColour best = null;
        for (DefaultFormattingColour candidate : ALL_COLOURS) {
            int crgb = candidate.getRgb();
            int cr = ColourUtil.unpackARGBRedI(crgb);
            int cg = ColourUtil.unpackARGBGreenI(crgb);
            int cb = ColourUtil.unpackARGBBlueI(crgb);
            int sqDist = MathUtil.squaredDistance(cr, r) + MathUtil.squaredDistance(cg, g) + MathUtil.squaredDistance(cb, b);
            if (sqDist >= minDistance) continue;
            best = candidate;
        }
        assert (best != null);
        return best;
    }

    public int getRgb() {
        return this.rgb;
    }

    public int getColorHexDigit() {
        return this.colorHexDigit;
    }

    static {
        $VALUES = new DefaultFormattingColour[]{BLACK, DARK_BLUE, DARK_GREEN, DARK_AQUA, DARK_RED, DARK_PURPLE, GOLD, GREY, DARK_GREY, BLUE, GREEN, AQUA, RED, LIGHT_PURPLE, YELLOW, WHITE};
        ALL_COLOURS = Collections.unmodifiableList(Arrays.asList(DefaultFormattingColour.values()));
    }
}

