/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.luajc;

import java.util.Vector;
import org.luaj.vm2.Lua;
import org.luaj.vm2.Prototype;

public class BasicBlock {
    int pc0;
    int pc1;
    BasicBlock[] prev;
    BasicBlock[] next;
    boolean islive;

    public BasicBlock(Prototype prototype, int n) {
        this.pc0 = this.pc1 = n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.pc0 + 1 + "-" + (this.pc1 + 1) + (this.prev != null ? "  prv: " + this.str(this.prev, 1) : "") + (this.next != null ? "  nxt: " + this.str(this.next, 0) : "") + "\n");
        return stringBuffer.toString();
    }

    private String str(BasicBlock[] basicBlockArray, int n) {
        if (basicBlockArray == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        int n2 = basicBlockArray.length;
        for (int j = 0; j < n2; ++j) {
            if (j > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(String.valueOf(n == 1 ? basicBlockArray[j].pc1 + 1 : basicBlockArray[j].pc0 + 1));
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public static BasicBlock[] findBasicBlocks(Prototype prototype) {
        Object object;
        int n = prototype.code.length;
        boolean[] blArray = new boolean[n];
        boolean[] blArray2 = new boolean[n];
        blArray[0] = true;
        MarkAndMergeVisitor markAndMergeVisitor = new MarkAndMergeVisitor(blArray, blArray2);
        BasicBlock.visitBranches(prototype, markAndMergeVisitor);
        BasicBlock.visitBranches(prototype, markAndMergeVisitor);
        BasicBlock[] basicBlockArray = new BasicBlock[n];
        for (int j = 0; j < n; ++j) {
            blArray[j] = true;
            object = new BasicBlock(prototype, j);
            basicBlockArray[j] = object;
            while (!blArray2[j] && j + 1 < n && !blArray[j + 1]) {
                object.pc1 = ++j;
                basicBlockArray[object.pc1] = object;
            }
        }
        int[] nArray = new int[n];
        object = new int[n];
        BasicBlock.visitBranches(prototype, new CountPrevNextVistor(blArray, nArray, (int[])object));
        BasicBlock.visitBranches(prototype, new AllocAndXRefVisitor(blArray, nArray, (int[])object, basicBlockArray));
        return basicBlockArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void visitBranches(Prototype prototype, BranchVisitor branchVisitor) {
        int[] nArray = prototype.code;
        int n = nArray.length;
        int n2 = 0;
        while (true) {
            block12: {
                if (n2 >= n) {
                    return;
                }
                int n3 = nArray[n2];
                switch (Lua.GET_OPCODE(n3)) {
                    case 3: {
                        if (0 == Lua.GETARG_C(n3)) break;
                        if (Lua.GET_OPCODE(nArray[n2 + 1]) == 23) {
                            throw new IllegalArgumentException("OP_LOADBOOL followed by jump at " + n2);
                        }
                        branchVisitor.visitBranch(n2, n2 + 2);
                        break block12;
                    }
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 28: {
                        if (Lua.GET_OPCODE(nArray[n2 + 1]) != 23) {
                            throw new IllegalArgumentException("test not followed by jump at " + n2);
                        }
                        int n4 = Lua.GETARG_sBx(nArray[n2 + 1]);
                        int n5 = ++n2 + n4 + 1;
                        branchVisitor.visitBranch(n2, n5);
                        branchVisitor.visitBranch(n2, n2 + 1);
                        break block12;
                    }
                    case 32: 
                    case 35: {
                        int n4 = Lua.GETARG_sBx(n3);
                        int n5 = n2 + n4 + 1;
                        branchVisitor.visitBranch(n2, n5);
                        branchVisitor.visitBranch(n2, n2 + 1);
                        break block12;
                    }
                    case 23: 
                    case 33: {
                        int n4 = Lua.GETARG_sBx(n3);
                        int n5 = n2 + n4 + 1;
                        branchVisitor.visitBranch(n2, n5);
                        break block12;
                    }
                    case 30: 
                    case 31: {
                        branchVisitor.visitReturn(n2);
                        break block12;
                    }
                }
                if (n2 + 1 < n && branchVisitor.isbeg[n2 + 1]) {
                    branchVisitor.visitBranch(n2, n2 + 1);
                }
            }
            ++n2;
        }
    }

    public static BasicBlock[] findLiveBlocks(BasicBlock[] basicBlockArray) {
        int n;
        Object object;
        Vector<BasicBlock> vector = new Vector<BasicBlock>();
        vector.addElement(basicBlockArray[0]);
        while (!vector.isEmpty()) {
            int n2;
            object = (BasicBlock)vector.elementAt(0);
            vector.removeElementAt(0);
            if (((BasicBlock)object).islive) continue;
            ((BasicBlock)object).islive = true;
            int n3 = n2 = ((BasicBlock)object).next != null ? ((BasicBlock)object).next.length : 0;
            for (n = 0; n < n2; ++n) {
                if (((BasicBlock)object).next[n].islive) continue;
                vector.addElement(((BasicBlock)object).next[n]);
            }
        }
        object = new Vector();
        n = 0;
        while (n < basicBlockArray.length) {
            if (basicBlockArray[n].islive) {
                ((Vector)object).addElement(basicBlockArray[n]);
            }
            n = basicBlockArray[n].pc1 + 1;
        }
        Object[] objectArray = new BasicBlock[((Vector)object).size()];
        ((Vector)object).copyInto(objectArray);
        return objectArray;
    }

    public static abstract class BranchVisitor {
        final boolean[] isbeg;

        public BranchVisitor(boolean[] blArray) {
            this.isbeg = blArray;
        }

        public void visitBranch(int n, int n2) {
        }

        public void visitReturn(int n) {
        }
    }

    private static final class MarkAndMergeVisitor
    extends BranchVisitor {
        private final boolean[] isend;

        private MarkAndMergeVisitor(boolean[] blArray, boolean[] blArray2) {
            super(blArray);
            this.isend = blArray2;
        }

        public void visitBranch(int n, int n2) {
            this.isend[n] = true;
            this.isbeg[n2] = true;
        }

        public void visitReturn(int n) {
            this.isend[n] = true;
        }
    }

    private static final class CountPrevNextVistor
    extends BranchVisitor {
        private final int[] nnext;
        private final int[] nprev;

        private CountPrevNextVistor(boolean[] blArray, int[] nArray, int[] nArray2) {
            super(blArray);
            this.nnext = nArray;
            this.nprev = nArray2;
        }

        public void visitBranch(int n, int n2) {
            int n3 = n;
            this.nnext[n3] = this.nnext[n3] + 1;
            int n4 = n2;
            this.nprev[n4] = this.nprev[n4] + 1;
        }
    }

    private static final class AllocAndXRefVisitor
    extends BranchVisitor {
        private final int[] nnext;
        private final int[] nprev;
        private final BasicBlock[] blocks;

        private AllocAndXRefVisitor(boolean[] blArray, int[] nArray, int[] nArray2, BasicBlock[] basicBlockArray) {
            super(blArray);
            this.nnext = nArray;
            this.nprev = nArray2;
            this.blocks = basicBlockArray;
        }

        public void visitBranch(int n, int n2) {
            if (this.blocks[n].next == null) {
                this.blocks[n].next = new BasicBlock[this.nnext[n]];
            }
            if (this.blocks[n2].prev == null) {
                this.blocks[n2].prev = new BasicBlock[this.nprev[n2]];
            }
            int n3 = n;
            int n4 = this.nnext[n3] - 1;
            this.nnext[n3] = n4;
            this.blocks[n].next[n4] = this.blocks[n2];
            int n5 = n2;
            int n6 = this.nprev[n5] - 1;
            this.nprev[n5] = n6;
            this.blocks[n2].prev[n6] = this.blocks[n];
        }
    }
}

