/*
 * Decompiled with CFR 0.152.
 */
package io.github.notenoughupdates.moulconfig.internal;

public class ColourUtil {
    public static final float COMPONENT_SIZE_F = 255.0f;
    public static final int BYTE_MASK = 255;
    public static final int ALPHA_SHIFT = 24;
    public static final int RED_SHIFT = 16;
    public static final int GREEN_SHIFT = 8;
    public static final int BLUE_SHIFT = 0;
    public static final int MAX_ALPHA = -16777216;

    public static int packARGB(float r, float g, float b, float a) {
        int ri = ColourUtil.float1ToInt255(r);
        int gi = ColourUtil.float1ToInt255(g);
        int bi = ColourUtil.float1ToInt255(b);
        int ai = ColourUtil.float1ToInt255(a);
        return ColourUtil.packARGB(ri, gi, bi, ai);
    }

    public static int packARGB(int a, int r, int g, int b) {
        return (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | (b & 0xFF) << 0;
    }

    public static float int255ToFloat1(int element) {
        return (float)element / 255.0f;
    }

    public static int float1ToInt255(float element) {
        return (int)(element * 255.0f);
    }

    public static int unpackARGBRedI(int color) {
        return color >> 16 & 0xFF;
    }

    public static int unpackARGBGreenI(int color) {
        return color >> 8 & 0xFF;
    }

    public static int unpackARGBBlueI(int color) {
        return color >> 0 & 0xFF;
    }

    public static int unpackARGBAlphaI(int color) {
        return color >> 24 & 0xFF;
    }

    public static float unpackARGBRedF(int color) {
        return (float)ColourUtil.unpackARGBRedI(color) / 255.0f;
    }

    public static float unpackARGBGreenF(int color) {
        return (float)ColourUtil.unpackARGBGreenI(color) / 255.0f;
    }

    public static float unpackARGBBlueF(int color) {
        return (float)ColourUtil.unpackARGBBlueI(color) / 255.0f;
    }

    public static float unpackARGBAlphaF(int color) {
        return (float)ColourUtil.unpackARGBAlphaI(color) / 255.0f;
    }

    public static int makeOpaque(int argb) {
        return argb | 0xFF000000;
    }

    public static int makeTransparent(int argb) {
        return argb & 0xFFFFFF;
    }
}

