/*
 * Decompiled with CFR 0.152.
 */
package com.nekiplay.hypixelcry.features.esp.mining.dwarvenmines;

import com.nekiplay.hypixelcry.HypixelCry;
import com.nekiplay.hypixelcry.annotations.Init;
import com.nekiplay.hypixelcry.config.enums.ESPFeatures;
import com.nekiplay.hypixelcry.utils.SpecialColor;
import com.nekiplay.hypixelcry.utils.render.RenderHelper;
import com.nekiplay.hypixelcry.utils.scheduler.Scheduler;
import java.util.Arrays;
import java.util.Objects;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_638;

public class DarkMonolithESP {
    private static class_2338 eggPosition;
    private static boolean eggFound;
    private static final class_2338[] MONOLITH_LOCATIONS;

    @Init
    public static void init() {
        WorldRenderEvents.AFTER_TRANSLUCENT.register(DarkMonolithESP::render);
        Scheduler.INSTANCE.scheduleCyclic(DarkMonolithESP::onTick, 2);
    }

    private static void onTick() {
        eggPosition = DarkMonolithESP.findEggInWorld();
        eggFound = eggPosition != null;
    }

    private static class_2338 findEggInWorld() {
        if (HypixelCry.mc.field_1687 != null) {
            return Arrays.stream(MONOLITH_LOCATIONS).filter(arg_0 -> ((class_638)HypixelCry.mc.field_1687).method_8477(arg_0)).map(DarkMonolithESP::findEggNearPosition).filter(Objects::nonNull).findFirst().orElse(null);
        }
        return null;
    }

    private static class_2338 findEggNearPosition(class_2338 center) {
        int searchRadius = 5;
        class_2338 minPos = center.method_10069(-5, -5, -5);
        class_2338 maxPos = center.method_10069(5, 5, 5);
        for (class_2338 pos : class_2338.method_10097((class_2338)minPos, (class_2338)maxPos)) {
            assert (HypixelCry.mc.field_1687 != null);
            class_2680 state = HypixelCry.mc.field_1687.method_8320(pos);
            if (state.method_26204() != class_2246.field_10081) continue;
            return pos;
        }
        return null;
    }

    public static void render(WorldRenderContext context) {
        if (!HypixelCry.config.esp.dwarvenMines.darkMonolith.enabled || !eggFound) {
            return;
        }
        float[] colorComponents = SpecialColor.toSpecialColorFloatArray(HypixelCry.config.esp.dwarvenMines.darkMonolith.colour);
        int colorComponentsNoAlpha = SpecialColor.toSpecialColorIntNoAlpha(HypixelCry.config.esp.dwarvenMines.darkMonolith.colour);
        float alpha = colorComponents[3];
        float lineWidth = 1.5f;
        boolean throughWalls = true;
        if (HypixelCry.config.esp.dwarvenMines.darkMonolith.features.contains((Object)ESPFeatures.Box)) {
            RenderHelper.renderFilled(context, eggPosition, colorComponents, alpha, throughWalls);
            RenderHelper.renderOutline(context, eggPosition, colorComponents, lineWidth, throughWalls);
        }
        if (HypixelCry.config.esp.dwarvenMines.darkMonolith.features.contains((Object)ESPFeatures.Text)) {
            RenderHelper.renderText(context, class_2561.method_30163((String)"Dark").method_30937(), eggPosition.method_46558().method_1031(0.0, 1.2, 0.0), colorComponentsNoAlpha, 1.0f, 0.5f, throughWalls);
            RenderHelper.renderText(context, class_2561.method_30163((String)"Monolith").method_30937(), eggPosition.method_46558().method_1031(0.0, 1.0, 0.0), colorComponentsNoAlpha, 1.0f, 0.5f, throughWalls);
        }
        if (HypixelCry.config.esp.dwarvenMines.darkMonolith.features.contains((Object)ESPFeatures.Tracer)) {
            RenderHelper.renderLineFromCursor(context, eggPosition.method_46558(), colorComponents, 1.0f, lineWidth);
        }
    }

    static {
        MONOLITH_LOCATIONS = new class_2338[]{new class_2338(-15, 236, -92), new class_2338(49, 202, -162), new class_2338(56, 214, -25), new class_2338(128, 187, 58), new class_2338(150, 196, 190), new class_2338(61, 204, 181), new class_2338(91, 187, 131), new class_2338(77, 160, 162), new class_2338(-10, 162, 109), new class_2338(1, 183, 25), new class_2338(0, 170, 0), new class_2338(-94, 201, -30), new class_2338(-91, 221, -53), new class_2338(-64, 206, -63)};
    }
}

