/*
 * Decompiled with CFR 0.152.
 */
package com.nekiplay.hypixelcry.pathfinder.calculate.openset;

import com.nekiplay.hypixelcry.pathfinder.calculate.PathNode;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\f\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000b\u0010\nJ\r\u0010\f\u001a\u00020\u0006\u00a2\u0006\u0004\b\f\u0010\rJ\r\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010R*\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00118\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\"\u0010\u0018\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u0005\u00a8\u0006\u001d"}, d2={"Lcom/nekiplay/hypixelcry/pathfinder/calculate/openset/BinaryHeapOpenSet;", "", "", "initialSize", "<init>", "(I)V", "Lcom/nekiplay/hypixelcry/pathfinder/calculate/PathNode;", "node", "", "add", "(Lcom/nekiplay/hypixelcry/pathfinder/calculate/PathNode;)V", "relocate", "poll", "()Lcom/nekiplay/hypixelcry/pathfinder/calculate/PathNode;", "", "isEmpty", "()Z", "", "items", "[Lcom/nekiplay/hypixelcry/pathfinder/calculate/PathNode;", "getItems", "()[Lcom/nekiplay/hypixelcry/pathfinder/calculate/PathNode;", "setItems", "([Lcom/nekiplay/hypixelcry/pathfinder/calculate/PathNode;)V", "size", "I", "getSize", "()I", "setSize", "hypixel-cry"})
public final class BinaryHeapOpenSet {
    @NotNull
    private PathNode[] items;
    private int size;

    public BinaryHeapOpenSet(int initialSize) {
        this.items = new PathNode[initialSize];
    }

    public /* synthetic */ BinaryHeapOpenSet(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 1024;
        }
        this(n);
    }

    @NotNull
    public final PathNode[] getItems() {
        return this.items;
    }

    public final void setItems(@NotNull PathNode[] pathNodeArray) {
        Intrinsics.checkNotNullParameter((Object)pathNodeArray, (String)"<set-?>");
        this.items = pathNodeArray;
    }

    public final int getSize() {
        return this.size;
    }

    public final void setSize(int n) {
        this.size = n;
    }

    public final void add(@NotNull PathNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (this.size >= this.items.length - 1) {
            this.items = Arrays.copyOf(this.items, this.items.length << 1);
        }
        ++this.size;
        node.setHeapPosition(this.size);
        this.items[this.size] = node;
        this.relocate(node);
    }

    public final void relocate(@NotNull PathNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        int parent = node.getHeapPosition() >>> 1;
        PathNode parentNode = this.items[parent];
        while (node.getHeapPosition() > 1) {
            double d = node.getTotalCost();
            PathNode pathNode = parentNode;
            Intrinsics.checkNotNull((Object)pathNode);
            if (!(d < pathNode.getTotalCost())) break;
            this.items[node.getHeapPosition()] = parentNode;
            this.items[parent] = node;
            node.setHeapPosition(parent);
            parentNode = this.items[parent >>>= 1];
        }
    }

    @NotNull
    public final PathNode poll() {
        PathNode itemToSwap;
        PathNode itemToPoll;
        PathNode pathNode = itemToPoll = this.items[1];
        Intrinsics.checkNotNull((Object)pathNode);
        pathNode.setHeapPosition(-1);
        int n = this.size;
        this.size = n + -1;
        PathNode pathNode2 = itemToSwap = this.items[n];
        Intrinsics.checkNotNull((Object)pathNode2);
        pathNode2.setHeapPosition(1);
        this.items[1] = itemToSwap;
        double itemToSwapCost = itemToSwap.getTotalCost();
        if (this.size <= 1) {
            return itemToPoll;
        }
        int parentIndex = 1;
        int smallestChildIndex = 2;
        while (smallestChildIndex <= this.size) {
            PathNode swapTemp;
            int rightChildIndex = smallestChildIndex + 1;
            if (rightChildIndex < this.size) {
                PathNode pathNode3 = this.items[rightChildIndex];
                Intrinsics.checkNotNull((Object)pathNode3);
                double d = pathNode3.getTotalCost();
                PathNode pathNode4 = this.items[smallestChildIndex];
                Intrinsics.checkNotNull((Object)pathNode4);
                if (d < pathNode4.getTotalCost()) {
                    smallestChildIndex = rightChildIndex;
                }
            }
            PathNode pathNode5 = this.items[smallestChildIndex];
            Intrinsics.checkNotNull((Object)pathNode5);
            if (pathNode5.getTotalCost() >= itemToSwapCost) break;
            PathNode pathNode6 = swapTemp = this.items[smallestChildIndex];
            Intrinsics.checkNotNull((Object)pathNode6);
            pathNode6.setHeapPosition(parentIndex);
            this.items[parentIndex] = swapTemp;
            itemToSwap.setHeapPosition(smallestChildIndex);
            this.items[smallestChildIndex] = itemToSwap;
            parentIndex = smallestChildIndex;
            smallestChildIndex = parentIndex << 1;
        }
        return itemToPoll;
    }

    public final boolean isEmpty() {
        return this.size <= 0;
    }

    public BinaryHeapOpenSet() {
        this(0, 1, null);
    }
}

