/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.lib;

import java.io.IOException;
import java.io.InputStream;
import org.luaj.vm2.Globals;
import org.luaj.vm2.LuaFunction;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.OneArgFunction;
import org.luaj.vm2.lib.TwoArgFunction;
import org.luaj.vm2.lib.VarArgFunction;

public class PackageLib
extends TwoArgFunction {
    public static String DEFAULT_LUA_PATH;
    private static final LuaString _LOADED;
    private static final LuaString _LOADLIB;
    private static final LuaString _PRELOAD;
    private static final LuaString _PATH;
    private static final LuaString _SEARCHPATH;
    private static final LuaString _SEARCHERS;
    Globals globals;
    LuaTable package_;
    public preload_searcher preload_searcher;
    public lua_searcher lua_searcher;
    public java_searcher java_searcher;
    private static final LuaString _SENTINEL;
    private static final String FILE_SEP;

    public LuaValue call(LuaValue luaValue, LuaValue luaValue2) {
        this.globals = luaValue2.checkglobals();
        this.globals.set("require", (LuaValue)new require());
        this.package_ = new LuaTable();
        this.package_.set(_LOADED, (LuaValue)new LuaTable());
        this.package_.set(_PRELOAD, (LuaValue)new LuaTable());
        this.package_.set(_PATH, (LuaValue)LuaValue.valueOf(DEFAULT_LUA_PATH));
        this.package_.set(_LOADLIB, (LuaValue)new loadlib());
        this.package_.set(_SEARCHPATH, (LuaValue)new searchpath());
        LuaTable luaTable = new LuaTable();
        this.preload_searcher = new preload_searcher();
        luaTable.set(1, (LuaValue)this.preload_searcher);
        this.lua_searcher = new lua_searcher();
        luaTable.set(2, (LuaValue)this.lua_searcher);
        this.java_searcher = new java_searcher();
        luaTable.set(3, (LuaValue)this.java_searcher);
        this.package_.set(_SEARCHERS, (LuaValue)luaTable);
        this.package_.get(_LOADED).set("package", (LuaValue)this.package_);
        luaValue2.set("package", (LuaValue)this.package_);
        this.globals.package_ = this;
        return luaValue2;
    }

    public void setIsLoaded(String string, LuaTable luaTable) {
        this.package_.get(_LOADED).set(string, (LuaValue)luaTable);
    }

    public void setLuaPath(String string) {
        this.package_.set(_PATH, (LuaValue)LuaValue.valueOf(string));
    }

    public String tojstring() {
        return "package";
    }

    public static final String toClassname(String string) {
        int n;
        int n2 = n = string.length();
        if (string.endsWith(".lua")) {
            n2 -= 4;
        }
        for (int j = 0; j < n2; ++j) {
            int n3 = string.charAt(j);
            if (PackageLib.isClassnamePart((char)n3) && n3 != 47 && n3 != 92) continue;
            StringBuffer stringBuffer = new StringBuffer(n2);
            for (int k = 0; k < n2; ++k) {
                n3 = string.charAt(k);
                stringBuffer.append((char)(PackageLib.isClassnamePart((char)n3) ? n3 : (n3 == 47 || n3 == 92 ? 46 : 95)));
            }
            return stringBuffer.toString();
        }
        return n == n2 ? string : string.substring(0, n2);
    }

    private static final boolean isClassnamePart(char c) {
        if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') {
            return true;
        }
        switch (c) {
            case '$': 
            case '.': 
            case '_': {
                return true;
            }
        }
        return false;
    }

    static {
        try {
            DEFAULT_LUA_PATH = System.getProperty("luaj.package.path");
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        if (DEFAULT_LUA_PATH == null) {
            DEFAULT_LUA_PATH = "?.lua";
        }
        _LOADED = PackageLib.valueOf("loaded");
        _LOADLIB = PackageLib.valueOf("loadlib");
        _PRELOAD = PackageLib.valueOf("preload");
        _PATH = PackageLib.valueOf("path");
        _SEARCHPATH = PackageLib.valueOf("searchpath");
        _SEARCHERS = PackageLib.valueOf("searchers");
        _SENTINEL = PackageLib.valueOf("\u0001");
        FILE_SEP = System.getProperty("file.separator");
    }

    public class java_searcher
    extends VarArgFunction {
        public Varargs invoke(Varargs varargs) {
            String string = varargs.checkjstring(1);
            String string2 = PackageLib.toClassname(string);
            Class<?> clazz = null;
            LuaValue luaValue = null;
            try {
                clazz = Class.forName(string2);
                luaValue = (LuaValue)clazz.newInstance();
                if (luaValue.isfunction()) {
                    ((LuaFunction)luaValue).initupvalue1(PackageLib.this.globals);
                }
                return org.luaj.vm2.lib.PackageLib$java_searcher.varargsOf(luaValue, (Varargs)PackageLib.this.globals);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return org.luaj.vm2.lib.PackageLib$java_searcher.valueOf("\n\tno class '" + string2 + "'");
            }
            catch (Exception exception) {
                return org.luaj.vm2.lib.PackageLib$java_searcher.valueOf("\n\tjava load failed on '" + string2 + "', " + exception);
            }
        }
    }

    public class searchpath
    extends VarArgFunction {
        public Varargs invoke(Varargs varargs) {
            String string = varargs.checkjstring(1);
            String string2 = varargs.checkjstring(2);
            String string3 = varargs.optjstring(3, ".");
            String string4 = varargs.optjstring(4, FILE_SEP);
            int n = -1;
            int n2 = string2.length();
            StringBuffer stringBuffer = null;
            string = string.replace(string3.charAt(0), string4.charAt(0));
            while (n < n2) {
                InputStream inputStream;
                int n3 = n + 1;
                if ((n = string2.indexOf(59, n3)) < 0) {
                    n = string2.length();
                }
                String string5 = string2.substring(n3, n);
                int n4 = string5.indexOf(63);
                String string6 = string5;
                if (n4 >= 0) {
                    string6 = string5.substring(0, n4) + string + string5.substring(n4 + 1);
                }
                if ((inputStream = PackageLib.this.globals.finder.findResource(string6)) != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return searchpath.valueOf(string6);
                }
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer();
                }
                stringBuffer.append("\n\t" + string6);
            }
            return searchpath.varargsOf(NIL, (Varargs)searchpath.valueOf(stringBuffer.toString()));
        }
    }

    public class lua_searcher
    extends VarArgFunction {
        public Varargs invoke(Varargs varargs) {
            LuaString luaString = varargs.checkstring(1);
            Object var3_3 = null;
            LuaValue luaValue = PackageLib.this.package_.get(_PATH);
            if (!luaValue.isstring()) {
                return org.luaj.vm2.lib.PackageLib$lua_searcher.valueOf("package.path is not a string");
            }
            Varargs varargs2 = PackageLib.this.package_.get(_SEARCHPATH).invoke(org.luaj.vm2.lib.PackageLib$lua_searcher.varargsOf(luaString, (Varargs)luaValue));
            if (!varargs2.isstring(1)) {
                return varargs2.arg(2).tostring();
            }
            LuaString luaString2 = varargs2.arg1().strvalue();
            if ((varargs2 = PackageLib.this.globals.loadfile(luaString2.tojstring())).arg1().isfunction()) {
                return LuaValue.varargsOf(varargs2.arg1(), (Varargs)luaString2);
            }
            return org.luaj.vm2.lib.PackageLib$lua_searcher.varargsOf(NIL, (Varargs)org.luaj.vm2.lib.PackageLib$lua_searcher.valueOf("'" + luaString2 + "': " + varargs2.arg(2).tojstring()));
        }
    }

    public class preload_searcher
    extends VarArgFunction {
        public Varargs invoke(Varargs varargs) {
            LuaString luaString = varargs.checkstring(1);
            LuaValue luaValue = PackageLib.this.package_.get(_PRELOAD).get(luaString);
            return luaValue.isnil() ? org.luaj.vm2.lib.PackageLib$preload_searcher.valueOf("\n\tno field package.preload['" + luaString + "']") : luaValue;
        }
    }

    public static class loadlib
    extends VarArgFunction {
        public Varargs loadlib(Varargs varargs) {
            varargs.checkstring(1);
            return loadlib.varargsOf(NIL, loadlib.valueOf("dynamic libraries not enabled"), loadlib.valueOf("absent"));
        }
    }

    public class require
    extends OneArgFunction {
        public LuaValue call(LuaValue luaValue) {
            LuaString luaString = luaValue.checkstring();
            LuaValue luaValue2 = PackageLib.this.package_.get(_LOADED);
            LuaValue luaValue3 = luaValue2.get(luaString);
            if (luaValue3.toboolean()) {
                if (luaValue3 == _SENTINEL) {
                    require.error("loop or previous error loading module '" + luaString + "'");
                }
                return luaValue3;
            }
            LuaTable luaTable = PackageLib.this.package_.get(_SEARCHERS).checktable();
            StringBuffer stringBuffer = new StringBuffer();
            Varargs varargs = null;
            int n = 1;
            while (true) {
                LuaValue luaValue4;
                if ((luaValue4 = luaTable.get(n)).isnil()) {
                    require.error("module '" + luaString + "' not found: " + luaString + stringBuffer);
                }
                if ((varargs = luaValue4.invoke(luaString)).isfunction(1)) break;
                if (varargs.isstring(1)) {
                    stringBuffer.append(varargs.tojstring(1));
                }
                ++n;
            }
            luaValue2.set(luaString, (LuaValue)_SENTINEL);
            luaValue3 = varargs.arg1().call(luaString, varargs.arg(2));
            if (!luaValue3.isnil()) {
                luaValue2.set(luaString, luaValue3);
            } else {
                luaValue3 = luaValue2.get(luaString);
                if (luaValue3 == _SENTINEL) {
                    luaValue3 = LuaValue.TRUE;
                    luaValue2.set(luaString, luaValue3);
                }
            }
            return luaValue3;
        }
    }
}

