/*
 * Decompiled with CFR 0.152.
 */
package com.nekiplay.hypixelcry.features.commands.impl;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.nekiplay.hypixelcry.HypixelCry;
import com.nekiplay.hypixelcry.features.lua.LuaManager;
import java.io.File;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2561;
import net.minecraft.class_7157;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J#\u0010\n\u001a\u00020\t2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001f\u0010\u000f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0011\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/nekiplay/hypixelcry/features/commands/impl/LuaCommand;", "", "<init>", "()V", "Lcom/mojang/brigadier/CommandDispatcher;", "Lnet/fabricmc/fabric/api/client/command/v2/FabricClientCommandSource;", "dispatcher", "Lnet/minecraft/class_7157;", "registryAccess", "", "register", "(Lcom/mojang/brigadier/CommandDispatcher;Lnet/minecraft/class_7157;)V", "", "filename", "source", "executeLuaFile", "(Ljava/lang/String;Lnet/fabricmc/fabric/api/client/command/v2/FabricClientCommandSource;)V", "listLuaFiles", "(Lnet/fabricmc/fabric/api/client/command/v2/FabricClientCommandSource;)V", "hypixel-cry"})
@SourceDebugExtension(value={"SMAP\nLuaCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LuaCommand.kt\ncom/nekiplay/hypixelcry/features/commands/impl/LuaCommand\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,90:1\n6482#2:91\n1869#3,2:92\n*S KotlinDebug\n*F\n+ 1 LuaCommand.kt\ncom/nekiplay/hypixelcry/features/commands/impl/LuaCommand\n*L\n78#1:91\n86#1:92,2\n*E\n"})
public final class LuaCommand {
    @NotNull
    public static final LuaCommand INSTANCE = new LuaCommand();

    private LuaCommand() {
    }

    public final void register(@NotNull CommandDispatcher<FabricClientCommandSource> dispatcher, @NotNull class_7157 registryAccess) {
        Intrinsics.checkNotNullParameter(dispatcher, (String)"dispatcher");
        Intrinsics.checkNotNullParameter((Object)registryAccess, (String)"registryAccess");
        LiteralArgumentBuilder luaCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"lua").then(ClientCommandManager.literal((String)"clear").executes(LuaCommand::register$lambda$0))).then(ClientCommandManager.literal((String)"file").then(ClientCommandManager.argument((String)"filename", (ArgumentType)((ArgumentType)StringArgumentType.string())).executes(LuaCommand::register$lambda$1)))).then(ClientCommandManager.literal((String)"list").executes(LuaCommand::register$lambda$2));
        dispatcher.register(luaCommand);
    }

    private final void executeLuaFile(String filename, FabricClientCommandSource source) {
        LuaManager luaManager = HypixelCry.LUA_MANAGER;
        File scriptsDir = new File("config/hypixelcry/scripts");
        if (!scriptsDir.exists()) {
            scriptsDir.mkdirs();
            source.sendFeedback((class_2561)class_2561.method_43470((String)("\u00a7cDirectory for scripts: " + scriptsDir.getPath())));
            return;
        }
        File scriptFile = new File(scriptsDir, (String)(StringsKt.endsWith$default((String)filename, (String)".lua", (boolean)false, (int)2, null) ? filename : filename + ".lua"));
        if (!scriptFile.exists()) {
            source.sendFeedback((class_2561)class_2561.method_43470((String)("\u00a7cScript " + scriptFile.getName() + " not found")));
            return;
        }
        try {
            String scriptContent = FilesKt.readText$default((File)scriptFile, null, (int)1, null);
            Object result = luaManager.executeScript(scriptContent);
            source.sendFeedback((class_2561)class_2561.method_43470((String)("\u00a7aScript '" + scriptFile.getName() + "' executed successfully, result: '" + result + "'")));
        }
        catch (Exception e) {
            source.sendFeedback((class_2561)class_2561.method_43470((String)("\u00a7cScript execution error: " + e.getMessage())));
            e.printStackTrace();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void listLuaFiles(FabricClientCommandSource source) {
        List list;
        File scriptsDir;
        block8: {
            block7: {
                scriptsDir = new File("config/hypixelcry/scripts");
                if (!scriptsDir.exists()) break block7;
                File[] fileArray = scriptsDir.listFiles();
                if (fileArray != null ? !(fileArray.length == 0) : false) break block8;
            }
            source.sendFeedback((class_2561)class_2561.method_43470((String)("\u00a77No scripts available. Create files in: " + scriptsDir.getPath())));
            return;
        }
        Object object = scriptsDir.listFiles(LuaCommand::listLuaFiles$lambda$3);
        if (object != null) {
            void $this$sortedBy$iv;
            File[] fileArray = object;
            boolean $i$f$sortedBy = false;
            list = ArraysKt.sortedWith((Object[])$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    File it = (File)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getName());
                    it = (File)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
                }
            });
        } else {
            list = null;
        }
        List luaFiles = list;
        object = luaFiles;
        if (object == null || object.isEmpty()) {
            source.sendFeedback((class_2561)class_2561.method_43470((String)"\u00a77No .lua files in scripts directory"));
            return;
        }
        source.sendFeedback((class_2561)class_2561.method_43470((String)"\u00a76Available scripts:"));
        Iterable $this$forEach$iv = luaFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File file = (File)element$iv;
            boolean bl = false;
            source.sendFeedback((class_2561)class_2561.method_43470((String)("\u00a77- \u00a7e" + file.getName() + " \u00a77(" + file.length() + " bytes)")));
        }
    }

    private static final int register$lambda$0(CommandContext context) {
        HypixelCry.LUA_MANAGER.clearAllCallbacks();
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"\u00a7aAll Lua callback's cleared"));
        return 1;
    }

    private static final int register$lambda$1(CommandContext context) {
        String filename = StringArgumentType.getString((CommandContext)context, (String)"filename");
        Intrinsics.checkNotNull((Object)filename);
        Object object = context.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
        INSTANCE.executeLuaFile(filename, (FabricClientCommandSource)object);
        return 1;
    }

    private static final int register$lambda$2(CommandContext context) {
        Object object = context.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
        INSTANCE.listLuaFiles((FabricClientCommandSource)object);
        return 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean listLuaFiles$lambda$3(File file) {
        if (!file.isFile()) return false;
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (!StringsKt.endsWith$default((String)string, (String)".lua", (boolean)false, (int)2, null)) return false;
        return true;
    }
}

