/*
 * Decompiled with CFR 0.152.
 */
package com.nekiplay.hypixelcry.features.lua;

import com.nekiplay.hypixelcry.HypixelCry;
import com.nekiplay.hypixelcry.features.lua.objects.modules.ModulesObject;
import com.nekiplay.hypixelcry.features.lua.objects.player.PlayerObject;
import com.nekiplay.hypixelcry.features.lua.objects.render.WorldRendererObject;
import com.nekiplay.hypixelcry.features.lua.objects.world.WorldObject;
import com.nekiplay.hypixelcry.utils.misc.input.KeyAction;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.luaj.vm2.Globals;
import org.luaj.vm2.LuaBoolean;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.lib.OneArgFunction;
import org.luaj.vm2.lib.jse.JsePlatform;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u0015\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000b\u0010\nJ\u0015\u0010\f\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\f\u0010\nJ\u0015\u0010\r\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\r\u0010\nJ\u0015\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000e\u0010\nJ\u0015\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000f\u0010\nJ\r\u0010\u0010\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0010\u0010\u0003J\u000f\u0010\u0011\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0003J\r\u0010\u0012\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0012\u0010\u0003J\u0017\u0010\u0015\u001a\u00020\u00042\b\u0010\u0014\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001d\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0019\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0015\u0010\u001f\u001a\u00020\u00012\u0006\u0010\u001e\u001a\u00020\u001d\u00a2\u0006\u0004\b\u001f\u0010 J\u000f\u0010!\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b!\u0010\u0003R\u0014\u0010#\u001a\u00020\"8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b#\u0010$R \u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00060%8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b&\u0010'R\u001a\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00060(8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b)\u0010*R\u001a\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00060(8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b+\u0010*R\u001a\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00060(8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b,\u0010*\u00a8\u0006-"}, d2={"Lcom/nekiplay/hypixelcry/features/lua/LuaManager;", "", "<init>", "()V", "", "registerCustomFunctions", "Lorg/luaj/vm2/LuaValue;", "callback", "", "addClientTickCallback", "(Lorg/luaj/vm2/LuaValue;)Z", "addWorldRendererCallback", "addKeyEventCallback", "removeClientTickCallback", "removeWorldRendererCallback", "removeKeyEventCallback", "clearAllCallbacks", "registerGlobalObjects", "onClientTick", "Lnet/fabricmc/fabric/api/client/rendering/v1/WorldRenderContext;", "context", "onRenderTick", "(Lnet/fabricmc/fabric/api/client/rendering/v1/WorldRenderContext;)V", "", "key", "Lcom/nekiplay/hypixelcry/utils/misc/input/KeyAction;", "type", "onKeyEvent", "(ILcom/nekiplay/hypixelcry/utils/misc/input/KeyAction;)V", "", "script", "executeScript", "(Ljava/lang/String;)Ljava/lang/Object;", "restoreGlobals", "Lorg/luaj/vm2/Globals;", "globals", "Lorg/luaj/vm2/Globals;", "Ljava/util/concurrent/ConcurrentHashMap;", "persistentGlobals", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/util/concurrent/CopyOnWriteArrayList;", "clientTickCallbacks", "Ljava/util/concurrent/CopyOnWriteArrayList;", "renderWorldCallbacks", "keyEvetCallbacks", "hypixel-cry"})
@SourceDebugExtension(value={"SMAP\nLuaManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LuaManager.kt\ncom/nekiplay/hypixelcry/features/lua/LuaManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,160:1\n1869#2,2:161\n1869#2,2:163\n1869#2,2:165\n216#3,2:167\n*S KotlinDebug\n*F\n+ 1 LuaManager.kt\ncom/nekiplay/hypixelcry/features/lua/LuaManager\n*L\n118#1:161,2\n128#1:163,2\n139#1:165,2\n156#1:167,2\n*E\n"})
public final class LuaManager {
    @NotNull
    private final Globals globals;
    @NotNull
    private final ConcurrentHashMap<String, LuaValue> persistentGlobals;
    @NotNull
    private final CopyOnWriteArrayList<LuaValue> clientTickCallbacks;
    @NotNull
    private final CopyOnWriteArrayList<LuaValue> renderWorldCallbacks;
    @NotNull
    private final CopyOnWriteArrayList<LuaValue> keyEvetCallbacks;

    public LuaManager() {
        Globals globals = JsePlatform.standardGlobals();
        Intrinsics.checkNotNullExpressionValue((Object)globals, (String)"standardGlobals(...)");
        this.globals = globals;
        this.persistentGlobals = new ConcurrentHashMap();
        this.clientTickCallbacks = new CopyOnWriteArrayList();
        this.renderWorldCallbacks = new CopyOnWriteArrayList();
        this.keyEvetCallbacks = new CopyOnWriteArrayList();
        this.registerCustomFunctions();
        this.registerGlobalObjects();
    }

    private final void registerCustomFunctions() {
        this.globals.set("print", (LuaValue)new OneArgFunction(){

            public LuaValue call(LuaValue message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                HypixelCry.LOGGER.info(message.tojstring());
                LuaValue luaValue = OneArgFunction.NIL;
                Intrinsics.checkNotNullExpressionValue((Object)luaValue, (String)"NIL");
                return luaValue;
            }
        });
        this.globals.set("registerClientTick", (LuaValue)new OneArgFunction(this){
            final /* synthetic */ LuaManager this$0;
            {
                this.this$0 = $receiver;
            }

            public LuaValue call(LuaValue callback) {
                Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
                LuaBoolean luaBoolean = LuaValue.valueOf(this.this$0.addClientTickCallback(callback));
                Intrinsics.checkNotNullExpressionValue((Object)luaBoolean, (String)"valueOf(...)");
                return luaBoolean;
            }
        });
        this.globals.set("registerWorldRenderer", (LuaValue)new OneArgFunction(this){
            final /* synthetic */ LuaManager this$0;
            {
                this.this$0 = $receiver;
            }

            public LuaValue call(LuaValue callback) {
                Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
                LuaBoolean luaBoolean = LuaValue.valueOf(this.this$0.addWorldRendererCallback(callback));
                Intrinsics.checkNotNullExpressionValue((Object)luaBoolean, (String)"valueOf(...)");
                return luaBoolean;
            }
        });
        this.globals.set("unregisterClientTick", (LuaValue)new OneArgFunction(this){
            final /* synthetic */ LuaManager this$0;
            {
                this.this$0 = $receiver;
            }

            public LuaValue call(LuaValue callback) {
                Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
                LuaBoolean luaBoolean = LuaValue.valueOf(this.this$0.removeClientTickCallback(callback));
                Intrinsics.checkNotNullExpressionValue((Object)luaBoolean, (String)"valueOf(...)");
                return luaBoolean;
            }
        });
        this.globals.set("unregisterWorldRenderer", (LuaValue)new OneArgFunction(this){
            final /* synthetic */ LuaManager this$0;
            {
                this.this$0 = $receiver;
            }

            public LuaValue call(LuaValue callback) {
                Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
                LuaBoolean luaBoolean = LuaValue.valueOf(this.this$0.removeWorldRendererCallback(callback));
                Intrinsics.checkNotNullExpressionValue((Object)luaBoolean, (String)"valueOf(...)");
                return luaBoolean;
            }
        });
    }

    public final boolean addClientTickCallback(@NotNull LuaValue callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        if (callback.isfunction()) {
            this.clientTickCallbacks.add(callback);
            return true;
        }
        return false;
    }

    public final boolean addWorldRendererCallback(@NotNull LuaValue callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        if (callback.isfunction()) {
            this.renderWorldCallbacks.add(callback);
            return true;
        }
        return false;
    }

    public final boolean addKeyEventCallback(@NotNull LuaValue callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        if (callback.isfunction()) {
            this.keyEvetCallbacks.add(callback);
            return true;
        }
        return false;
    }

    public final boolean removeClientTickCallback(@NotNull LuaValue callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        return this.clientTickCallbacks.remove(callback);
    }

    public final boolean removeWorldRendererCallback(@NotNull LuaValue callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        return this.renderWorldCallbacks.remove(callback);
    }

    public final boolean removeKeyEventCallback(@NotNull LuaValue callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        return this.keyEvetCallbacks.remove(callback);
    }

    public final void clearAllCallbacks() {
        this.clientTickCallbacks.clear();
        this.renderWorldCallbacks.clear();
        this.keyEvetCallbacks.clear();
    }

    private final void registerGlobalObjects() {
        this.globals.set("player", (LuaValue)new PlayerObject());
        this.globals.set("world", (LuaValue)new WorldObject());
        this.globals.set("modules", (LuaValue)new ModulesObject());
    }

    public final void onClientTick() {
        Iterable $this$forEach$iv = this.clientTickCallbacks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LuaValue callback = (LuaValue)element$iv;
            boolean bl = false;
            try {
                callback.call();
            }
            catch (Exception e) {
                System.out.println((Object)("Error in client tick callback: " + e.getMessage()));
            }
        }
    }

    public final void onRenderTick(@Nullable WorldRenderContext context) {
        Iterable $this$forEach$iv = this.renderWorldCallbacks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LuaValue callback = (LuaValue)element$iv;
            boolean bl = false;
            WorldRendererObject renderContext = new WorldRendererObject(context);
            try {
                callback.call(renderContext);
            }
            catch (Exception e) {
                System.out.println((Object)("Error in world render callback: " + e.getMessage()));
            }
        }
    }

    public final void onKeyEvent(int key, @NotNull KeyAction type2) {
        Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
        Iterable $this$forEach$iv = this.keyEvetCallbacks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LuaValue callback = (LuaValue)element$iv;
            boolean bl = false;
            try {
                callback.call(LuaValue.valueOf(key), LuaValue.valueOf(type2.name()));
            }
            catch (Exception e) {
                System.out.println((Object)("Error in key callback: " + e.getMessage()));
            }
        }
    }

    @NotNull
    public final Object executeScript(@NotNull String script) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        LuaValue chunk = this.globals.load(script);
        LuaValue result = chunk.call();
        this.restoreGlobals();
        Intrinsics.checkNotNull((Object)result);
        return result;
    }

    private final void restoreGlobals() {
        Map $this$forEach$iv = this.persistentGlobals;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            String name = (String)entry.getKey();
            LuaValue value = (LuaValue)entry.getValue();
            this.globals.set(name, value);
        }
    }
}

