/*
 * Decompiled with CFR 0.152.
 */
package com.nekiplay.hypixelcry.utils;

import com.nekiplay.hypixelcry.HypixelCry;
import com.nekiplay.hypixelcry.annotations.Init;
import com.nekiplay.hypixelcry.events.SendMovementPacketsEvent;
import com.nekiplay.hypixelcry.utils.misc.Pool;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2828;
import net.minecraft.class_310;
import net.minecraft.class_3532;

public class Rotations {
    private static final Pool<Rotation> rotationPool = new Pool<Rotation>(Rotation::new);
    private static final List<Rotation> rotations = new ArrayList<Rotation>();
    public static float serverYaw;
    public static float serverPitch;
    public static int rotationTimer;
    private static float preYaw;
    private static float prePitch;
    private static int i;
    private static Rotation lastRotation;
    private static int lastRotationTimer;
    private static boolean sentLastRotation;
    public static boolean rotating;

    @Init
    public static void init() {
        SendMovementPacketsEvent.PRE.register(Rotations::onSendMovementPacketsPre);
        SendMovementPacketsEvent.POST.register(Rotations::onSendMovementPacketsPost);
        ClientTickEvents.END_CLIENT_TICK.register(Rotations::onTick);
    }

    public static void rotate(double yaw, double pitch, int priority, boolean clientSide, Runnable callback) {
        int i2;
        Rotation rotation = rotationPool.get();
        rotation.set(yaw, pitch, priority, clientSide, callback);
        for (i2 = 0; i2 < rotations.size() && priority <= Rotations.rotations.get((int)i2).priority; ++i2) {
        }
        rotations.add(i2, rotation);
    }

    public static void rotate(double yaw, double pitch, int priority, Runnable callback) {
        Rotations.rotate(yaw, pitch, priority, false, callback);
    }

    public static void rotate(double yaw, double pitch, Runnable callback) {
        Rotations.rotate(yaw, pitch, 0, callback);
    }

    public static void rotate(double yaw, double pitch, int priority) {
        Rotations.rotate(yaw, pitch, priority, null);
    }

    public static void rotate(double yaw, double pitch) {
        Rotations.rotate(yaw, pitch, 0, null);
    }

    private static void resetLastRotation() {
        if (lastRotation != null) {
            rotationPool.free(lastRotation);
            lastRotation = null;
            lastRotationTimer = 0;
        }
    }

    private static void onSendMovementPacketsPre() {
        if (HypixelCry.mc.field_1719 != HypixelCry.mc.field_1724) {
            return;
        }
        sentLastRotation = false;
        if (!rotations.isEmpty()) {
            rotating = true;
            Rotations.resetLastRotation();
            Rotation rotation = rotations.get(i);
            Rotations.setupMovementPacketRotation(rotation);
            if (rotations.size() > 1) {
                rotationPool.free(rotation);
            }
            ++i;
        } else if (lastRotation != null) {
            if (lastRotationTimer >= 1) {
                Rotations.resetLastRotation();
                rotating = false;
            } else {
                Rotations.setupMovementPacketRotation(lastRotation);
                sentLastRotation = true;
                ++lastRotationTimer;
            }
        }
    }

    private static void setupMovementPacketRotation(Rotation rotation) {
        Rotations.setClientRotation(rotation);
        Rotations.setCamRotation(rotation.yaw, rotation.pitch);
    }

    private static void setClientRotation(Rotation rotation) {
        preYaw = HypixelCry.mc.field_1724.method_36454();
        prePitch = HypixelCry.mc.field_1724.method_36455();
        HypixelCry.mc.field_1724.method_36456((float)rotation.yaw);
        HypixelCry.mc.field_1724.method_36457((float)rotation.pitch);
    }

    private static void onSendMovementPacketsPost() {
        if (!rotations.isEmpty()) {
            if (HypixelCry.mc.field_1719 == HypixelCry.mc.field_1724) {
                rotations.get(i - 1).runCallback();
                if (rotations.size() == 1) {
                    lastRotation = rotations.get(i - 1);
                }
                Rotations.resetPreRotation();
            }
            while (i < rotations.size()) {
                Rotation rotation = rotations.get(i);
                Rotations.setCamRotation(rotation.yaw, rotation.pitch);
                if (rotation.clientSide) {
                    Rotations.setClientRotation(rotation);
                }
                rotation.sendPacket();
                if (rotation.clientSide) {
                    Rotations.resetPreRotation();
                }
                if (i == rotations.size() - 1) {
                    lastRotation = rotation;
                } else {
                    rotationPool.free(rotation);
                }
                ++i;
            }
            rotations.clear();
            i = 0;
        } else if (sentLastRotation) {
            Rotations.resetPreRotation();
        }
    }

    private static void resetPreRotation() {
        HypixelCry.mc.field_1724.method_36456(preYaw);
        HypixelCry.mc.field_1724.method_36457(prePitch);
    }

    private static void onTick(class_310 client) {
        ++rotationTimer;
    }

    public static double getYaw(class_1297 entity) {
        return HypixelCry.mc.field_1724.method_36454() + class_3532.method_15393((float)((float)Math.toDegrees(Math.atan2(entity.method_23321() - HypixelCry.mc.field_1724.method_23321(), entity.method_23317() - HypixelCry.mc.field_1724.method_23317())) - 90.0f - HypixelCry.mc.field_1724.method_36454()));
    }

    public static double getYaw(class_243 pos) {
        return HypixelCry.mc.field_1724.method_36454() + class_3532.method_15393((float)((float)Math.toDegrees(Math.atan2(pos.method_10215() - HypixelCry.mc.field_1724.method_23321(), pos.method_10216() - HypixelCry.mc.field_1724.method_23317())) - 90.0f - HypixelCry.mc.field_1724.method_36454()));
    }

    public static double getPitch(class_243 pos) {
        double diffX = pos.method_10216() - HypixelCry.mc.field_1724.method_23317();
        double diffY = pos.method_10214() - (HypixelCry.mc.field_1724.method_23318() + (double)HypixelCry.mc.field_1724.method_18381(HypixelCry.mc.field_1724.method_18376()));
        double diffZ = pos.method_10215() - HypixelCry.mc.field_1724.method_23321();
        double diffXZ = Math.sqrt(diffX * diffX + diffZ * diffZ);
        return HypixelCry.mc.field_1724.method_36455() + class_3532.method_15393((float)((float)(-Math.toDegrees(Math.atan2(diffY, diffXZ))) - HypixelCry.mc.field_1724.method_36455()));
    }

    public static double getPitch(class_1297 entity) {
        double y = entity.method_23318() + (double)(entity.method_17682() / 2.0f);
        double diffX = entity.method_23317() - HypixelCry.mc.field_1724.method_23317();
        double diffY = y - (HypixelCry.mc.field_1724.method_23318() + (double)HypixelCry.mc.field_1724.method_18381(HypixelCry.mc.field_1724.method_18376()));
        double diffZ = entity.method_23321() - HypixelCry.mc.field_1724.method_23321();
        double diffXZ = Math.sqrt(diffX * diffX + diffZ * diffZ);
        return HypixelCry.mc.field_1724.method_36455() + class_3532.method_15393((float)((float)(-Math.toDegrees(Math.atan2(diffY, diffXZ))) - HypixelCry.mc.field_1724.method_36455()));
    }

    public static double getYaw(class_2338 pos) {
        return HypixelCry.mc.field_1724.method_36454() + class_3532.method_15393((float)((float)Math.toDegrees(Math.atan2((double)pos.method_10260() + 0.5 - HypixelCry.mc.field_1724.method_23321(), (double)pos.method_10263() + 0.5 - HypixelCry.mc.field_1724.method_23317())) - 90.0f - HypixelCry.mc.field_1724.method_36454()));
    }

    public static double getPitch(class_2338 pos) {
        double diffX = (double)pos.method_10263() + 0.5 - HypixelCry.mc.field_1724.method_23317();
        double diffY = (double)pos.method_10264() + 0.5 - (HypixelCry.mc.field_1724.method_23318() + (double)HypixelCry.mc.field_1724.method_18381(HypixelCry.mc.field_1724.method_18376()));
        double diffZ = (double)pos.method_10260() + 0.5 - HypixelCry.mc.field_1724.method_23321();
        double diffXZ = Math.sqrt(diffX * diffX + diffZ * diffZ);
        return HypixelCry.mc.field_1724.method_36455() + class_3532.method_15393((float)((float)(-Math.toDegrees(Math.atan2(diffY, diffXZ))) - HypixelCry.mc.field_1724.method_36455()));
    }

    public static void setCamRotation(double yaw, double pitch) {
        serverYaw = (float)yaw;
        serverPitch = (float)pitch;
        rotationTimer = 0;
    }

    static {
        i = 0;
        rotating = false;
    }

    private static class Rotation {
        public double yaw;
        public double pitch;
        public int priority;
        public boolean clientSide;
        public Runnable callback;

        private Rotation() {
        }

        public void set(double yaw, double pitch, int priority, boolean clientSide, Runnable callback) {
            this.yaw = yaw;
            this.pitch = pitch;
            this.priority = priority;
            this.clientSide = clientSide;
            this.callback = callback;
        }

        public void sendPacket() {
            HypixelCry.mc.method_1562().method_52787((class_2596)new class_2828.class_2831((float)this.yaw, (float)this.pitch, HypixelCry.mc.field_1724.method_24828(), HypixelCry.mc.field_1724.field_5976));
            this.runCallback();
        }

        public void runCallback() {
            if (this.callback != null) {
                this.callback.run();
            }
        }
    }
}

