/*
 * Decompiled with CFR 0.152.
 */
package com.nekiplay.hypixelcry.utils.render;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.systems.RenderSystem;
import com.nekiplay.hypixelcry.annotations.Init;
import com.nekiplay.hypixelcry.mixins.BeaconBlockEntityRendererInvoker;
import com.nekiplay.hypixelcry.utils.render.FrustumUtils;
import com.nekiplay.hypixelcry.utils.render.Renderer;
import com.nekiplay.hypixelcry.utils.render.SkyblockerRenderPipelines;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.fabricmc.fabric.api.event.Event;
import net.minecraft.class_10209;
import net.minecraft.class_10799;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3695;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5481;
import net.minecraft.class_638;
import net.minecraft.class_9848;
import net.minecraft.class_9974;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class RenderHelper {
    private static final class_2960 TRANSLUCENT_DRAW = class_2960.method_60655((String)"hypixelcry", (String)"translucent_draw");
    private static final int MAX_OVERWORLD_BUILD_HEIGHT = 319;
    private static final class_310 CLIENT = class_310.method_1551();

    @Init
    public static void init() {
        WorldRenderEvents.AFTER_TRANSLUCENT.addPhaseOrdering(Event.DEFAULT_PHASE, TRANSLUCENT_DRAW);
        WorldRenderEvents.AFTER_TRANSLUCENT.register(TRANSLUCENT_DRAW, RenderHelper::drawTranslucents);
    }

    public static void renderFilledWithBeaconBeam(WorldRenderContext context, class_2338 pos, float[] colorComponents, float alpha, boolean throughWalls) {
        RenderHelper.renderFilled(context, pos, colorComponents, alpha, throughWalls);
        RenderHelper.renderBeaconBeam(context, pos, colorComponents);
    }

    public static void renderFilled(WorldRenderContext context, class_2338 pos, float[] colorComponents, float alpha, boolean throughWalls) {
        RenderHelper.renderFilled(context, pos.method_10263(), pos.method_10264(), pos.method_10260(), pos.method_10263() + 1, pos.method_10264() + 1, pos.method_10260() + 1, colorComponents, alpha, throughWalls);
    }

    public static void renderFilled(WorldRenderContext context, class_243 pos, class_243 dimensions, float[] colorComponents, float alpha, boolean throughWalls) {
        RenderHelper.renderFilled(context, pos.field_1352, pos.field_1351, pos.field_1350, pos.field_1352 + dimensions.field_1352, pos.field_1351 + dimensions.field_1351, pos.field_1350 + dimensions.field_1350, colorComponents, alpha, throughWalls);
    }

    public static void renderFilled(WorldRenderContext context, class_238 box, float[] colorComponents, float alpha, boolean throughWalls) {
        RenderHelper.renderFilled(context, box.field_1323, box.field_1322, box.field_1321, box.field_1320, box.field_1325, box.field_1324, colorComponents, alpha, throughWalls);
    }

    public static void renderFilled(WorldRenderContext context, double minX, double minY, double minZ, double maxX, double maxY, double maxZ, float[] colorComponents, float alpha, boolean throughWalls) {
        if (FrustumUtils.isVisible(minX, minY, minZ, maxX, maxY, maxZ)) {
            RenderHelper.renderFilledInternal(context, minX, minY, minZ, maxX, maxY, maxZ, colorComponents, alpha, throughWalls);
        }
    }

    private static void renderFilledInternal(WorldRenderContext context, double minX, double minY, double minZ, double maxX, double maxY, double maxZ, float[] colorComponents, float alpha, boolean throughWalls) {
        class_4587 matrices = context.matrixStack();
        class_243 camera = context.camera().method_19326();
        matrices.method_22903();
        matrices.method_22904(-camera.field_1352, -camera.field_1351, -camera.field_1350);
        class_287 buffer = Renderer.getBuffer(throughWalls ? SkyblockerRenderPipelines.FILLED_THROUGH_WALLS : class_10799.field_56837);
        class_9974.method_62300((class_4587)matrices, (class_4588)buffer, (double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ, (float)colorComponents[0], (float)colorComponents[1], (float)colorComponents[2], (float)alpha);
        matrices.method_22909();
    }

    public static void renderBeaconBeam(WorldRenderContext context, class_2338 pos, float[] colorComponents) {
        if (FrustumUtils.isVisible(pos.method_10263(), pos.method_10264(), pos.method_10260(), pos.method_10263() + 1, 319.0, pos.method_10260() + 1)) {
            class_4587 matrices = context.matrixStack();
            class_243 camera = context.camera().method_19326();
            matrices.method_22903();
            matrices.method_22904((double)pos.method_10263() - camera.method_10216(), (double)pos.method_10264() - camera.method_10214(), (double)pos.method_10260() - camera.method_10215());
            float length = (float)camera.method_1020(pos.method_46558()).method_37267();
            float scale = RenderHelper.CLIENT.field_1724 != null && RenderHelper.CLIENT.field_1724.method_31550() ? 1.0f : Math.max(1.0f, length / 96.0f);
            BeaconBlockEntityRendererInvoker.renderBeam(matrices, context.consumers(), context.tickCounter().method_60637(true), scale, context.world().method_8510(), 0, 319, class_9848.method_61318((float)1.0f, (float)colorComponents[0], (float)colorComponents[1], (float)colorComponents[2]));
            matrices.method_22909();
        }
    }

    public static void renderOutline(WorldRenderContext context, class_2338 pos, float[] colorComponents, float lineWidth, boolean throughWalls) {
        RenderHelper.renderOutline(context, pos.method_10263(), pos.method_10264(), pos.method_10260(), pos.method_10263() + 1, pos.method_10264() + 1, pos.method_10260() + 1, colorComponents, 1.0f, lineWidth, throughWalls);
    }

    public static void renderOutline(WorldRenderContext context, class_243 pos, class_243 dimensions, float[] colorComponents, float lineWidth, boolean throughWalls) {
        RenderHelper.renderOutline(context, pos.field_1352, pos.field_1351, pos.field_1350, pos.field_1352 + dimensions.field_1352, pos.field_1351 + dimensions.field_1351, pos.field_1350 + dimensions.field_1350, colorComponents, 1.0f, lineWidth, throughWalls);
    }

    public static void renderOutline(WorldRenderContext context, class_238 box, float[] colorComponents, float lineWidth, boolean throughWalls) {
        RenderHelper.renderOutline(context, box, colorComponents, 1.0f, lineWidth, throughWalls);
    }

    public static void renderOutline(WorldRenderContext context, class_238 box, float[] colorComponents, float alpha, float lineWidth, boolean throughWalls) {
        RenderHelper.renderOutline(context, box.field_1323, box.field_1322, box.field_1321, box.field_1320, box.field_1325, box.field_1324, colorComponents, alpha, lineWidth, throughWalls);
    }

    public static void renderOutline(WorldRenderContext context, double minX, double minY, double minZ, double maxX, double maxY, double maxZ, float[] colorComponents, float alpha, float lineWidth, boolean throughWalls) {
        if (FrustumUtils.isVisible(minX, minY, minZ, maxX, maxY, maxZ)) {
            class_4587 matrices = context.matrixStack();
            class_243 camera = context.camera().method_19326();
            matrices.method_22903();
            matrices.method_22904(-camera.method_10216(), -camera.method_10214(), -camera.method_10215());
            RenderPipeline pipeline = throughWalls ? SkyblockerRenderPipelines.LINES_THROUGH_WALLS : class_10799.field_56833;
            class_287 buffer = Renderer.getBuffer(pipeline, lineWidth);
            class_9974.method_62292((class_4587)matrices, (class_4588)buffer, (double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ, (float)colorComponents[0], (float)colorComponents[1], (float)colorComponents[2], (float)alpha);
            matrices.method_22909();
        }
    }

    public static void renderLinesFromPoints(WorldRenderContext context, class_243[] points, float[] colorComponents, float alpha, float lineWidth, boolean throughWalls) {
        class_243 camera = context.camera().method_19326();
        class_4587 matrices = context.matrixStack();
        matrices.method_22903();
        matrices.method_22904(-camera.field_1352, -camera.field_1351, -camera.field_1350);
        class_4587.class_4665 entry = matrices.method_23760();
        RenderPipeline pipeline = throughWalls ? SkyblockerRenderPipelines.LINES_THROUGH_WALLS : class_10799.field_56833;
        class_287 buffer = Renderer.getBuffer(pipeline, lineWidth);
        for (int i2 = 0; i2 < points.length; ++i2) {
            class_243 nextPoint = points[i2 + 1 == points.length ? i2 - 1 : i2 + 1];
            Vector3f normalVec = nextPoint.method_46409().sub((float)points[i2].method_10216(), (float)points[i2].method_10214(), (float)points[i2].method_10215()).normalize();
            if (i2 + 1 == points.length) {
                normalVec.negate();
            }
            buffer.method_56824(entry, (float)points[i2].method_10216(), (float)points[i2].method_10214(), (float)points[i2].method_10215()).method_22915(colorComponents[0], colorComponents[1], colorComponents[2], alpha).method_61959(entry, normalVec);
        }
        matrices.method_22909();
    }

    public static void renderLineFromCursor(WorldRenderContext context, class_243 point, float[] colorComponents, float alpha, float lineWidth) {
        class_243 camera = context.camera().method_19326();
        class_4587 matrices = context.matrixStack();
        matrices.method_22903();
        matrices.method_22904(-camera.field_1352, -camera.field_1351, -camera.field_1350);
        class_4587.class_4665 entry = matrices.method_23760();
        RenderPipeline pipeline = SkyblockerRenderPipelines.LINES_THROUGH_WALLS;
        class_287 buffer = Renderer.getBuffer(pipeline, lineWidth);
        class_243 cameraPoint = camera.method_1019(class_243.method_1030((float)context.camera().method_19329(), (float)context.camera().method_19330()));
        Vector3f normal = point.method_46409().sub((float)cameraPoint.field_1352, (float)cameraPoint.field_1351, (float)cameraPoint.field_1350).normalize();
        buffer.method_56824(entry, (float)cameraPoint.field_1352, (float)cameraPoint.field_1351, (float)cameraPoint.field_1350).method_22915(colorComponents[0], colorComponents[1], colorComponents[2], alpha).method_61959(entry, normal);
        buffer.method_56824(entry, (float)point.method_10216(), (float)point.method_10214(), (float)point.method_10215()).method_22915(colorComponents[0], colorComponents[1], colorComponents[2], alpha).method_61959(entry, normal);
        matrices.method_22909();
    }

    public static void renderQuad(WorldRenderContext context, class_243[] points, float[] colorComponents, float alpha, boolean throughWalls) {
        Matrix4f positionMatrix = new Matrix4f();
        class_243 camera = context.camera().method_19326();
        positionMatrix.translate((float)(-camera.field_1352), (float)(-camera.field_1351), (float)(-camera.field_1350));
        RenderPipeline pipeline = throughWalls ? SkyblockerRenderPipelines.QUADS_THROUGH_WALLS : class_10799.field_56865;
        class_287 buffer = Renderer.getBuffer(pipeline);
        for (int i2 = 0; i2 < 4; ++i2) {
            buffer.method_22918(positionMatrix, (float)points[i2].method_10216(), (float)points[i2].method_10214(), (float)points[i2].method_10215()).method_22915(colorComponents[0], colorComponents[1], colorComponents[2], alpha);
        }
    }

    public static void renderTextureInWorld(WorldRenderContext context, class_243 pos, float width, float height, float textureWidth, float textureHeight, class_243 renderOffset, class_2960 texture, float[] shaderColor, float alpha, boolean throughWalls) {
        Matrix4f positionMatrix = new Matrix4f();
        class_4184 camera = context.camera();
        class_243 cameraPos = camera.method_19326();
        positionMatrix.translate((float)(pos.method_10216() - cameraPos.method_10216()), (float)(pos.method_10214() - cameraPos.method_10214()), (float)(pos.method_10215() - cameraPos.method_10215())).rotate((Quaternionfc)camera.method_23767());
        RenderPipeline pipeline = throughWalls ? SkyblockerRenderPipelines.TEXTURE_THROUGH_WALLS : SkyblockerRenderPipelines.TEXTURE;
        class_287 buffer = Renderer.getBuffer(pipeline, CLIENT.method_1531().method_4619(texture).method_71659());
        int color = class_9848.method_61318((float)alpha, (float)shaderColor[0], (float)shaderColor[1], (float)shaderColor[2]);
        buffer.method_22918(positionMatrix, (float)renderOffset.method_10216(), (float)renderOffset.method_10214(), (float)renderOffset.method_10215()).method_22913(1.0f, 1.0f - textureHeight).method_39415(color);
        buffer.method_22918(positionMatrix, (float)renderOffset.method_10216(), (float)renderOffset.method_10214() + height, (float)renderOffset.method_10215()).method_22913(1.0f, 1.0f).method_39415(color);
        buffer.method_22918(positionMatrix, (float)renderOffset.method_10216() + width, (float)renderOffset.method_10214() + height, (float)renderOffset.method_10215()).method_22913(1.0f - textureWidth, 1.0f).method_39415(color);
        buffer.method_22918(positionMatrix, (float)renderOffset.method_10216() + width, (float)renderOffset.method_10214(), (float)renderOffset.method_10215()).method_22913(1.0f - textureWidth, 1.0f - textureHeight).method_39415(color);
    }

    public static void renderText(WorldRenderContext context, class_2561 text, class_243 pos, boolean throughWalls) {
        RenderHelper.renderText(context, text, pos, 1.0f, throughWalls);
    }

    public static void renderText(WorldRenderContext context, class_2561 text, class_243 pos, float scale, boolean throughWalls) {
        RenderHelper.renderText(context, text, pos, scale, 0.0f, throughWalls);
    }

    public static void renderText(WorldRenderContext context, class_2561 text, class_243 pos, float scale, float yOffset, boolean throughWalls) {
        RenderHelper.renderText(context, text.method_30937(), pos, scale, yOffset, throughWalls);
    }

    public static void renderText(WorldRenderContext context, class_5481 text, class_243 pos, float scale, float yOffset, boolean throughWalls) {
        Matrix4f positionMatrix = new Matrix4f();
        class_4184 camera = context.camera();
        class_243 cameraPos = camera.method_19326();
        class_327 textRenderer = RenderHelper.CLIENT.field_1772;
        positionMatrix.translate((float)(pos.method_10216() - cameraPos.method_10216()), (float)(pos.method_10214() - cameraPos.method_10214()), (float)(pos.method_10215() - cameraPos.method_10215())).rotate((Quaternionfc)camera.method_23767()).scale(scale *= 0.025f, -scale, scale);
        float xOffset = (float)(-textRenderer.method_30880(text)) / 2.0f;
        textRenderer.method_22942(text, xOffset, yOffset, -1, false, positionMatrix, context.consumers(), throughWalls ? class_327.class_6415.field_33994 : class_327.class_6415.field_33993, 0, 0xF000F0);
        ((class_4597.class_4598)context.consumers()).method_22993();
    }

    public static void renderText(WorldRenderContext context, class_5481 text, class_243 pos, float alpha, float[] shaderColor, float scale, float yOffset, boolean throughWalls) {
        Matrix4f positionMatrix = new Matrix4f();
        class_4184 camera = context.camera();
        class_243 cameraPos = camera.method_19326();
        class_327 textRenderer = RenderHelper.CLIENT.field_1772;
        positionMatrix.translate((float)(pos.method_10216() - cameraPos.method_10216()), (float)(pos.method_10214() - cameraPos.method_10214()), (float)(pos.method_10215() - cameraPos.method_10215())).rotate((Quaternionfc)camera.method_23767()).scale(scale *= 0.025f, -scale, scale);
        float xOffset = (float)(-textRenderer.method_30880(text)) / 2.0f;
        int color = class_9848.method_61318((float)alpha, (float)shaderColor[0], (float)shaderColor[1], (float)shaderColor[2]);
        textRenderer.method_22942(text, xOffset, yOffset, color, false, positionMatrix, context.consumers(), throughWalls ? class_327.class_6415.field_33994 : class_327.class_6415.field_33993, 0, 0xF000F0);
        ((class_4597.class_4598)context.consumers()).method_22993();
    }

    public static void renderText(WorldRenderContext context, class_5481 text, class_243 pos, int color, float scale, float yOffset, boolean throughWalls) {
        Matrix4f positionMatrix = new Matrix4f();
        class_4184 camera = context.camera();
        class_243 cameraPos = camera.method_19326();
        class_327 textRenderer = RenderHelper.CLIENT.field_1772;
        positionMatrix.translate((float)(pos.method_10216() - cameraPos.method_10216()), (float)(pos.method_10214() - cameraPos.method_10214()), (float)(pos.method_10215() - cameraPos.method_10215())).rotate((Quaternionfc)camera.method_23767()).scale(scale *= 0.025f, -scale, scale);
        float xOffset = (float)(-textRenderer.method_30880(text)) / 2.0f;
        textRenderer.method_22942(text, xOffset, yOffset, color, false, positionMatrix, context.consumers(), throughWalls ? class_327.class_6415.field_33994 : class_327.class_6415.field_33993, 0, 0xF000F0);
        ((class_4597.class_4598)context.consumers()).method_22993();
    }

    public static void renderCylinder(WorldRenderContext context, class_243 centre, float radius, float height, int segments, int color) {
        class_4587 matrices = context.matrixStack();
        class_243 camera = context.camera().method_19326();
        matrices.method_22903();
        matrices.method_22904(-camera.field_1352, -camera.field_1351, -camera.field_1350);
        class_287 buffer = Renderer.getBuffer(SkyblockerRenderPipelines.CYLINDER);
        Matrix4f positionMatrix = matrices.method_23760().method_23761();
        float halfHeight = height / 2.0f;
        for (int i2 = 0; i2 <= segments; ++i2) {
            double angle = Math.PI * 2 * (double)i2 / (double)segments;
            float dx = (float)Math.cos(angle) * radius;
            float dz = (float)Math.sin(angle) * radius;
            buffer.method_22918(positionMatrix, (float)centre.method_10216() + dx, (float)centre.method_10214() + halfHeight, (float)centre.method_10215() + dz).method_39415(color);
            buffer.method_22918(positionMatrix, (float)centre.method_10216() + dx, (float)centre.method_10214() - halfHeight, (float)centre.method_10215() + dz).method_39415(color);
        }
        matrices.method_22909();
    }

    public static void renderCircleFilled(WorldRenderContext context, class_243 centre, float radius, int segments, int color) {
        class_4587 matrices = context.matrixStack();
        class_243 camera = context.camera().method_19326();
        matrices.method_22903();
        matrices.method_22904(-camera.field_1352, -camera.field_1351, -camera.field_1350);
        class_287 buffer = Renderer.getBuffer(SkyblockerRenderPipelines.CIRCLE);
        Matrix4f positionMatrix = matrices.method_23760().method_23761();
        for (int i2 = 0; i2 <= segments; ++i2) {
            double angle = Math.PI * 2 * (double)i2 / (double)segments;
            float dx = (float)Math.cos(angle) * radius;
            float dz = (float)Math.sin(angle) * radius;
            buffer.method_22918(positionMatrix, (float)centre.method_10216() + dx, (float)centre.method_10214(), (float)centre.method_10215() + dz).method_39415(color);
        }
        matrices.method_22909();
    }

    public static void renderSphere(WorldRenderContext context, class_243 centre, float radius, int segments, int rings, int color) {
        class_4587 matrices = context.matrixStack();
        class_243 camera = context.camera().method_19326();
        matrices.method_22903();
        matrices.method_22904(-camera.field_1352, -camera.field_1351, -camera.field_1350);
        class_287 buffer = Renderer.getBuffer(SkyblockerRenderPipelines.CYLINDER);
        Matrix4f positionMatrix = matrices.method_23760().method_23761();
        for (int lat = 0; lat < rings; ++lat) {
            double lat0 = Math.PI * (double)lat / (double)rings;
            double lat1 = Math.PI * (double)(lat + 1) / (double)rings;
            float y0 = (float)Math.cos(lat0) * radius;
            float y1 = (float)Math.cos(lat1) * radius;
            float r0 = (float)Math.sin(lat0) * radius;
            float r1 = (float)Math.sin(lat1) * radius;
            for (int lon = 0; lon <= segments; ++lon) {
                double angle = Math.PI * 2 * (double)lon / (double)segments;
                float x0 = (float)Math.cos(angle);
                float z0 = (float)Math.sin(angle);
                buffer.method_22918(positionMatrix, Math.fma(x0, r0, (float)centre.method_10216()), (float)centre.method_10214() + y0, Math.fma(z0, r0, (float)centre.method_10215())).method_39415(color);
                buffer.method_22918(positionMatrix, Math.fma(x0, r1, (float)centre.method_10216()), (float)centre.method_10214() + y1, Math.fma(z0, r1, (float)centre.method_10215())).method_39415(color);
            }
        }
        matrices.method_22909();
    }

    public static void renderCircleOutlineWithQuads(WorldRenderContext context, class_243 centre, float radius, float thickness, int segments, int color) {
        class_4587 matrices = context.matrixStack();
        class_243 camera = context.camera().method_19326();
        matrices.method_22903();
        matrices.method_22904(-camera.field_1352, -camera.field_1351, -camera.field_1350);
        class_287 buffer = Renderer.getBuffer(SkyblockerRenderPipelines.CIRCLE_LINES);
        Matrix4f positionMatrix = matrices.method_23760().method_23761();
        float innerRadius = radius - thickness / 2.0f;
        float outerRadius = radius + thickness / 2.0f;
        for (int i2 = 0; i2 < segments; ++i2) {
            double angle1 = Math.PI * 2 * (double)i2 / (double)segments;
            double angle2 = Math.PI * 2 * (double)(i2 + 1) / (double)segments;
            float x1Inner = (float)Math.cos(angle1) * innerRadius;
            float z1Inner = (float)Math.sin(angle1) * innerRadius;
            float x1Outer = (float)Math.cos(angle1) * outerRadius;
            float z1Outer = (float)Math.sin(angle1) * outerRadius;
            float x2Inner = (float)Math.cos(angle2) * innerRadius;
            float z2Inner = (float)Math.sin(angle2) * innerRadius;
            float x2Outer = (float)Math.cos(angle2) * outerRadius;
            float z2Outer = (float)Math.sin(angle2) * outerRadius;
            float cx = (float)centre.method_10216();
            float cy = (float)centre.method_10214();
            float cz = (float)centre.method_10215();
            buffer.method_22918(positionMatrix, cx + x1Inner, cy, cz + z1Inner).method_39415(color);
            buffer.method_22918(positionMatrix, cx + x1Outer, cy, cz + z1Outer).method_39415(color);
            buffer.method_22918(positionMatrix, cx + x2Outer, cy, cz + z2Outer).method_39415(color);
            buffer.method_22918(positionMatrix, cx + x2Inner, cy, cz + z2Inner).method_39415(color);
        }
        matrices.method_22909();
    }

    private static void drawTranslucents(WorldRenderContext context) {
        class_3695 profiler = class_10209.method_64146();
        profiler.method_15396("skyblockerDraw");
        Renderer.executeDraws();
        profiler.method_15407();
    }

    public static void runOnRenderThread(Runnable runnable) {
        if (RenderSystem.isOnRenderThread()) {
            runnable.run();
        } else {
            CLIENT.execute(runnable);
        }
    }

    @Nullable
    public static class_238 getBlockBoundingBox(class_638 world, class_2338 pos) {
        return RenderHelper.getBlockBoundingBox(world, world.method_8320(pos), pos);
    }

    @Nullable
    public static class_238 getBlockBoundingBox(class_638 world, class_2680 state, class_2338 pos) {
        class_265 shape = state.method_26218((class_1922)world, pos).method_52620();
        return shape.method_1110() ? null : shape.method_1107().method_996(pos);
    }
}

