/*
 * Decompiled with CFR 0.152.
 */
package io.github.notenoughupdates.moulconfig.gui;

import io.github.notenoughupdates.moulconfig.gui.CloseEventListener;
import io.github.notenoughupdates.moulconfig.gui.FloatingGuiElement;
import io.github.notenoughupdates.moulconfig.gui.GuiComponent;
import java.util.ArrayList;
import java.util.List;
import org.jspecify.annotations.Nullable;

public class GuiContext {
    public final GuiComponent root;
    private @Nullable GuiComponent focusedElement;
    public List<FloatingGuiElement> floatingWindows = new ArrayList<FloatingGuiElement>();
    public Runnable closeRequestHandler;

    public void setFocusedElement(@Nullable GuiComponent focusedElement) {
        if (this.focusedElement == focusedElement) {
            return;
        }
        GuiComponent oldElement = this.focusedElement;
        if (oldElement != null) {
            oldElement.onLostFocus();
        }
        if (focusedElement != null) {
            focusedElement.onGainedFocus();
        }
        this.focusedElement = focusedElement;
    }

    public GuiContext(GuiComponent root) {
        this.root = root;
        root.foldRecursive(null, (guiElementNew, _void) -> {
            guiElementNew.setContext(this);
            return _void;
        });
    }

    public void onAfterClose() {
        this.root.foldRecursive(null, (component, _void) -> {
            if (component instanceof CloseEventListener) {
                ((CloseEventListener)((Object)component)).onAfterClose();
            }
            return _void;
        });
    }

    public CloseEventListener.CloseAction onBeforeClose() {
        return this.root.foldRecursive(CloseEventListener.CloseAction.NO_OBJECTIONS_TO_CLOSE, (component, action) -> {
            if (component instanceof CloseEventListener) {
                return ((CloseEventListener)((Object)component)).onBeforeClose().or((CloseEventListener.CloseAction)((Object)action));
            }
            return action;
        });
    }

    public void requestClose() {
        if (this.closeRequestHandler != null) {
            this.closeRequestHandler.run();
        }
    }

    public GuiComponent getRoot() {
        return this.root;
    }

    public @Nullable GuiComponent getFocusedElement() {
        return this.focusedElement;
    }

    public List<FloatingGuiElement> getFloatingWindows() {
        return this.floatingWindows;
    }

    public Runnable getCloseRequestHandler() {
        return this.closeRequestHandler;
    }

    public String toString() {
        return "GuiContext(root=" + this.getRoot() + ", focusedElement=" + this.getFocusedElement() + ", floatingWindows=" + this.getFloatingWindows() + ", closeRequestHandler=" + this.getCloseRequestHandler() + ")";
    }

    public void setFloatingWindows(List<FloatingGuiElement> floatingWindows) {
        this.floatingWindows = floatingWindows;
    }

    public void setCloseRequestHandler(Runnable closeRequestHandler) {
        this.closeRequestHandler = closeRequestHandler;
    }
}

