/*
 * Decompiled with CFR 0.152.
 */
package io.github.notenoughupdates.moulconfig.processor;

import io.github.notenoughupdates.moulconfig.Config;
import io.github.notenoughupdates.moulconfig.annotations.ConfigOption;
import io.github.notenoughupdates.moulconfig.common.text.StructuredText;
import io.github.notenoughupdates.moulconfig.gui.GuiOptionEditor;
import io.github.notenoughupdates.moulconfig.gui.editors.GuiOptionEditorAccordion;
import io.github.notenoughupdates.moulconfig.internal.Warnings;
import io.github.notenoughupdates.moulconfig.processor.BuiltinMoulConfigGuis;
import io.github.notenoughupdates.moulconfig.processor.ConfigProcessorDriver;
import io.github.notenoughupdates.moulconfig.processor.ConfigStructureReader;
import io.github.notenoughupdates.moulconfig.processor.ProcessedCategory;
import io.github.notenoughupdates.moulconfig.processor.ProcessedCategoryImpl;
import io.github.notenoughupdates.moulconfig.processor.ProcessedOption;
import io.github.notenoughupdates.moulconfig.processor.ProcessedOptionImpl;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Stack;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoulConfigProcessor<T extends Config>
implements ConfigStructureReader {
    private final T configBaseObject;
    private final LinkedHashMap<String, ProcessedCategoryImpl> categories = new LinkedHashMap();
    private ProcessedCategoryImpl currentCategory;
    private Stack<Integer> accordion = new Stack();
    private Stack<String> categoryPath = new Stack();
    private boolean isFinalized;
    private Map<Field, ProcessedOption> optionLookup = new HashMap<Field, ProcessedOption>();
    private Map<Class<? extends Annotation>, BiFunction<ProcessedOption, Annotation, GuiOptionEditor>> editors = new HashMap<Class<? extends Annotation>, BiFunction<ProcessedOption, Annotation, GuiOptionEditor>>();
    private ConfigProcessorDriver driver;

    public MoulConfigProcessor(T configBaseObject) {
        this.configBaseObject = configBaseObject;
    }

    public static <T extends Config> MoulConfigProcessor<T> withDefaults(T configBaseObject) {
        MoulConfigProcessor<T> moulConfigProcessor = new MoulConfigProcessor<T>(configBaseObject);
        BuiltinMoulConfigGuis.addProcessors(moulConfigProcessor);
        return moulConfigProcessor;
    }

    public <A extends Annotation> void registerConfigEditor(Class<A> annotation, BiFunction<ProcessedOption, ? extends A, GuiOptionEditor> editorGenerator) {
        this.editors.put(annotation, editorGenerator);
    }

    public void requireFinalized() {
        if (!this.isFinalized) {
            Warnings.warn("Finalization requirement on MoulConfigProcessor broken. Please first process a config", 4);
        }
    }

    @Override
    public void beginCategory(Object baseObject, Field field, String name, String description) {
        this.currentCategory = new ProcessedCategoryImpl(field, StructuredText.of(name), StructuredText.of(description));
        this.categories.put(this.currentCategory.getIdentifier(), this.currentCategory);
    }

    public T getConfigObject() {
        return this.configBaseObject;
    }

    @Override
    public void pushPath(String fieldPath) {
        this.categoryPath.push(fieldPath);
    }

    @Override
    public void beginConfig(Class<? extends Config> configClass, ConfigProcessorDriver driver, Config configObject) {
        this.driver = driver;
        if (this.editors.isEmpty()) {
            Warnings.warn("Calling a config processor with no editors registered. Consider registering editors using BuiltinMoulConfigGuis.addProcessors or MoulConfigProcessor.withDefaults");
        }
        if (this.isFinalized) {
            Warnings.warn("Processing a finalized config");
        }
    }

    @Override
    public void endConfig() {
        this.isFinalized = true;
    }

    @Override
    public void popPath() {
        this.categoryPath.pop();
    }

    @Override
    public void endCategory() {
        for (ProcessedOption option : this.currentCategory.options) {
            GuiOptionEditor editor = option.getEditor();
            if (!(editor instanceof GuiOptionEditorAccordion)) continue;
            this.currentCategory.accordionAnchors.put(((GuiOptionEditorAccordion)editor).getAccordionId(), option);
        }
        this.accordion.clear();
    }

    @Override
    public void beginAccordion(Object baseObject, Field field, ConfigOption option, int id) {
        ProcessedOptionImpl processedOption = this.createProcessedOption(baseObject, field, option);
        processedOption.editor = new GuiOptionEditorAccordion(processedOption, id);
        this.currentCategory.options.add(processedOption);
        this.accordion.push(id);
    }

    @Override
    public void endAccordion() {
        this.accordion.pop();
    }

    @Override
    public void emitOption(Object baseObject, Field field, ConfigOption option) {
        ProcessedOptionImpl processedOption = this.createProcessedOption(baseObject, field, option);
        GuiOptionEditor optionGui = this.createOptionGui(processedOption, field, option);
        if (optionGui == null) {
            Warnings.warn("Could not create GUI Option Editor for " + field + " in " + baseObject.getClass());
            return;
        }
        processedOption.editor = optionGui;
        this.currentCategory.options.add(processedOption);
    }

    protected ProcessedOptionImpl createProcessedOption(Object baseObject, Field field, ConfigOption option) {
        ProcessedOptionImpl processedOption = new ProcessedOptionImpl(StructuredText.of(option.name()), StructuredText.of(option.desc()), String.join((CharSequence)".", this.categoryPath) + "." + field.getName(), field, this.currentCategory, baseObject, (Config)this.configBaseObject);
        this.optionLookup.put(field, processedOption);
        if (!this.accordion.isEmpty()) {
            processedOption.accordionId = this.accordion.peek();
        }
        return processedOption;
    }

    @Override
    public void setCategoryParent(Field field) {
        this.currentCategory.parent = field.toString();
    }

    protected GuiOptionEditor createOptionGui(ProcessedOption processedOption, Field field, ConfigOption option) {
        for (Map.Entry<Class<? extends Annotation>, BiFunction<ProcessedOption, Annotation, GuiOptionEditor>> entry : this.editors.entrySet()) {
            GuiOptionEditor editor;
            Annotation annotation = field.getAnnotation(entry.getKey());
            if (annotation == null || (editor = entry.getValue().apply(processedOption, annotation)) == null) continue;
            return editor;
        }
        return null;
    }

    public LinkedHashMap<String, ? extends ProcessedCategory> getAllCategories() {
        this.requireFinalized();
        return this.categories;
    }

    @Nullable
    public ProcessedOption getOptionFromField(@NotNull Field field) {
        this.requireFinalized();
        return this.optionLookup.get(field);
    }

    public boolean isFinalized() {
        return this.isFinalized;
    }
}

