/*
 * Decompiled with CFR 0.152.
 */
package com.nekiplay.hypixelcry.DataInterpretation;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.nekiplay.hypixelcry.EventIDs;
import com.nekiplay.hypixelcry.HypixelCry;
import com.nekiplay.hypixelcry.utils.ApecUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.scoreboard.Score;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.Tuple;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.apache.commons.lang3.reflect.FieldUtils;

public class DataExtractor {
    private final char HpSymbol = (char)10084;
    private final char MnSymbol = (char)9998;
    private final char[] healDurationSymbols = new char[]{'\u2586', '\u2585', '\u2584', '\u2583', '\u2582', '\u2581'};
    private final String endRaceSymbol = "THE END RACE";
    private final String woodRacingSymbol = "WOODS RACING";
    private final String dpsSymbol = "DPS";
    private final String secSymbol = "second";
    private final String secretSymbol = "Secrets";
    private final String chickenRaceSymbol = "CHICKEN RACING";
    private final String jumpSymbol = "JUMP";
    private final String crystalRaceSymbol = "CRYSTAL CORE RACE";
    private final String giantMushroomSymbol = "GIANT MUSHROOM RACE";
    private final String precursorRuinsSymbol = "PRECURSOR RUINS RACE";
    private final String armadilloName = "Armadillo";
    private boolean alreadyShowedTabError = false;
    private boolean alreadyShowedScrErr = false;
    private int lastHp = 1;
    private int lastBaseHp = 1;
    private int lastMn = 1;
    private int lastBaseMn = 1;
    private int lastDefence = 0;
    private int baseAp = 0;
    private int lastAp = 1;
    private int lastBaseAp = 1;
    private int baseOp = 1;
    private String lastHour = "";
    private String lastDate = "";
    private String lastZone = "";
    private String lastSkillXp = "";
    private String lastPurse = "";
    private boolean usesPiggyBank = false;
    private boolean hasSentATradeRequest = false;
    private boolean hasRecievedATradeRequest = false;
    public boolean isInTheCatacombs = false;
    private boolean wasInTheCatacombs = false;
    public boolean IsDeadInTheCatacombs = false;
    private int tradeTicks = 0;
    String actionBarData = "";
    String footerTabData = "";
    private PlayerStats playerStats;
    private List<String> scoreBoardLines;
    private final ScoreBoardData scoreBoardData = new ScoreBoardData();
    private OtherData otherData;
    public boolean isInSkyblock = false;
    boolean UpdateThisTick = false;

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onChatMsg(ClientChatReceivedEvent event) {
        String reviveSymbol = "Revive";
        if (event.message.func_150260_c().contains(String.valueOf('\u2764')) || event.message.func_150260_c().contains(String.valueOf('\u270e')) || event.message.func_150260_c().contains(reviveSymbol) || event.message.func_150260_c().contains("CHICKEN RACING") || event.message.func_150260_c().contains("Armadillo")) {
            this.IsDeadInTheCatacombs = event.message.func_150260_c().contains(reviveSymbol);
            this.actionBarData = event.message.func_150260_c();
        } else if (!event.message.func_150260_c().contains("<") && !this.isFromChat(event.message.func_150254_d())) {
            String expireRecieveTradeRequest;
            String recieveTradeRequestMsg;
            String expireSentTradeRequest;
            String sendTradeRequestMsg;
            String msg = ApecUtils.removeAllCodes(event.message.func_150260_c());
            if (msg.contains(sendTradeRequestMsg = "You have sent a trade request to")) {
                this.hasSentATradeRequest = true;
            }
            if (msg.contains(expireSentTradeRequest = "Your /trade request to")) {
                this.hasSentATradeRequest = false;
            }
            if (msg.contains(recieveTradeRequestMsg = "has sent you a trade request")) {
                this.hasRecievedATradeRequest = true;
            }
            if (msg.contains(expireRecieveTradeRequest = "The /trade request from")) {
                this.hasRecievedATradeRequest = false;
            }
            String tradeCompleted = "Trade completed";
            String tradeCancelled = "You cancelled the trade!";
            if (msg.contains(tradeCancelled) || msg.contains(tradeCompleted)) {
                if (this.hasSentATradeRequest) {
                    this.hasSentATradeRequest = false;
                }
                if (this.hasRecievedATradeRequest) {
                    this.hasRecievedATradeRequest = false;
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onTick(TickEvent.ClientTickEvent event) {
        boolean bl = this.UpdateThisTick = !this.UpdateThisTick;
        if (this.UpdateThisTick) {
            block14: {
                try {
                    String s = this.getScoreBoardTitle();
                    if (!s.isEmpty()) {
                        this.isInSkyblock = ApecUtils.removeAllCodes(s).toLowerCase().contains("skyblock");
                        if (this.wasInTheCatacombs ^ this.isInTheCatacombs) {
                            this.wasInTheCatacombs = this.isInTheCatacombs;
                        }
                    }
                }
                catch (Exception s) {
                    // empty catch block
                }
                try {
                    IChatComponent icc = (IChatComponent)FieldUtils.readField((Object)HypixelCry.mc.field_71456_v.func_175181_h(), (String)ApecUtils.unObfedFieldNames.get("footer"), (boolean)true);
                    if (icc == null) {
                        this.footerTabData = "";
                    } else {
                        this.footerTabData = icc.func_150254_d();
                        this.alreadyShowedTabError = false;
                    }
                }
                catch (Exception e) {
                    if (this.alreadyShowedTabError) break block14;
                    this.alreadyShowedTabError = true;
                }
            }
            try {
                this.scoreBoardLines = this.getSidebarLines();
                this.scoreBoardLines = this.addDataFixesScoreboard(this.scoreBoardLines);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.ProcessScoreBoardData();
            this.playerStats = this.ProcessPlayerStats();
            this.otherData = this.ProcessOtherData(this.scoreBoardData);
            if (this.hasRecievedATradeRequest || this.hasSentATradeRequest) {
                ++this.tradeTicks;
                if (this.tradeTicks == 600) {
                    this.hasSentATradeRequest = false;
                    this.hasRecievedATradeRequest = false;
                }
            } else {
                this.tradeTicks = 0;
            }
        }
    }

    public List<String> addDataFixesScoreboard(List<String> s) {
        for (String _s : s) {
            if (!_s.contains("[") || _s.contains("]")) continue;
            _s.concat("\u00a7]");
        }
        return s;
    }

    public boolean ShouldHaveSpaceBefore(String s) {
        return ApecUtils.containedByCharSequence(s, "Objective") || ApecUtils.containedByCharSequence(s, "Contest") || ApecUtils.containedByCharSequence(s, "Year") || ApecUtils.containedByCharSequence(s, "Zoo") || ApecUtils.containedByCharSequence(s, "Festival") || ApecUtils.containedByCharSequence(s, "Season") || ApecUtils.containedByCharSequence(s, "Election") || ApecUtils.containedByCharSequence(s, "Slayer") || ApecUtils.containedByCharSequence(s, "Keys") || ApecUtils.containedByCharSequence(s, "Time Elapsed") || ApecUtils.containedByCharSequence(s, "Starting in:") || ApecUtils.containedByCharSequence(s, "Wave") || ApecUtils.containedByCharSequence(s, "Festival");
    }

    public boolean ShouldHaveSpaceAfter(String s) {
        return ApecUtils.containedByCharSequence(s, "Dungeon Cleared");
    }

    public boolean RepresentsIRLDate(String s) {
        return ApecUtils.containedByCharSequence(s, "//");
    }

    public boolean RepresentsDate(String s) {
        return !(!ApecUtils.containedByCharSequence(s, "Autumn") && !ApecUtils.containedByCharSequence(s, "Winter") && !ApecUtils.containedByCharSequence(s, "Spring") && !ApecUtils.containedByCharSequence(s, "Summer") || !ApecUtils.containedByCharSequence(s, "st") && !ApecUtils.containedByCharSequence(s, "nd") && !ApecUtils.containedByCharSequence(s, "rd") && !ApecUtils.containedByCharSequence(s, "th"));
    }

    public boolean RepresentsTime(String s) {
        return !(!ApecUtils.containedByCharSequence(s, "am") && !ApecUtils.containedByCharSequence(s, "pm") || !ApecUtils.containedByCharSequence(s, ":") || !ApecUtils.containedByCharSequence(s, "\u263d") && !ApecUtils.containedByCharSequence(s, "\u2600"));
    }

    public boolean RepresentsZone(String s) {
        return ApecUtils.containedByCharSequence(s, "\u23e3");
    }

    public boolean RepresentsPurse(String s) {
        return ApecUtils.containedByCharSequence(s, "Purse: ");
    }

    public boolean RepresentsPiggy(String s) {
        return ApecUtils.containedByCharSequence(s, "Piggy: ");
    }

    public boolean RepresentsBits(String s) {
        return ApecUtils.containedByCharSequence(s, "Bits: ");
    }

    private void ProcessScoreBoardData() {
        block4: {
            try {
                this.scoreBoardData.ExtraInfo.clear();
                int size = this.scoreBoardLines.size() - 1;
                this.isInTheCatacombs = false;
                for (int i2 = 0; i2 < this.scoreBoardLines.size(); ++i2) {
                    String clearedName = "dungeon cleared";
                    if (ApecUtils.containedByCharSequence(this.scoreBoardLines.get(size - i2).toLowerCase(), clearedName)) {
                        this.isInTheCatacombs = true;
                    }
                    String combatZoneName = "the catacombs";
                    if (!ApecUtils.containedByCharSequence(this.scoreBoardLines.get(size - i2).toLowerCase(), combatZoneName) || this.scoreBoardLines.get(size - i2).toLowerCase().contains("to")) continue;
                    this.isInTheCatacombs = true;
                }
                this.ScoreboardParser(this.scoreBoardData, this.scoreBoardLines);
                this.scoreBoardData.ExtraInfo.add(" ");
                this.alreadyShowedScrErr = false;
                this.lastDate = this.scoreBoardData.Date;
                this.lastZone = this.scoreBoardData.Zone;
                this.lastHour = this.scoreBoardData.Hour;
            }
            catch (Exception err) {
                if (this.alreadyShowedScrErr) break block4;
                this.alreadyShowedScrErr = true;
            }
        }
    }

    public List<String> getSidebarLines() {
        ArrayList<String> lines = new ArrayList<String>();
        Scoreboard scoreboard = Minecraft.func_71410_x().field_71441_e.func_96441_U();
        if (scoreboard == null) {
            return lines;
        }
        ScoreObjective objective = scoreboard.func_96539_a(1);
        if (objective == null) {
            return lines;
        }
        Collection scores = scoreboard.func_96534_i(objective);
        ArrayList list = Lists.newArrayList((Iterable)Iterables.filter((Iterable)scores, (Predicate)new Predicate<Score>(){

            public boolean apply(Score s) {
                return s.func_96653_e() != null;
            }
        }));
        scores = list.size() > 15 ? Lists.newArrayList((Iterable)Iterables.skip((Iterable)list, (int)(scores.size() - 15))) : list;
        for (Score score : scores) {
            ScorePlayerTeam team = scoreboard.func_96509_i(score.func_96653_e());
            lines.add(ScorePlayerTeam.func_96667_a((Team)team, (String)score.func_96653_e()));
        }
        return lines;
    }

    public String getScoreBoardTitle() {
        try {
            Scoreboard scoreboard = Minecraft.func_71410_x().field_71441_e.func_96441_U();
            ScoreObjective objective = scoreboard.func_96539_a(1);
            return objective.func_96678_d();
        }
        catch (Exception e) {
            return "";
        }
    }

    private void ScoreboardParser(ScoreBoardData sd, List<String> l) {
        boolean BitsHaveBeenSet = false;
        List rl = Lists.reverse(l);
        for (String line : rl) {
            if (this.RepresentsIRLDate(line)) {
                sd.IRL_Date = ApecUtils.removeFirstSpaces(line);
                if (!line.contains("\u00a78")) continue;
                sd.ExtraInfo.add("Currently in: " + ApecUtils.segmentString(this.scoreBoardLines.get(this.scoreBoardLines.size() - 1), "\u00a78", '\u00a7', '~', 1, 1, ApecUtils.SegmentationOptions.TOTALLY_INCLUSIVE));
                continue;
            }
            if (this.RepresentsDate(line)) {
                sd.Date = ApecUtils.removeFirstSpaces(line);
                continue;
            }
            if (this.RepresentsTime(line)) {
                sd.Hour = ApecUtils.removeFirstSpaces(line);
                continue;
            }
            if (this.RepresentsZone(line)) {
                sd.Zone = ApecUtils.removeFirstSpaces(line);
                continue;
            }
            if (this.RepresentsPurse(line)) {
                sd.Purse = ApecUtils.removeFirstSpaces(line);
                this.usesPiggyBank = false;
                continue;
            }
            if (this.RepresentsPiggy(line)) {
                sd.Purse = ApecUtils.removeFirstSpaces(line);
                this.usesPiggyBank = true;
                continue;
            }
            if (this.RepresentsBits(line)) {
                sd.Bits = ApecUtils.removeFirstSpaces(line);
                BitsHaveBeenSet = true;
                continue;
            }
            if (line.contains("www") || line.replaceAll("[^a-zA-Z0-9]", "").isEmpty()) continue;
            if (this.ShouldHaveSpaceBefore(line)) {
                sd.ExtraInfo.add(" ");
            }
            sd.ExtraInfo.add(ApecUtils.removeFirstSpaces(line));
            if (!this.ShouldHaveSpaceAfter(line)) continue;
            sd.ExtraInfo.add(" ");
        }
        if (!BitsHaveBeenSet && !this.isInTheCatacombs) {
            sd.Bits = "Bits: \u00a7b0";
        }
    }

    public ScoreBoardData getScoreBoardData() {
        return this.scoreBoardData;
    }

    private PlayerStats ProcessPlayerStats() {
        Tuple<Integer, Integer> t;
        PlayerStats playerStats = new PlayerStats();
        try {
            String segmentString = ApecUtils.segmentString(this.actionBarData, String.valueOf('\u2764'), '\u00a7', '\u2764', 1, 1, new ApecUtils.SegmentationOptions[0]);
            if (segmentString != null) {
                t = this.formatStringFractI(ApecUtils.removeAllCodes(segmentString));
                playerStats.Hp = (Integer)t.func_76341_a();
                playerStats.BaseHp = (Integer)t.func_76340_b();
                if (playerStats.Hp > playerStats.BaseHp) {
                    playerStats.Ap = playerStats.Hp - playerStats.BaseHp;
                    playerStats.Hp = playerStats.BaseHp;
                } else {
                    playerStats.Ap = 0;
                    playerStats.BaseAp = 0;
                }
                if (playerStats.Ap > this.baseAp) {
                    this.baseAp = playerStats.Ap;
                }
                playerStats.BaseAp = this.baseAp;
                this.lastAp = playerStats.Ap;
                this.lastBaseAp = playerStats.BaseAp;
                this.lastHp = playerStats.Hp;
                this.lastBaseHp = playerStats.BaseHp;
            } else {
                playerStats.Hp = this.lastHp;
                playerStats.BaseHp = this.lastBaseHp;
                playerStats.Ap = this.lastAp;
                playerStats.BaseAp = this.lastBaseAp;
            }
        }
        catch (Exception err) {
            playerStats.Hp = this.lastHp;
            playerStats.BaseHp = this.lastBaseHp;
            playerStats.Ap = this.lastAp;
            playerStats.BaseAp = this.lastBaseAp;
        }
        try {
            String segmentedString = ApecUtils.segmentString(this.actionBarData, String.valueOf('\u270e'), '\u00a7', '\u270e', 1, 1, new ApecUtils.SegmentationOptions[0]);
            if (segmentedString != null) {
                t = this.formatStringFractI(ApecUtils.removeAllCodes(segmentedString));
                playerStats.Mp = (Integer)t.func_76341_a();
                playerStats.BaseMp = (Integer)t.func_76340_b();
                this.lastMn = playerStats.Mp;
                this.lastBaseMn = playerStats.BaseMp;
            } else {
                playerStats.Mp = this.lastMn;
                playerStats.BaseMp = this.lastBaseMn;
            }
        }
        catch (Exception err) {
            playerStats.Mp = this.lastMn;
            playerStats.BaseMp = this.lastBaseMn;
        }
        try {
            char overflowSymbol = '\u02ac';
            String segmentedString = ApecUtils.segmentString(this.actionBarData, String.valueOf(overflowSymbol), '\u00a7', overflowSymbol, 1, 1, new ApecUtils.SegmentationOptions[0]);
            if (segmentedString != null) {
                int value;
                playerStats.Op = value = Integer.parseInt(ApecUtils.removeAllCodes(segmentedString.replace(",", "")));
                if (this.baseOp < value) {
                    this.baseOp = value;
                }
                playerStats.BaseOp = this.baseOp;
            } else {
                playerStats.Op = 0;
                playerStats.BaseOp = 0;
                this.baseOp = 0;
            }
        }
        catch (Exception overflowSymbol) {
            // empty catch block
        }
        try {
            String segmentedSrtring = null;
            char ticker = '\u0000';
            char[] value = this.healDurationSymbols;
            int n = value.length;
            for (int j = 0; j < n; ++j) {
                char _c;
                ticker = _c = value[j];
                segmentedSrtring = ApecUtils.segmentString(this.actionBarData, String.valueOf(_c), '+', _c, 1, 1, new ApecUtils.SegmentationOptions[0]);
                if (segmentedSrtring != null) break;
            }
            if (segmentedSrtring != null) {
                playerStats.HealDuration = Integer.parseInt(ApecUtils.removeAllCodes(segmentedSrtring).replace("+", ""));
                playerStats.HealDurationTicker = ticker;
            } else {
                playerStats.HealDuration = 0;
            }
        }
        catch (Exception segmentedSrtring) {
            // empty catch block
        }
        try {
            String segmentString = ApecUtils.segmentString(this.actionBarData, ")", '+', ' ', 1, 1, ApecUtils.SegmentationOptions.ALL_INSTANCES_LEFT);
            String inBetweenBrackets = null;
            float percentage = -1.0f;
            if (segmentString != null) {
                inBetweenBrackets = ApecUtils.segmentString(segmentString, "(", '(', ')', 1, 1, ApecUtils.SegmentationOptions.TOTALLY_EXCLUSIVE);
            }
            if (inBetweenBrackets != null) {
                percentage = this.praseSkillPercentage(inBetweenBrackets);
            }
            if (percentage != -1.0f) {
                this.lastSkillXp = segmentString;
                String wholeString = ApecUtils.removeAllCodes(segmentString);
                playerStats.SkillIsShown = true;
                playerStats.SkillInfo = wholeString;
                playerStats.SkillExpPercentage = percentage;
            } else if (!this.lastSkillXp.isEmpty()) {
                String wholeString = ApecUtils.removeAllCodes(this.lastSkillXp);
                percentage = this.praseSkillPercentage(ApecUtils.segmentString(this.lastSkillXp, "(", '(', ')', 1, 1, ApecUtils.SegmentationOptions.TOTALLY_EXCLUSIVE));
                playerStats.SkillIsShown = true;
                playerStats.SkillInfo = wholeString;
                playerStats.SkillExpPercentage = percentage;
            } else {
                playerStats.SkillIsShown = false;
            }
        }
        catch (Exception segmentString) {
            // empty catch block
        }
        try {
            String segmentedString = ApecUtils.segmentString(this.actionBarData, ")", '\u00a7', ' ', 3, 1, new ApecUtils.SegmentationOptions[0]);
            if (segmentedString != null && segmentedString.contains("-") && this.actionBarData.contains(String.valueOf('\u270e'))) {
                playerStats.IsAbilityShown = true;
                playerStats.AbilityText = segmentedString;
            }
        }
        catch (Exception err) {
            playerStats.IsAbilityShown = false;
        }
        try {
            char dfSymbol = '\u2748';
            String segmentedString = ApecUtils.segmentString(this.actionBarData, String.valueOf(dfSymbol), '\u00a7', dfSymbol, 2, 1, new ApecUtils.SegmentationOptions[0]);
            if (segmentedString != null) {
                this.lastDefence = playerStats.Defence = Integer.parseInt(ApecUtils.removeAllCodes(segmentedString.replace(",", "")));
            } else if (!(this.actionBarData.contains("THE END RACE") || this.actionBarData.contains("WOODS RACING") || this.actionBarData.contains("DPS") || this.actionBarData.contains("second") || this.actionBarData.contains("Secrets") || this.actionBarData.contains("CHICKEN RACING") || this.actionBarData.contains("JUMP") || this.actionBarData.contains("CRYSTAL CORE RACE") || this.actionBarData.contains("GIANT MUSHROOM RACE") || this.actionBarData.contains("PRECURSOR RUINS RACE") || playerStats.IsAbilityShown || playerStats.SkillIsShown)) {
                this.lastDefence = playerStats.Defence = 0;
            } else {
                playerStats.Defence = this.lastDefence;
            }
        }
        catch (Exception err) {
            playerStats.Defence = this.lastDefence;
        }
        return playerStats;
    }

    float praseSkillPercentage(String skillInfo) {
        if (skillInfo == null) {
            return -1.0f;
        }
        if (skillInfo.contains("%")) {
            skillInfo = skillInfo.replace("%", "");
            return Float.parseFloat(skillInfo) / 100.0f;
        }
        if (skillInfo.contains("/")) {
            String[] twoValues = skillInfo.split("/");
            float first = ApecUtils.hypixelShortValueFormattingToFloat(twoValues[0]);
            float second = ApecUtils.hypixelShortValueFormattingToFloat(twoValues[1]);
            return first / second;
        }
        return -1.0f;
    }

    public PlayerStats getPlayerStats() {
        return this.playerStats;
    }

    private OtherData ProcessOtherData(ScoreBoardData sd) {
        List<String> effects;
        String segmentedString;
        String treasureMetalDetectorSymbol;
        String segmentEnergy;
        OtherData otherData = new OtherData();
        if (this.actionBarData == null || this.isFromChat(this.actionBarData)) {
            return otherData;
        }
        String endRace = ApecUtils.segmentString(this.actionBarData, "THE END RACE", '\u00a7', ' ', 2, 2, new ApecUtils.SegmentationOptions[0]);
        String woodRacing = ApecUtils.segmentString(this.actionBarData, "WOODS RACING", '\u00a7', ' ', 2, 2, new ApecUtils.SegmentationOptions[0]);
        String dps = ApecUtils.segmentString(this.actionBarData, "DPS", '\u00a7', ' ', 1, 1, new ApecUtils.SegmentationOptions[0]);
        String sec = ApecUtils.segmentString(this.actionBarData, "second", '\u00a7', ' ', 1, 2, new ApecUtils.SegmentationOptions[0]);
        String secrets = ApecUtils.segmentString(this.actionBarData, "Secrets", '\u00a7', '\u00a7', 1, 1, new ApecUtils.SegmentationOptions[0]);
        String chickenRace = ApecUtils.segmentString(this.actionBarData, "CHICKEN RACING", '\u00a7', ' ', 2, 2, new ApecUtils.SegmentationOptions[0]);
        String jump = ApecUtils.segmentString(this.actionBarData, "JUMP", '\u00a7', '\u00a7', 3, 1, new ApecUtils.SegmentationOptions[0]);
        String crystalRace = ApecUtils.segmentString(this.actionBarData, "CRYSTAL CORE RACE", '\u00a7', ' ', 2, 2, new ApecUtils.SegmentationOptions[0]);
        String mushroomRace = ApecUtils.segmentString(this.actionBarData, "GIANT MUSHROOM RACE", '\u00a7', ' ', 2, 2, new ApecUtils.SegmentationOptions[0]);
        String precursorRace = ApecUtils.segmentString(this.actionBarData, "PRECURSOR RUINS RACE", '\u00a7', ' ', 2, 2, new ApecUtils.SegmentationOptions[0]);
        if (!(endRace == null && woodRacing == null && dps == null && sec == null || otherData.ExtraInfo.isEmpty())) {
            otherData.ExtraInfo.add(" ");
        }
        if (endRace != null) {
            otherData.ExtraInfo.add(endRace);
        }
        if (woodRacing != null) {
            otherData.ExtraInfo.add(woodRacing);
        }
        if (dps != null) {
            otherData.ExtraInfo.add(dps);
        }
        if (secrets != null) {
            otherData.ExtraInfo.add(secrets);
        }
        if (this.actionBarData.contains("Revive")) {
            otherData.ExtraInfo.add(this.actionBarData);
        } else if (sec != null) {
            otherData.ExtraInfo.add(sec);
        }
        if (chickenRace != null) {
            otherData.ExtraInfo.add(chickenRace);
        }
        if (jump != null) {
            otherData.ExtraInfo.add(jump);
        }
        if (crystalRace != null) {
            otherData.ExtraInfo.add(crystalRace);
        }
        if (mushroomRace != null) {
            otherData.ExtraInfo.add(mushroomRace);
        }
        if (precursorRace != null) {
            otherData.ExtraInfo.add(precursorRace);
        }
        if (this.actionBarData.contains("Armadillo") && (segmentEnergy = ApecUtils.segmentString(this.actionBarData, "/", '\u00a7', '\u0000', 2, 1, ApecUtils.SegmentationOptions.TOTALLY_INCLUSIVE)) != null) {
            String[] values = ApecUtils.removeAllCodes(segmentEnergy).split("/");
            otherData.ArmadilloEnergy = Float.parseFloat(values[0]);
            otherData.ArmadilloBaseEnergy = Float.parseFloat(values[1]);
        }
        if (this.actionBarData.contains(treasureMetalDetectorSymbol = "TREASURE:") && (segmentedString = ApecUtils.segmentString(this.actionBarData, treasureMetalDetectorSymbol, '\u00a7', 'm', 2, 1, ApecUtils.SegmentationOptions.TOTALLY_INCLUSIVE)) != null) {
            otherData.ExtraInfo.add(segmentedString);
        }
        if (!(effects = this.getPlayerEffects()).isEmpty()) {
            if (!otherData.ExtraInfo.isEmpty()) {
                otherData.ExtraInfo.add(" ");
            }
            otherData.ExtraInfo.addAll(effects);
        }
        otherData.currentEvents = this.getEvents(sd);
        return otherData;
    }

    private ArrayList<EventIDs> getEvents(ScoreBoardData sd) {
        return new ArrayList<EventIDs>();
    }

    private List<String> getPlayerEffects() {
        try {
            ArrayList<String> effects = new ArrayList<String>();
            String[] lines = this.footerTabData.split("\n");
            if (!lines[2].contains("No effects")) {
                for (int i2 = 3; i2 < lines.length; ++i2) {
                    if (!lines[i2].contains(":")) continue;
                    effects.add(lines[i2]);
                    break;
                }
            }
            ApecUtils.orderByWidth(effects);
            return effects;
        }
        catch (Exception err) {
            return new ArrayList<String>();
        }
    }

    private boolean isInvFull() {
        InventoryPlayer ip = HypixelCry.mc.field_71439_g.field_71071_by;
        for (int i2 = 0; i2 < 36; ++i2) {
            if (ip.func_70301_a(i2) != null) continue;
            return false;
        }
        return true;
    }

    public OtherData getOtherData() {
        return this.otherData;
    }

    public Tuple<Integer, Integer> formatStringFractI(String s) {
        String[] tempSplit = s.replace(",", "").split("/");
        return new Tuple((Object)Integer.parseInt(tempSplit[0]), (Object)Integer.parseInt(tempSplit[1]));
    }

    public boolean isFromChat(String s) {
        return s.contains("[") && s.contains("]") || s.startsWith("\u00a77") && s.contains(": ");
    }

    public static class OtherData {
        public ArrayList<String> ExtraInfo = new ArrayList();
        public ArrayList<EventIDs> currentEvents = new ArrayList();
        public float ArmadilloEnergy;
        public float ArmadilloBaseEnergy;
    }

    public static class PlayerStats {
        public int Hp;
        public int BaseHp;
        public int HealDuration;
        public char HealDurationTicker;
        public int Ap;
        public int BaseAp;
        public int Op;
        public int BaseOp;
        public int Mp;
        public int BaseMp;
        public int Defence;
        public String SkillInfo;
        public float SkillExpPercentage;
        public boolean SkillIsShown;
        public boolean IsAbilityShown;
        public String AbilityText = "\u00a7b-00 Mana (\u00a76Some Ability\u00a7b)";
    }

    public static class ScoreBoardData {
        public String Server = "";
        public String Purse = "Purse: \u00a760";
        public String Bits = "Bits: \u00a7b0";
        public List<String> ExtraInfo = new ArrayList<String>();
        public String Zone = "";
        public String Date = "";
        public String Hour = "";
        public String IRL_Date = "";
        public String scoreBoardTitle = "";
    }
}

