/*
 * Decompiled with CFR 0.152.
 */
package com.nekiplay.hypixelcry;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import com.nekiplay.hypixelcry.DataInterpretation.DataExtractor;
import com.nekiplay.hypixelcry.FeatureRegister;
import com.nekiplay.hypixelcry.commands.BlockInfoCommand;
import com.nekiplay.hypixelcry.commands.EntityInfoCommand;
import com.nekiplay.hypixelcry.commands.LocationCommand;
import com.nekiplay.hypixelcry.commands.OpenSettings;
import com.nekiplay.hypixelcry.commands.PathCommand;
import com.nekiplay.hypixelcry.commands.SetAngle;
import com.nekiplay.hypixelcry.commands.TestCommand;
import com.nekiplay.hypixelcry.config.NEUConfig;
import com.nekiplay.hypixelcry.deps.moulconfig.gui.GuiScreenElementWrapper;
import com.nekiplay.hypixelcry.deps.moulconfig.gui.MoulConfigEditor;
import com.nekiplay.hypixelcry.deps.moulconfig.observer.PropertyTypeAdapterFactory;
import com.nekiplay.hypixelcry.deps.moulconfig.processor.BuiltinMoulConfigGuis;
import com.nekiplay.hypixelcry.deps.moulconfig.processor.ConfigProcessorDriver;
import com.nekiplay.hypixelcry.deps.moulconfig.processor.MoulConfigProcessor;
import com.nekiplay.hypixelcry.events.MillisecondEvent;
import com.nekiplay.hypixelcry.utils.ConfigUtil;
import java.io.File;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiIngameMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.command.ICommand;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.Display;

@Mod(modid="AntiCheat", version="1.1.0", clientSideOnly=true)
public class HypixelCry {
    private static HypixelCry instance;
    public static final Logger LOG;
    public static final String PREFIX = "Hypixel Cry";
    public static final Minecraft mc;
    public static GuiScreen screenToOpen;
    public static NEUConfig config;
    private File configFile;
    private File neuDir;
    public static FeatureRegister features;
    public static DataExtractor dataExtractor;
    public static final String MODID = "AntiCheat";
    public static final String VERSION = "1.1.0";
    public static final String prefix;
    private final Gson gson = new GsonBuilder().setPrettyPrinting().excludeFieldsWithoutExposeAnnotation().registerTypeAdapterFactory((TypeAdapterFactory)new PropertyTypeAdapterFactory()).create();
    public MoulConfigProcessor<NEUConfig> processor = null;

    public static final HypixelCry getInstance() {
        return instance;
    }

    public File getConfigFile() {
        return this.configFile;
    }

    public void newConfigFile() {
        this.configFile = new File(this.getNeuDir(), "configNew.json");
    }

    public File getNeuDir() {
        return this.neuDir;
    }

    public static void openGui() {
        MoulConfigEditor<NEUConfig> gui = new MoulConfigEditor<NEUConfig>(HypixelCry.getInstance().processor);
        screenToOpen = new GuiScreenElementWrapper(gui);
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        if (screenToOpen != null) {
            Minecraft.func_71410_x().func_147108_a(screenToOpen);
            screenToOpen = null;
        }
    }

    public void saveConfig() {
        ConfigUtil.saveConfig(config, this.configFile, this.gson);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        instance = this;
        this.neuDir = new File(event.getModConfigurationDirectory(), "hypixelcry");
        this.neuDir.mkdirs();
        this.configFile = new File(this.neuDir, "config.json");
        if (this.configFile.exists()) {
            config = ConfigUtil.loadConfig(NEUConfig.class, this.configFile, this.gson);
        }
        if (config == null) {
            config = new NEUConfig();
            this.saveConfig();
        }
        System.setProperty("java.awt.headless", "false");
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        Display.setTitle((String)"Minecraft 1.8.9 | Hypixel Cry 1.1.0");
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.processor = new MoulConfigProcessor<NEUConfig>(config);
        BuiltinMoulConfigGuis.addProcessors(this.processor);
        ConfigProcessorDriver driver = new ConfigProcessorDriver(this.processor);
        driver.checkExpose = false;
        driver.warnForPrivateFields = false;
        driver.processConfig(config);
        MinecraftForge.EVENT_BUS.register((Object)dataExtractor);
        features.registerSystemFeatures(event);
        features.register(event);
        ClientCommandHandler.instance.func_71560_a((ICommand)new LocationCommand());
        ClientCommandHandler.instance.func_71560_a((ICommand)new BlockInfoCommand());
        ClientCommandHandler.instance.func_71560_a((ICommand)new TestCommand());
        ClientCommandHandler.instance.func_71560_a((ICommand)new PathCommand());
        ClientCommandHandler.instance.func_71560_a((ICommand)new EntityInfoCommand());
        ClientCommandHandler.instance.func_71560_a((ICommand)new SetAngle());
        ClientCommandHandler.instance.func_71560_a((ICommand)new OpenSettings());
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        LocalDateTime now = LocalDateTime.now();
        Duration initialDelay = Duration.between(now, now);
        long initialDelaySeconds = initialDelay.getSeconds();
        Executors.newScheduledThreadPool(1).scheduleAtFixedRate(() -> MinecraftForge.EVENT_BUS.post((Event)new MillisecondEvent()), initialDelaySeconds, 1L, TimeUnit.MILLISECONDS);
    }

    @SubscribeEvent
    public void onGuiInitPost(GuiScreenEvent.InitGuiEvent.Post event) {
        if (event.gui instanceof GuiIngameMenu) {
            int x = event.gui.field_146294_l - 105;
            int x2 = x + 100;
            int y = event.gui.field_146295_m - 22;
            int y2 = y + 20;
            ArrayList sorted = new ArrayList(event.buttonList);
            sorted.sort((a, b) -> b.field_146129_i + b.field_146121_g - (a.field_146129_i + a.field_146121_g));
            for (GuiButton button : sorted) {
                int otherX = button.field_146128_h;
                int otherX2 = button.field_146128_h + button.field_146120_f;
                int otherY = button.field_146129_i;
                int otherY2 = button.field_146129_i + button.field_146121_g;
                if (otherX2 <= x || otherX >= x2 || otherY2 <= y || otherY >= y2) continue;
                y = otherY - 20 - 2;
                y2 = y + 20;
            }
            event.buttonList.add(new GuiButton(6969422, x, Math.max(0, y), 100, 20, PREFIX));
        }
    }

    @SubscribeEvent
    public void onGuiAction(GuiScreenEvent.ActionPerformedEvent.Post event) {
        if (event.gui instanceof GuiIngameMenu && event.button.field_146127_k == 6969422) {
            HypixelCry.openGui();
        }
    }

    static {
        LOG = LogManager.getLogger((String)"HypixelCry");
        mc = Minecraft.func_71410_x();
        screenToOpen = null;
        features = new FeatureRegister();
        dataExtractor = new DataExtractor();
        prefix = EnumChatFormatting.GRAY + "[" + EnumChatFormatting.GOLD + PREFIX + EnumChatFormatting.GRAY + "] " + EnumChatFormatting.RESET;
    }
}

