/*
 * Decompiled with CFR 0.152.
 */
package com.nekiplay.hypixelcry.config.neupages;

import com.google.gson.annotations.Expose;
import com.nekiplay.hypixelcry.config.enums.AutoRightClickBlocks;
import com.nekiplay.hypixelcry.config.enums.AutoRightClickOpenFeatures;
import com.nekiplay.hypixelcry.data.island.IslandType;
import com.nekiplay.hypixelcry.deps.moulconfig.annotations.Accordion;
import com.nekiplay.hypixelcry.deps.moulconfig.annotations.Category;
import com.nekiplay.hypixelcry.deps.moulconfig.annotations.ConfigEditorBoolean;
import com.nekiplay.hypixelcry.deps.moulconfig.annotations.ConfigEditorDraggableList;
import com.nekiplay.hypixelcry.deps.moulconfig.annotations.ConfigEditorKeybind;
import com.nekiplay.hypixelcry.deps.moulconfig.annotations.ConfigEditorSlider;
import com.nekiplay.hypixelcry.deps.moulconfig.annotations.ConfigOption;
import java.util.ArrayList;
import java.util.List;

public class Macros {
    @Accordion
    @ConfigOption(name="Auto RightClick", desc="Auto click to selected blocks")
    @Expose
    public AutoRightClick autoRightClick = new AutoRightClick();
    @Accordion
    @ConfigOption(name="Ghost Blocks", desc="Set looking blocks to air")
    @Expose
    public Ghost_Blocks ghostBlocks = new Ghost_Blocks();
    @Category(name="Dungeons", desc="Macros in dungeons")
    @Expose
    public Dungeons dungeons = new Dungeons();

    public static class Dungeons {
        @Accordion
        @ConfigOption(name="Auto chest close", desc="Auto close dungeon chests")
        @Expose
        public Auto_Close_Chests autoCloseChests = new Auto_Close_Chests();

        public static class Auto_Close_Chests {
            @ConfigOption(name="Auto close chests", desc="Auto close dungeon chests?")
            @ConfigEditorBoolean
            @Expose
            public boolean enable = true;
        }
    }

    public static class Ghost_Blocks {
        @ConfigOption(name="Key binding", desc="Activation key bind")
        @ConfigEditorKeybind(defaultKey=0)
        @Expose
        public int ghostBlocksKeyBind = 0;
        @ConfigOption(name="Range", desc="Raycast range")
        @ConfigEditorSlider(minValue=2.0f, maxValue=32.0f, minStep=1.0f)
        @Expose
        public int range = 8;
    }

    public static class AutoRightClick {
        @ConfigOption(name="Enabled", desc="Enable RightClick?")
        @ConfigEditorBoolean
        @Expose
        public boolean enabled = false;
        @ConfigOption(name="Islands", desc="Allow islands for working")
        @Expose
        @ConfigEditorDraggableList(requireNonEmpty=false)
        public List<IslandType> allowedIslands = new ArrayList<IslandType>(){
            {
                this.add(IslandType.Catacombs);
                this.add(IslandType.Crystal_Hollows);
            }
        };
        @ConfigOption(name="Blocks", desc="Click for blocks")
        @Expose
        @ConfigEditorDraggableList(requireNonEmpty=false)
        public List<AutoRightClickBlocks> blocks = new ArrayList<AutoRightClickBlocks>(){
            {
                this.add(AutoRightClickBlocks.Chest);
                this.add(AutoRightClickBlocks.Lever);
            }
        };
        @ConfigOption(name="Features", desc="Additional features")
        @Expose
        @ConfigEditorDraggableList(requireNonEmpty=false)
        public List<AutoRightClickOpenFeatures> features = new ArrayList<AutoRightClickOpenFeatures>(){
            {
                this.add(AutoRightClickOpenFeatures.Air);
                this.add(AutoRightClickOpenFeatures.GhostHand);
            }
        };
        @ConfigOption(name="Rotation time", desc="")
        @ConfigEditorSlider(minValue=25.0f, maxValue=750.0f, minStep=25.0f)
        @Expose
        public int rotationTime = 100;
    }
}

