/*
 * Decompiled with CFR 0.152.
 */
package com.nekiplay.hypixelcry.data.island;

import com.nekiplay.hypixelcry.data.island.IslandType;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class IslandLocations {
    private static final Map<IslandType, List<String>> islandLocationsMap = new HashMap<IslandType, List<String>>();

    public static List<String> getLocationsForIsland(IslandType islandType, String playerName) {
        List rawLocations = islandLocationsMap.getOrDefault((Object)islandType, Collections.emptyList());
        return rawLocations.stream().map(loc -> loc.replace("{username}", !playerName.isEmpty() ? playerName : "{username}")).collect(Collectors.toList());
    }

    public static boolean isLocationInIsland(String location, IslandType islandType, String playerName) {
        if (location == null) {
            return false;
        }
        List<String> islandLocations = IslandLocations.getLocationsForIsland(islandType, playerName);
        for (String islandLoc : islandLocations) {
            if (!islandLoc.equalsIgnoreCase(location)) continue;
            return true;
        }
        return false;
    }

    public static IslandType getIslandByLocation(String location, String playerName) {
        if (location == null) {
            return IslandType.Unknown;
        }
        for (IslandType islandType : IslandType.values()) {
            if (!IslandLocations.isLocationInIsland(location, islandType, playerName)) continue;
            return islandType;
        }
        return IslandType.Unknown;
    }

    static {
        islandLocationsMap.put(IslandType.None, Collections.singletonList("None"));
        islandLocationsMap.put(IslandType.Hub, Arrays.asList("Village", "Farmhouse", "Fashion Shop", "Flower House", "Mountain", "Builder's House", "Forest", "Graveyard", "Coal Mine", "Catacombs Entrance", "Farm", "Colosseum", "Fishing Outpost", "Wilderness", "Unincorporated", "Museum", "{username}", "{username}'s Museum", "{username}'s Atrium", "{username}'s Weapons Win", "{username}'s Armory", "{username}'s Rarities Wi", "Ruins", "Tavern", "Trade Center", "Bazaar Alley", "Auction House", "Hexatorum", "Library", "Blacksmith", "Archery Range", "Weaponsmith", "Community Center", "Pet Care", "Thaumaturgist", "Wizard Tower", "Bank", "Carnival"));
        islandLocationsMap.put(IslandType.Private_Island, Collections.singletonList("Your Island"));
        islandLocationsMap.put(IslandType.Garden, Collections.singletonList("The Garden"));
        islandLocationsMap.put(IslandType.Dungeon_Hub, Collections.singletonList("Dungeon Hub"));
        islandLocationsMap.put(IslandType.Park, Arrays.asList("Birch Park", "Spruce Woods", "Lonely Island", "Dark Thicket", "Savanna Woodland", "Melody's Plateau", "Jungle Island"));
        islandLocationsMap.put(IslandType.Gold_Mine, Collections.singletonList("Gold Mine"));
        islandLocationsMap.put(IslandType.Deep_Caverns, Arrays.asList("Deep Caverns", "Gunpowder Mines", "Lapis Quarry", "Pigmen's Den", "Slimehill", "Diamond Reserve", "Obsidian Sanctuary"));
        islandLocationsMap.put(IslandType.Farming_Islands, Collections.singletonList("The Barn"));
        islandLocationsMap.put(IslandType.Desert_Settlement, Arrays.asList("Desert Settlement", "Mushroom Desert", "Oasis", "Trapper's Den", "Shepherd's Keep", "Archaeological Site", "Mushroom Gorge", "Overgrown Mushroom Cave", "Glowing Mushroom Cave"));
        islandLocationsMap.put(IslandType.Dwarven_Mines, Arrays.asList("Dwarven Village", "The Lift", "Dwarven Mines", "Lava Springs", "Palace Bridge", "Royal Palace", "Grand Library", "Royal Quarters", "Barracks of Heroes", "Gates to the Mines", "Rampart's Quarry", "Upper Mines", "Far Reserve", "Goblin Burrows", "Great Ice Wall", "Royal Mines", "Cliffside Veins", "Forge Basin", "The Forge", "Divan's Gateway", "Hanging Court", "Aristocrat Passage", "Dwarden Millage"));
        islandLocationsMap.put(IslandType.Crystal_Hollows, Arrays.asList("Crystal Hollows", "Jungle", "Mithril Deposits", "Precursor Remnants", "Goblin Holdout", "Magma Fields"));
        islandLocationsMap.put(IslandType.Glacite_Tunnels, Arrays.asList("Fossil Research Center", "Glacite Tunnels"));
        islandLocationsMap.put(IslandType.Glacite_Mineshaft, Collections.singletonList("Glacite Mineshaft"));
        islandLocationsMap.put(IslandType.Spider_Den, Arrays.asList("Spider's Den", "Grandma's House", "Spider Mound"));
        islandLocationsMap.put(IslandType.End, Collections.singletonList("The End"));
    }
}

