/*
 * Decompiled with CFR 0.152.
 */
package com.nekiplay.hypixelcry.data.island;

import com.nekiplay.hypixelcry.HypixelCry;
import com.nekiplay.hypixelcry.data.island.IslandLocations;
import com.nekiplay.hypixelcry.utils.ApecUtils;

public enum IslandType {
    Lobby("Lobby"),
    Private_Island("Private Island"),
    Garden("Garden"),
    Dungeon_Hub("Dungeon Hub"),
    Catacombs("Catacombs"),
    Hub("Hub"),
    Park("Park"),
    Gold_Mine("Gold Mine"),
    Deep_Caverns("Deep Caverns"),
    Dwarven_Mines("Dwarven Mines"),
    Crystal_Hollows("Crystal Hollows"),
    Glacite_Tunnels("Glacite Tunnels"),
    Glacite_Mineshaft("Glacite Mineshaft"),
    Farming_Islands("Farming Islands"),
    Desert_Settlement("Desert Settlement"),
    Spider_Den("Spider Den"),
    End("End"),
    Unknown("Unknown"),
    None("None");

    final String name;

    private IslandType(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public static IslandType getByZone(String zone) {
        String cleanedZone = zone.replaceAll("[^a-zA-Z\\s']", "").trim();
        return IslandLocations.getIslandByLocation(cleanedZone, HypixelCry.mc.field_71439_g != null ? HypixelCry.mc.field_71439_g.func_70005_c_() : "");
    }

    public static IslandType current() {
        if (!HypixelCry.dataExtractor.isInSkyblock) {
            return Lobby;
        }
        if (HypixelCry.dataExtractor.isInTheCatacombs) {
            return Catacombs;
        }
        String zone = ApecUtils.removeAllCodes(HypixelCry.dataExtractor.getScoreBoardData().Zone);
        return IslandType.getByZone(zone);
    }
}

