/*
 * Decompiled with CFR 0.152.
 */
package com.nekiplay.hypixelcry.deps.moulconfig;

import com.nekiplay.hypixelcry.deps.moulconfig.common.ClickType;
import com.nekiplay.hypixelcry.deps.moulconfig.common.IMinecraft;
import com.nekiplay.hypixelcry.deps.moulconfig.common.MyResourceLocation;
import java.awt.Desktop;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;

public abstract class Social {
    public static Social forLink(String name, MyResourceLocation icon, String link) {
        try {
            return new URLSocial(name, new URI(link), icon);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public abstract void onClick();

    public abstract List<String> getTooltip();

    public abstract MyResourceLocation getIcon();

    private static class URLSocial
    extends Social {
        private final String name;
        private final URI url;
        private final MyResourceLocation icon;

        private URLSocial(String name, URI url, MyResourceLocation icon) {
            this.name = name;
            this.url = url;
            this.icon = icon;
        }

        @Override
        public void onClick() {
            try {
                Desktop.getDesktop().browse(this.url);
            }
            catch (Exception e) {
                IMinecraft.instance.sendClickableChatMessage("Click here to open " + this.name, this.url.toString(), ClickType.OPEN_LINK);
            }
        }

        @Override
        public List<String> getTooltip() {
            return Arrays.asList(this.name);
        }

        @Override
        public MyResourceLocation getIcon() {
            return this.icon;
        }
    }
}

