/*
 * Decompiled with CFR 0.152.
 */
package com.nekiplay.hypixelcry.deps.moulconfig.common;

import com.nekiplay.hypixelcry.deps.moulconfig.common.DynamicTextureReference;
import com.nekiplay.hypixelcry.deps.moulconfig.common.IFontRenderer;
import com.nekiplay.hypixelcry.deps.moulconfig.common.IItemStack;
import com.nekiplay.hypixelcry.deps.moulconfig.common.IMinecraft;
import com.nekiplay.hypixelcry.deps.moulconfig.common.KeyboardConstants;
import com.nekiplay.hypixelcry.deps.moulconfig.common.MyResourceLocation;
import com.nekiplay.hypixelcry.deps.moulconfig.deps.libninepatch.NinePatch;
import com.nekiplay.hypixelcry.deps.moulconfig.internal.NinePatchRenderer;
import java.awt.image.BufferedImage;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface RenderContext {
    public void pushMatrix();

    public void popMatrix();

    public void translate(float var1, float var2, float var3);

    public void scale(float var1, float var2, float var3);

    public void color(float var1, float var2, float var3, float var4);

    public boolean isMouseButtonDown(int var1);

    public boolean isKeyboardKeyDown(int var1);

    default public boolean isShiftDown() {
        return this.isKeyboardKeyDown(KeyboardConstants.INSTANCE.getShiftLeft()) || this.isKeyboardKeyDown(KeyboardConstants.INSTANCE.getShiftRight());
    }

    default public boolean isCtrlDown() {
        return this.isKeyboardKeyDown(KeyboardConstants.INSTANCE.getCtrlLeft()) || this.isKeyboardKeyDown(KeyboardConstants.INSTANCE.getCtrlRight());
    }

    default public void drawStringScaledMaxWidth(@NotNull String text, @NotNull IFontRenderer fontRenderer, int x, int y, boolean shadow, int width, int color) {
        this.pushMatrix();
        this.translate(x, y, 0.0f);
        float scale = Math.min(1.0f, Math.max(0.1f, (float)width / (float)fontRenderer.getStringWidth(text)));
        this.scale(scale, scale, 1.0f);
        this.drawString(fontRenderer, text, 0, 0, color, shadow);
        this.popMatrix();
    }

    default public void drawStringCenteredScaledMaxWidth(@NotNull String text, @NotNull IFontRenderer fr, float x, float y, boolean shadow, int length, int color) {
        this.pushMatrix();
        int strLength = fr.getStringWidth(text);
        float factor = Math.min((float)length / (float)strLength, 1.0f);
        this.translate(x, y, 0.0f);
        this.scale(factor, factor, 1.0f);
        this.drawString(fr, text, -strLength / 2, -fr.getHeight() / 2, color, shadow);
        this.popMatrix();
    }

    public void disableDepth();

    public void enableDepth();

    @NotNull
    public DynamicTextureReference generateDynamicTexture(@NotNull BufferedImage var1);

    default public void drawVerticalLine(int x, int startY, int endY, int color) {
        if (startY > endY) {
            int temp = startY;
            startY = endY;
            endY = temp;
        }
        this.drawColoredRect(x, startY + 1, x + 1, endY, color);
    }

    default public void drawHorizontalLine(int y, int startX, int endX, int color) {
        if (startX > endX) {
            int temp = startX;
            startX = endX;
            endX = temp;
        }
        this.drawColoredRect(startX, y, endX + 1, y + 1, color);
    }

    public void drawTriangles(float ... var1);

    default public void drawOpenCloseTriangle(boolean isOpen, float x, float y, float width, float height) {
        this.color(1.0f, 1.0f, 1.0f, 1.0f);
        if (isOpen) {
            this.drawTriangles(x, y, x + width / 2.0f, y + height, x + width, y);
        } else {
            this.drawTriangles(x, y + height, x + width, y + height / 2.0f, x, y);
        }
    }

    public int drawString(@NotNull IFontRenderer var1, @NotNull String var2, int var3, int var4, int var5, boolean var6);

    public void drawColoredRect(float var1, float var2, float var3, float var4, int var5);

    public void invertedRect(float var1, float var2, float var3, float var4);

    default public void drawTexturedRect(float x, float y, float width, float height) {
        this.drawTexturedRect(x, y, width, height, 0.0f, 0.0f, 1.0f, 1.0f);
    }

    public void drawTexturedRect(float var1, float var2, float var3, float var4, float var5, float var6, float var7, float var8);

    public void setTextureMinMagFilter(@NotNull TextureFilter var1);

    default public void drawNinePatch(@NotNull @NotNull NinePatch<@NotNull MyResourceLocation> patch, float x, float y, int width, int height) {
        this.pushMatrix();
        this.translate(x, y, 0.0f);
        patch.draw(NinePatchRenderer.INSTANCE, this, width, height);
        this.popMatrix();
    }

    default public void drawDarkRect(int x, int y, int width, int height) {
        this.drawDarkRect(x, y, width, height, true);
    }

    public void drawDarkRect(int var1, int var2, int var3, int var4, boolean var5);

    public void drawGradientRect(int var1, int var2, int var3, int var4, int var5, int var6, int var7);

    public void pushScissor(int var1, int var2, int var3, int var4);

    public void popScissor();

    public void clearScissor();

    public void renderItemStack(@NotNull IItemStack var1, int var2, int var3, @Nullable String var4);

    public void scheduleDrawTooltip(@NotNull List<String> var1);

    public void doDrawTooltip();

    public void refreshScissor();

    public void disableScissor();

    @NotNull
    default public IMinecraft getMinecraft() {
        return IMinecraft.instance;
    }

    default public void bindTexture(@NotNull MyResourceLocation texture) {
        this.getMinecraft().bindTexture(texture);
    }

    public static enum TextureFilter {
        LINEAR,
        NEAREST;

    }
}

