/*
 * Decompiled with CFR 0.152.
 */
package com.nekiplay.hypixelcry.deps.moulconfig.gui;

import com.nekiplay.hypixelcry.deps.moulconfig.common.IMinecraft;
import com.nekiplay.hypixelcry.deps.moulconfig.gui.GuiContext;
import com.nekiplay.hypixelcry.deps.moulconfig.gui.GuiImmediateContext;
import com.nekiplay.hypixelcry.deps.moulconfig.gui.KeyboardEvent;
import com.nekiplay.hypixelcry.deps.moulconfig.gui.MouseEvent;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;

public abstract class GuiComponent {
    protected final IMinecraft mc = IMinecraft.instance;
    GuiContext context;

    protected GuiComponent() {
    }

    public void setContext(GuiContext context) {
        this.context = context;
    }

    public abstract int getWidth();

    public abstract int getHeight();

    public void requestFocus() {
        this.context.setFocusedElement(this);
    }

    public void blur() {
        if (this.context.getFocusedElement() == this) {
            this.context.setFocusedElement(null);
        }
    }

    public void setFocus(boolean shouldFocus) {
        if (shouldFocus) {
            this.requestFocus();
        } else {
            this.blur();
        }
    }

    public boolean isFocused() {
        return this.context.getFocusedElement() == this;
    }

    public boolean isInFocus() {
        return this.foldRecursive(false, (element, isFocused) -> isFocused != false || element.isFocused());
    }

    public void onLostFocus() {
    }

    public void onGainedFocus() {
    }

    public final <T> T foldRecursive(T initial, @NotNull @NotNull BiFunction<@NotNull GuiComponent, T, T> visitor) {
        return (T)this.foldChildren(visitor.apply(this, (GuiComponent)initial), (element, state) -> element.foldRecursive(state, visitor));
    }

    public <T> T foldChildren(T initial, @NotNull @NotNull BiFunction<@NotNull GuiComponent, T, T> visitor) {
        return initial;
    }

    public abstract void render(@NotNull GuiImmediateContext var1);

    public boolean mouseEvent(@NotNull MouseEvent mouseEvent, @NotNull GuiImmediateContext context) {
        return false;
    }

    public boolean keyboardEvent(@NotNull KeyboardEvent event, @NotNull GuiImmediateContext context) {
        return false;
    }

    public GuiContext getContext() {
        return this.context;
    }
}

