/*
 * Decompiled with CFR 0.152.
 */
package com.nekiplay.hypixelcry.deps.moulconfig.gui.component;

import com.nekiplay.hypixelcry.deps.moulconfig.common.IFontRenderer;
import com.nekiplay.hypixelcry.deps.moulconfig.common.IMinecraft;
import com.nekiplay.hypixelcry.deps.moulconfig.gui.GuiComponent;
import com.nekiplay.hypixelcry.deps.moulconfig.gui.GuiImmediateContext;
import com.nekiplay.hypixelcry.deps.moulconfig.gui.KeyboardEvent;
import com.nekiplay.hypixelcry.deps.moulconfig.gui.MouseEvent;
import com.nekiplay.hypixelcry.deps.moulconfig.observer.GetSetter;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 !2\u00020\u0001:\u0001!B3\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u0002\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0002\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\r\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\r\u0010\fJ\u0017\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001f\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001f\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u001d\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001a\u001a\u0004\b\u001b\u0010\u001cR\u001d\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u001a\u001a\u0004\b\u001d\u0010\u001cR\u001d\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u001e\u001a\u0004\b\u001f\u0010 \u00a8\u0006\""}, d2={"Lcom/nekiplay/hypixelcry/deps/moulconfig/gui/component/CollapsibleComponent;", "Lcom/nekiplay/hypixelcry/deps/moulconfig/gui/GuiComponent;", "Ljava/util/function/Supplier;", "title", "body", "Lcom/nekiplay/hypixelcry/deps/moulconfig/observer/GetSetter;", "", "collapsedState", "<init>", "(Ljava/util/function/Supplier;Ljava/util/function/Supplier;Lio/github/notenoughupdates/moulconfig/observer/GetSetter;)V", "", "getWidth", "()I", "getHeight", "Lcom/nekiplay/hypixelcry/deps/moulconfig/gui/GuiImmediateContext;", "context", "", "render", "(Lio/github/notenoughupdates/moulconfig/gui/GuiImmediateContext;)V", "Lcom/nekiplay/hypixelcry/deps/moulconfig/gui/MouseEvent;", "mouseEvent", "(Lio/github/notenoughupdates/moulconfig/gui/MouseEvent;Lio/github/notenoughupdates/moulconfig/gui/GuiImmediateContext;)Z", "Lcom/nekiplay/hypixelcry/deps/moulconfig/gui/KeyboardEvent;", "event", "keyboardEvent", "(Lio/github/notenoughupdates/moulconfig/gui/KeyboardEvent;Lio/github/notenoughupdates/moulconfig/gui/GuiImmediateContext;)Z", "Ljava/util/function/Supplier;", "getTitle", "()Ljava/util/function/Supplier;", "getBody", "Lcom/nekiplay/hypixelcry/deps/moulconfig/observer/GetSetter;", "getCollapsedState", "()Lio/github/notenoughupdates/moulconfig/observer/GetSetter;", "Companion", "common"})
public final class CollapsibleComponent
extends GuiComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Supplier<GuiComponent> title;
    @NotNull
    private final Supplier<GuiComponent> body;
    @NotNull
    private final GetSetter<Boolean> collapsedState;
    @NotNull
    private static final IFontRenderer fr = IMinecraft.instance.getDefaultFontRenderer();
    private static final int padding = 2;
    private static final int trim = 3;
    @NotNull
    private static final String rightTriangle = "\u25b6";
    private static final int rightSize = fr.getStringWidth(rightTriangle);
    @NotNull
    private static final String bottomTriangle = "\u25bc";
    private static final int bottomSize = fr.getStringWidth(bottomTriangle);
    private static final int bottomOffset = RangesKt.coerceAtLeast((int)(rightSize - bottomSize), (int)0) / 2;
    private static final int rightOffset = RangesKt.coerceAtLeast((int)(bottomSize - rightSize), (int)0) / 2;
    private static final int iconWidth = Math.max(rightSize, bottomSize);

    public CollapsibleComponent(@NotNull Supplier<GuiComponent> title, @NotNull Supplier<GuiComponent> body, @NotNull GetSetter<Boolean> collapsedState) {
        Intrinsics.checkNotNullParameter(title, (String)"title");
        Intrinsics.checkNotNullParameter(body, (String)"body");
        Intrinsics.checkNotNullParameter(collapsedState, (String)"collapsedState");
        this.title = title;
        this.body = body;
        this.collapsedState = collapsedState;
    }

    public /* synthetic */ CollapsibleComponent(Supplier supplier, Supplier supplier2, GetSetter getSetter, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            getSetter = GetSetter.floating(true);
        }
        this(supplier, supplier2, getSetter);
    }

    @NotNull
    public final Supplier<GuiComponent> getTitle() {
        return this.title;
    }

    @NotNull
    public final Supplier<GuiComponent> getBody() {
        return this.body;
    }

    @NotNull
    public final GetSetter<Boolean> getCollapsedState() {
        return this.collapsedState;
    }

    @Override
    public int getWidth() {
        return Math.max(this.title.get().getWidth() + padding + iconWidth, this.body.get().getWidth());
    }

    @Override
    public int getHeight() {
        return this.collapsedState.get() != false ? Math.max(this.title.get().getHeight(), fr.getHeight()) : Math.max(this.title.get().getHeight(), fr.getHeight()) + trim + this.body.get().getHeight();
    }

    @Override
    public void render(@NotNull GuiImmediateContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Boolean collapsed = this.collapsedState.get();
        context.getRenderContext().drawString(fr, collapsed != false ? rightTriangle : bottomTriangle, collapsed != false ? rightOffset : bottomOffset, 0, -1, false);
        int barHeight = Math.max(this.title.get().getHeight(), fr.getHeight());
        context.getRenderContext().pushMatrix();
        context.getRenderContext().translate(iconWidth, 0.0f, 0.0f);
        this.title.get().render(context.translated(iconWidth, 0, context.getWidth() - iconWidth, barHeight));
        context.getRenderContext().popMatrix();
        if (!collapsed.booleanValue()) {
            context.getRenderContext().drawColoredRect(0.0f, (float)barHeight + 1.0f, context.getWidth(), (float)barHeight + 2.0f, -16777216);
            context.getRenderContext().pushMatrix();
            context.getRenderContext().translate(0.0f, barHeight, 0.0f);
            this.body.get().render(context.translated(0, barHeight, context.getWidth(), context.getHeight() - barHeight));
            context.getRenderContext().popMatrix();
        }
    }

    @Override
    public boolean mouseEvent(@NotNull MouseEvent mouseEvent, @NotNull GuiImmediateContext context) {
        Intrinsics.checkNotNullParameter((Object)mouseEvent, (String)"mouseEvent");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        int barHeight = Math.max(this.title.get().getHeight(), fr.getHeight());
        if (mouseEvent instanceof MouseEvent.Click && context.translated(0, 0, context.getWidth(), barHeight).isHovered()) {
            if (((MouseEvent.Click)mouseEvent).getMouseState()) {
                this.collapsedState.set(this.collapsedState.get() == false);
            }
            return true;
        }
        return this.title.get().mouseEvent(mouseEvent, context.translated(iconWidth, 0, context.getWidth() - iconWidth, barHeight)) || this.body.get().mouseEvent(mouseEvent, context.translated(0, barHeight, context.getWidth(), context.getHeight() - barHeight));
    }

    @Override
    public boolean keyboardEvent(@NotNull KeyboardEvent event, @NotNull GuiImmediateContext context) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        int barHeight = Math.max(this.title.get().getHeight(), fr.getHeight());
        return this.title.get().keyboardEvent(event, context.translated(iconWidth, 0, context.getWidth() - iconWidth, barHeight)) || this.body.get().keyboardEvent(event, context.translated(0, barHeight, context.getWidth(), context.getHeight() - barHeight));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0011\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\n\u001a\u00020\t8\u0006X\u0086D\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\t8\u0006X\u0086D\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000b\u001a\u0004\b\u000f\u0010\rR\u0017\u0010\u0011\u001a\u00020\u00108\u0006\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0015\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\u0015\u0010\u000b\u001a\u0004\b\u0016\u0010\rR\u0017\u0010\u0017\u001a\u00020\u00108\u0006\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0012\u001a\u0004\b\u0018\u0010\u0014R\u0017\u0010\u0019\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\u0019\u0010\u000b\u001a\u0004\b\u001a\u0010\rR\u0017\u0010\u001b\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\u001b\u0010\u000b\u001a\u0004\b\u001c\u0010\rR\u0017\u0010\u001d\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\u001d\u0010\u000b\u001a\u0004\b\u001e\u0010\rR\u0017\u0010\u001f\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\u001f\u0010\u000b\u001a\u0004\b \u0010\r\u00a8\u0006!"}, d2={"Lcom/nekiplay/hypixelcry/deps/moulconfig/gui/component/CollapsibleComponent$Companion;", "", "<init>", "()V", "Lcom/nekiplay/hypixelcry/deps/moulconfig/common/IFontRenderer;", "fr", "Lcom/nekiplay/hypixelcry/deps/moulconfig/common/IFontRenderer;", "getFr", "()Lio/github/notenoughupdates/moulconfig/common/IFontRenderer;", "", "padding", "I", "getPadding", "()I", "trim", "getTrim", "", "rightTriangle", "Ljava/lang/String;", "getRightTriangle", "()Ljava/lang/String;", "rightSize", "getRightSize", "bottomTriangle", "getBottomTriangle", "bottomSize", "getBottomSize", "bottomOffset", "getBottomOffset", "rightOffset", "getRightOffset", "iconWidth", "getIconWidth", "common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IFontRenderer getFr() {
            return fr;
        }

        public final int getPadding() {
            return padding;
        }

        public final int getTrim() {
            return trim;
        }

        @NotNull
        public final String getRightTriangle() {
            return rightTriangle;
        }

        public final int getRightSize() {
            return rightSize;
        }

        @NotNull
        public final String getBottomTriangle() {
            return bottomTriangle;
        }

        public final int getBottomSize() {
            return bottomSize;
        }

        public final int getBottomOffset() {
            return bottomOffset;
        }

        public final int getRightOffset() {
            return rightOffset;
        }

        public final int getIconWidth() {
            return iconWidth;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

