/*
 * Decompiled with CFR 0.152.
 */
package com.nekiplay.hypixelcry.deps.moulconfig.gui.component;

import com.nekiplay.hypixelcry.deps.moulconfig.ChromaColour;
import com.nekiplay.hypixelcry.deps.moulconfig.GuiTextures;
import com.nekiplay.hypixelcry.deps.moulconfig.common.DynamicTextureReference;
import com.nekiplay.hypixelcry.deps.moulconfig.common.IMinecraft;
import com.nekiplay.hypixelcry.deps.moulconfig.common.RenderContext;
import com.nekiplay.hypixelcry.deps.moulconfig.gui.GuiComponent;
import com.nekiplay.hypixelcry.deps.moulconfig.gui.GuiImmediateContext;
import com.nekiplay.hypixelcry.deps.moulconfig.gui.KeyboardEvent;
import com.nekiplay.hypixelcry.deps.moulconfig.gui.MouseEvent;
import com.nekiplay.hypixelcry.deps.moulconfig.gui.component.TextFieldComponent;
import com.nekiplay.hypixelcry.deps.moulconfig.internal.DrawContextExt;
import com.nekiplay.hypixelcry.deps.moulconfig.internal.LerpUtils;
import com.nekiplay.hypixelcry.deps.moulconfig.observer.GetSetter;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class ColorSelectComponent
extends GuiComponent {
    private final TextFieldComponent componentHexField = new TextFieldComponent(new GetSetter<String>(){
        String editingBuffer = "";
        private final Pattern validHex = Pattern.compile("^#([0-9a-fA-F]{1,6})$");

        @Override
        public String get() {
            if (ColorSelectComponent.this.componentHexField.isFocused()) {
                return this.editingBuffer;
            }
            int rgb = ChromaColour.specialToSimpleRGB(ColorSelectComponent.this.colour);
            this.editingBuffer = String.format("#%06x", rgb & 0xFFFFFF).toUpperCase();
            return this.editingBuffer;
        }

        @Override
        public void set(String newValue) {
            this.editingBuffer = newValue;
            Matcher matcher = this.validHex.matcher(newValue);
            if (matcher.matches()) {
                int newRGB = Integer.parseInt(matcher.group(1), 16);
                int alpha = ChromaColour.specialToSimpleRGB(ColorSelectComponent.this.colour) >> 24 & 0xFF;
                ColorSelectComponent.this.colour = ChromaColour.special(ChromaColour.getSpeed(ColorSelectComponent.this.colour), alpha, newRGB);
                ColorSelectComponent.this.colourChangedCallback.accept(ColorSelectComponent.this.colour);
                Color c = new Color(newRGB);
                float[] hsv = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
                ColorSelectComponent.this.updateAngleAndRadius(hsv);
            }
        }
    }, 48, GetSetter.constant(true), "#000000", IMinecraft.instance.getDefaultFontRenderer());
    private int xSize = 119;
    private final int ySize = 89;
    private float wheelAngle = 0.0f;
    private float wheelRadius = 0.0f;
    private final Consumer<String> colourChangedCallback;
    private final Runnable closeCallback;
    private String colour;
    private final boolean opacitySlider;
    private final boolean valueSlider;
    private static DynamicTextureReference hueWheelImage;
    private static DynamicTextureReference brightnessSlider;
    private static DynamicTextureReference opacitySliderRef;
    private ClickedComponent focusedSubComponent = null;

    @Override
    public int getWidth() {
        return this.xSize;
    }

    @Override
    public int getHeight() {
        return 89;
    }

    public ColorSelectComponent(int x, int y, String initialColour, Consumer<String> colourChangedCallback, Runnable closeCallback) {
        this(x, y, initialColour, colourChangedCallback, closeCallback, true, true);
    }

    public ColorSelectComponent(int x, int y, String initialColour, Consumer<String> colourChangedCallback, Runnable closeCallback, boolean opacitySlider, boolean valueSlider) {
        this.colour = initialColour;
        this.colourChangedCallback = colourChangedCallback;
        this.closeCallback = closeCallback;
        int colour = ChromaColour.specialToSimpleRGB(initialColour);
        Color c = new Color(colour);
        float[] hsv = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
        this.updateAngleAndRadius(hsv);
        this.opacitySlider = opacitySlider;
        this.valueSlider = valueSlider;
        if (!valueSlider) {
            this.xSize -= 15;
        }
        if (!opacitySlider) {
            this.xSize -= 15;
        }
    }

    public void updateAngleAndRadius(float[] hsv) {
        this.wheelRadius = hsv[1];
        this.wheelAngle = hsv[0] * 360.0f;
    }

    private static DynamicTextureReference loadOrUpdate(RenderContext renderContext, DynamicTextureReference ref, BufferedImage image) {
        if (ref == null) {
            return renderContext.generateDynamicTexture(image);
        }
        ref.update(image);
        return ref;
    }

    private DynamicTextureReference getOpacitySlider(RenderContext renderContext, int currentColour) {
        BufferedImage bufferedImageOpacity = new BufferedImage(10, 64, 2);
        for (int x = 0; x < 10; ++x) {
            for (int y = 0; y < 64; ++y) {
                if (!(x != 0 && x != 9 || y != 0 && y != 63)) continue;
                int rgb = currentColour & 0xFFFFFF | Math.min(255, (64 - y) * 4) << 24;
                bufferedImageOpacity.setRGB(x, y, rgb);
            }
        }
        opacitySliderRef = ColorSelectComponent.loadOrUpdate(renderContext, opacitySliderRef, bufferedImageOpacity);
        return opacitySliderRef;
    }

    private DynamicTextureReference getBrightnessSlider(RenderContext renderContext) {
        BufferedImage bufferedImageValue = new BufferedImage(10, 64, 2);
        for (int x = 0; x < 10; ++x) {
            for (int y = 0; y < 64; ++y) {
                if (!(x != 0 && x != 9 || y != 0 && y != 63)) continue;
                int rgb = Color.getHSBColor(this.wheelAngle / 360.0f, this.wheelRadius, (float)(64 - y) / 64.0f).getRGB();
                bufferedImageValue.setRGB(x, y, rgb);
            }
        }
        brightnessSlider = ColorSelectComponent.loadOrUpdate(renderContext, brightnessSlider, bufferedImageValue);
        return brightnessSlider;
    }

    private DynamicTextureReference getHueWheelImage(RenderContext renderContext, float brightness) {
        BufferedImage bufferedImage = new BufferedImage(288, 288, 2);
        float borderRadius = 0.05f;
        for (int x = -16; x < 272; ++x) {
            for (int y = -16; y < 272; ++y) {
                float radius = (float)Math.sqrt((float)((x - 128) * (x - 128) + (y - 128) * (y - 128)) / 16384.0f);
                float angle = (float)Math.toDegrees(Math.atan((double)(128 - x) / ((double)(y - 128) + 1.0E-5)) + 1.5707963267948966);
                if (y < 128) {
                    angle += 180.0f;
                }
                if (radius <= 1.0f) {
                    int rgb = Color.getHSBColor(angle / 360.0f, (float)Math.pow(radius, 1.5), brightness).getRGB();
                    bufferedImage.setRGB(x + 16, y + 16, rgb);
                    continue;
                }
                if (!(radius <= 1.0f + borderRadius)) continue;
                float invBlackAlpha = Math.abs(radius - 1.0f - borderRadius / 2.0f) / borderRadius * 2.0f;
                float blackAlpha = 1.0f - invBlackAlpha;
                if (radius > 1.0f + borderRadius / 2.0f) {
                    bufferedImage.setRGB(x + 16, y + 16, (int)(blackAlpha * 255.0f) << 24);
                    continue;
                }
                Color col = Color.getHSBColor(angle / 360.0f, 1.0f, brightness);
                int rgb = (int)((float)col.getRed() * invBlackAlpha) << 16 | (int)((float)col.getGreen() * invBlackAlpha) << 8 | (int)((float)col.getBlue() * invBlackAlpha);
                bufferedImage.setRGB(x + 16, y + 16, 0xFF000000 | rgb);
            }
        }
        hueWheelImage = ColorSelectComponent.loadOrUpdate(renderContext, hueWheelImage, bufferedImage);
        return hueWheelImage;
    }

    @Override
    public void render(@NotNull GuiImmediateContext context) {
        int currentColour = ChromaColour.specialToSimpleRGB(this.colour);
        Color c = new Color(currentColour, true);
        float[] hsv = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
        RenderContext renderContext = context.getRenderContext();
        renderContext.drawDarkRect(0, 0, this.xSize, 89);
        float selradius = (float)Math.pow(this.wheelRadius, 0.6666666865348816) * 32.0f;
        int selx = (int)(Math.cos(Math.toRadians(this.wheelAngle)) * (double)selradius);
        int sely = (int)(Math.sin(Math.toRadians(this.wheelAngle)) * (double)selradius);
        int valueOffset = 0;
        if (this.valueSlider) {
            valueOffset = 15;
            renderContext.bindTexture(this.getBrightnessSlider(renderContext).getIdentifier());
            renderContext.color(1.0f, 1.0f, 1.0f, 1.0f);
            renderContext.drawTexturedRect(74.0f, 5.0f, 10.0f, 64.0f);
        }
        int opacityOffset = 0;
        if (this.opacitySlider) {
            opacityOffset = 15;
            renderContext.bindTexture(GuiTextures.COLOUR_SELECTOR_BAR_ALPHA);
            renderContext.color(1.0f, 1.0f, 1.0f, 1.0f);
            renderContext.drawTexturedRect(74 + valueOffset, 5.0f, 10.0f, 64.0f);
            renderContext.bindTexture(this.getOpacitySlider(renderContext, currentColour).getIdentifier());
            renderContext.color(1.0f, 1.0f, 1.0f, 1.0f);
            renderContext.drawTexturedRect(74 + valueOffset, 5.0f, 10.0f, 64.0f);
        }
        int chromaSpeed = ChromaColour.getSpeed(this.colour);
        int currentColourChroma = ChromaColour.specialToChromaRGB(this.colour);
        Color cChroma = new Color(currentColourChroma, true);
        float[] hsvChroma = Color.RGBtoHSB(cChroma.getRed(), cChroma.getGreen(), cChroma.getBlue(), null);
        if (chromaSpeed > 0) {
            renderContext.drawColoredRect(69 + valueOffset + opacityOffset + 5 + 1, 6.0f, 69 + valueOffset + opacityOffset + 5 + 10 - 1, 68.0f, Color.HSBtoRGB(hsvChroma[0], 0.8f, 0.8f));
        } else {
            renderContext.drawColoredRect(69 + valueOffset + opacityOffset + 5 + 1, 33.0f, 69 + valueOffset + opacityOffset + 5 + 10 - 1, 41.0f, Color.HSBtoRGB((float)(((double)hsvChroma[0] + (double)System.currentTimeMillis() / 1000.0) % 1.0), 0.8f, 0.8f));
        }
        renderContext.bindTexture(GuiTextures.COLOUR_SELECTOR_BAR);
        renderContext.color(1.0f, 1.0f, 1.0f, 1.0f);
        if (this.valueSlider) {
            renderContext.drawTexturedRect(74.0f, 5.0f, 10.0f, 64.0f);
        }
        if (this.opacitySlider) {
            renderContext.drawTexturedRect(74 + valueOffset, 5.0f, 10.0f, 64.0f);
        }
        if (chromaSpeed > 0) {
            renderContext.drawTexturedRect(69 + valueOffset + opacityOffset + 5, 5.0f, 10.0f, 64.0f);
        } else {
            renderContext.bindTexture(GuiTextures.COLOUR_SELECTOR_CHROMA);
            renderContext.drawTexturedRect(69 + valueOffset + opacityOffset + 5, 32.0f, 10.0f, 10.0f);
        }
        if (this.valueSlider) {
            renderContext.drawColoredRect(74.0f, 69 - (int)(64.0f * hsv[2]), 69 + valueOffset, 69 - (int)(64.0f * hsv[2]) + 1, -16777216);
        }
        if (this.opacitySlider) {
            renderContext.drawColoredRect(74 + valueOffset, 69 - c.getAlpha() / 4 - 1, 69 + valueOffset + opacityOffset, 69 - c.getAlpha() / 4, -16777216);
        }
        if (chromaSpeed > 0) {
            renderContext.drawColoredRect(69 + valueOffset + opacityOffset + 5, 69 - (int)((float)chromaSpeed / 255.0f * 64.0f), 69 + valueOffset + opacityOffset + 5 + 10, 69 - (int)((float)chromaSpeed / 255.0f * 64.0f) + 1, -16777216);
        }
        renderContext.bindTexture(this.getHueWheelImage(renderContext, hsv[2]).getIdentifier());
        renderContext.color(1.0f, 1.0f, 1.0f, 1.0f);
        renderContext.setTextureMinMagFilter(RenderContext.TextureFilter.LINEAR);
        renderContext.drawTexturedRect(1.0f, 1.0f, 72.0f, 72.0f);
        renderContext.bindTexture(GuiTextures.COLOUR_SELECTOR_DOT);
        renderContext.color(1.0f, 1.0f, 1.0f, 1.0f);
        renderContext.setTextureMinMagFilter(RenderContext.TextureFilter.LINEAR);
        renderContext.drawTexturedRect(37 + selx - 4, 37 + sely - 4, 8.0f, 8.0f);
        DrawContextExt.drawStringCenteredScalingDownWithMaxWidth(renderContext, "\u00a77" + Math.round(hsv[2] * 100.0f), 79 - (Math.round(hsv[2] * 100.0f) == 100 ? 1 : 0), 79, 13, -1, true);
        if (this.opacitySlider) {
            DrawContextExt.drawStringCenteredScalingDownWithMaxWidth(renderContext, "\u00a77" + Math.round((float)c.getAlpha() / 255.0f * 100.0f) + "", 74 + valueOffset + 5, 79, 13, -1, true);
        }
        if (chromaSpeed > 0) {
            DrawContextExt.drawStringCenteredScalingDownWithMaxWidth(renderContext, "\u00a77" + (int)ChromaColour.getSecondsForSpeed(chromaSpeed) + "s", 74 + valueOffset + opacityOffset + 6, 79, 13, -1, true);
        }
        renderContext.pushMatrix();
        renderContext.translate(13.0f, 74.0f, 0.0f);
        this.componentHexField.render(context.translated(13, 74, 48, 12));
        renderContext.popMatrix();
    }

    private void updateOnMouseMovement(GuiImmediateContext context) {
        if (this.focusedSubComponent == null) {
            return;
        }
        int currentColour = ChromaColour.specialToSimpleRGB(this.colour);
        Color c = new Color(currentColour, true);
        float[] hsv = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
        float percentage = LerpUtils.clampZeroOne((context.getMouseYHF() - 5.0f) / 64.0f);
        switch (this.focusedSubComponent) {
            case BRIGHTNESS: {
                int rgb = Color.getHSBColor(this.wheelAngle / 360.0f, this.wheelRadius, 1.0f - percentage).getRGB();
                this.colour = ChromaColour.special(ChromaColour.getSpeed(this.colour), c.getAlpha(), rgb);
                break;
            }
            case HUE: {
                float diffX = context.getMouseXHF() - 1.0f - 36.0f;
                float diffY = context.getMouseYHF() - 1.0f - 36.0f;
                float angle = (float)Math.toDegrees(Math.atan2(diffY, diffX));
                float radius = (float)Math.sqrt(diffX * diffX + diffY * diffY) / 32.0f;
                this.wheelAngle = angle;
                this.wheelRadius = (float)Math.pow(Math.min(1.0f, radius), 1.5);
                int rgb = Color.getHSBColor(angle / 360.0f, this.wheelRadius, hsv[2]).getRGB();
                this.colour = ChromaColour.special(ChromaColour.getSpeed(this.colour), c.getAlpha(), rgb);
                break;
            }
            case CHROMA: {
                this.colour = ChromaColour.special(255 - Math.round(percentage * 255.0f), c.getAlpha(), currentColour);
                break;
            }
            case OPACITY: {
                this.colour = ChromaColour.special(ChromaColour.getSpeed(this.colour), 255 - Math.round(percentage * 255.0f), currentColour);
            }
        }
        this.colourChangedCallback.accept(this.colour);
    }

    @Override
    public boolean mouseEvent(@NotNull MouseEvent mouseEvent, @NotNull GuiImmediateContext context) {
        if (mouseEvent instanceof MouseEvent.Click) {
            MouseEvent.Click click = (MouseEvent.Click)mouseEvent;
            if (!context.isHovered() && click.getMouseState()) {
                this.closeCallback.run();
                return true;
            }
            if (context.isHovered() && click.getMouseState()) {
                this.requestFocus();
            }
            if (this.focusedSubComponent != null && !click.getMouseState() && click.getMouseButton() == 0) {
                this.focusedSubComponent = null;
                return true;
            }
            int currentColour = ChromaColour.specialToSimpleRGB(this.colour);
            Color c = new Color(currentColour, true);
            if (click.getMouseState()) {
                int centerX = 37;
                int centerY = 37;
                int diffX = context.getMouseX() - centerX;
                int diffY = context.getMouseY() - centerY;
                float radSq = diffY * diffY + diffX * diffX;
                if (radSq < 1296.0f) {
                    this.focusedSubComponent = ClickedComponent.HUE;
                    this.updateOnMouseMovement(context);
                    return true;
                }
                if (this.valueSlider && context.translated(74, 5, 10, 64).isHovered()) {
                    this.focusedSubComponent = ClickedComponent.BRIGHTNESS;
                    this.updateOnMouseMovement(context);
                    return true;
                }
                if (this.opacitySlider && context.translated(74 + (this.valueSlider ? 15 : 0), 5, 10, 64).isHovered()) {
                    this.focusedSubComponent = ClickedComponent.OPACITY;
                    this.updateOnMouseMovement(context);
                    return true;
                }
                int chromaSpeed = ChromaColour.getSpeed(this.colour);
                int chromaX = 74 + (this.valueSlider ? 15 : 0) + (this.opacitySlider ? 15 : 0);
                if (chromaSpeed < 0) {
                    if (context.translated(chromaX, 32, 10, 10).isHovered()) {
                        this.colour = ChromaColour.special(200, c.getAlpha(), currentColour);
                        this.colourChangedCallback.accept(this.colour);
                    }
                } else if (context.translated(chromaX, 5, 10, 64).isHovered()) {
                    this.focusedSubComponent = ClickedComponent.CHROMA;
                    this.updateOnMouseMovement(context);
                }
            }
        }
        if (mouseEvent instanceof MouseEvent.Move && this.focusedSubComponent != null) {
            this.updateOnMouseMovement(context);
            return true;
        }
        if (mouseEvent instanceof MouseEvent.Scroll) {
            this.closeCallback.run();
            return true;
        }
        return this.componentHexField.mouseEvent(mouseEvent, context.translated(13, 74, 48, 12)) || context.isHovered();
    }

    @Override
    public boolean keyboardEvent(@NotNull KeyboardEvent event, @NotNull GuiImmediateContext context) {
        if (event instanceof KeyboardEvent.KeyPressed) {
            if (((KeyboardEvent.KeyPressed)event).getKeycode() == 1) {
                this.closeCallback.run();
                return true;
            }
            int key = ((KeyboardEvent.KeyPressed)event).getKeycode();
            if (key == 201 || key == 200) {
                this.closeCallback.run();
                return false;
            }
        }
        return this.componentHexField.keyboardEvent(event, context.translated(13, 74, 48, 10));
    }

    @Override
    public <T> T foldChildren(T initial, @NotNull @NotNull BiFunction<@NotNull GuiComponent, T, T> visitor) {
        return visitor.apply(this.componentHexField, (GuiComponent)initial);
    }

    static enum ClickedComponent {
        HUE,
        BRIGHTNESS,
        OPACITY,
        CHROMA;

    }
}

