/*
 * Decompiled with CFR 0.152.
 */
package com.nekiplay.hypixelcry.deps.moulconfig.gui.component;

import com.nekiplay.hypixelcry.deps.moulconfig.common.NinePatches;
import com.nekiplay.hypixelcry.deps.moulconfig.common.RenderContext;
import com.nekiplay.hypixelcry.deps.moulconfig.gui.GuiComponent;
import com.nekiplay.hypixelcry.deps.moulconfig.gui.GuiImmediateContext;
import com.nekiplay.hypixelcry.deps.moulconfig.gui.KeyboardEvent;
import com.nekiplay.hypixelcry.deps.moulconfig.gui.MouseEvent;
import java.util.function.BiFunction;

public class PanelComponent
extends GuiComponent {
    private final GuiComponent element;
    private final int insets;
    private final BackgroundRenderer backgroundRenderer;

    public PanelComponent(GuiComponent element, int insets, BackgroundRenderer backgroundRenderer) {
        this.element = element;
        this.insets = insets;
        this.backgroundRenderer = backgroundRenderer;
    }

    public PanelComponent(GuiComponent element) {
        this(element, 2, DefaultBackgroundRenderer.DARK_RECT);
    }

    @Override
    public <T> T foldChildren(T initial, BiFunction<GuiComponent, T, T> visitor) {
        return visitor.apply(this.element, (GuiComponent)initial);
    }

    @Override
    public int getWidth() {
        return this.element.getWidth() + this.insets * 2;
    }

    @Override
    public int getHeight() {
        return this.element.getHeight() + this.insets * 2 + 2;
    }

    protected GuiImmediateContext getChildContext(GuiImmediateContext context) {
        return context.translated(this.insets, this.insets, context.getWidth() - this.insets * 2, context.getHeight() - this.insets * 2 - 2);
    }

    @Override
    public void render(GuiImmediateContext context) {
        context.getRenderContext().pushMatrix();
        this.backgroundRenderer.render(context.getRenderContext(), 0, 0, context.getWidth(), context.getHeight() - 2);
        context.getRenderContext().translate(this.insets, this.insets, 0.0f);
        this.element.render(this.getChildContext(context));
        context.getRenderContext().popMatrix();
    }

    @Override
    public boolean keyboardEvent(KeyboardEvent event, GuiImmediateContext context) {
        return this.element.keyboardEvent(event, this.getChildContext(context));
    }

    @Override
    public boolean mouseEvent(MouseEvent mouseEvent, GuiImmediateContext context) {
        return this.element.mouseEvent(mouseEvent, this.getChildContext(context));
    }

    public GuiComponent getElement() {
        return this.element;
    }

    public int getInsets() {
        return this.insets;
    }

    public BackgroundRenderer getBackgroundRenderer() {
        return this.backgroundRenderer;
    }

    public static enum DefaultBackgroundRenderer implements BackgroundRenderer
    {
        DARK_RECT{

            @Override
            public void render(RenderContext renderContext, int x, int y, int width, int height) {
                renderContext.drawDarkRect(x, y, width, height);
            }
        }
        ,
        BUTTON{

            @Override
            public void render(RenderContext renderContext, int x, int y, int width, int height) {
                renderContext.drawNinePatch(NinePatches.INSTANCE.createButton(), x, y, width, height);
            }
        }
        ,
        VANILLA{

            @Override
            public void render(RenderContext renderContext, int x, int y, int width, int height) {
                renderContext.drawNinePatch(NinePatches.INSTANCE.createVanillaPanel(), x, y, width, height);
            }
        }
        ,
        TRANSPARENT{

            @Override
            public void render(RenderContext renderContext, int x, int y, int width, int height) {
            }
        };

    }

    public static interface BackgroundRenderer {
        public void render(RenderContext var1, int var2, int var3, int var4, int var5);
    }
}

