/*
 * Decompiled with CFR 0.152.
 */
package com.nekiplay.hypixelcry.deps.moulconfig.gui.component;

import com.nekiplay.hypixelcry.deps.moulconfig.gui.GuiComponent;
import com.nekiplay.hypixelcry.deps.moulconfig.gui.GuiImmediateContext;
import com.nekiplay.hypixelcry.deps.moulconfig.gui.KeyboardEvent;
import com.nekiplay.hypixelcry.deps.moulconfig.gui.MouseEvent;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\u000b\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\nJ=\u0010\u0011\u001a\u00028\u0000\"\n\b\u0000\u0010\r*\u0004\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00028\u00002\u0018\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00000\u000fH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u001f\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u001f\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fR\u0017\u0010\u0002\u001a\u00020\u00018\u0006\u00a2\u0006\f\n\u0004\b\u0002\u0010 \u001a\u0004\b!\u0010\"R\u001d\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010#\u001a\u0004\b$\u0010%\u00a8\u0006&"}, d2={"Lcom/nekiplay/hypixelcry/deps/moulconfig/gui/component/ScaleComponent;", "Lcom/nekiplay/hypixelcry/deps/moulconfig/gui/GuiComponent;", "child", "Ljava/util/function/Supplier;", "", "scaleFactor", "<init>", "(Lio/github/notenoughupdates/moulconfig/gui/GuiComponent;Ljava/util/function/Supplier;)V", "", "getWidth", "()I", "getHeight", "", "T", "initial", "Ljava/util/function/BiFunction;", "visitor", "foldChildren", "(Ljava/lang/Object;Ljava/util/function/BiFunction;)Ljava/lang/Object;", "Lcom/nekiplay/hypixelcry/deps/moulconfig/gui/GuiImmediateContext;", "context", "", "render", "(Lio/github/notenoughupdates/moulconfig/gui/GuiImmediateContext;)V", "Lcom/nekiplay/hypixelcry/deps/moulconfig/gui/KeyboardEvent;", "event", "", "keyboardEvent", "(Lio/github/notenoughupdates/moulconfig/gui/KeyboardEvent;Lio/github/notenoughupdates/moulconfig/gui/GuiImmediateContext;)Z", "Lcom/nekiplay/hypixelcry/deps/moulconfig/gui/MouseEvent;", "mouseEvent", "(Lio/github/notenoughupdates/moulconfig/gui/MouseEvent;Lio/github/notenoughupdates/moulconfig/gui/GuiImmediateContext;)Z", "Lcom/nekiplay/hypixelcry/deps/moulconfig/gui/GuiComponent;", "getChild", "()Lio/github/notenoughupdates/moulconfig/gui/GuiComponent;", "Ljava/util/function/Supplier;", "getScaleFactor", "()Ljava/util/function/Supplier;", "common"})
public final class ScaleComponent
extends GuiComponent {
    @NotNull
    private final GuiComponent child;
    @NotNull
    private final Supplier<Float> scaleFactor;

    public ScaleComponent(@NotNull GuiComponent child, @NotNull Supplier<Float> scaleFactor) {
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        Intrinsics.checkNotNullParameter(scaleFactor, (String)"scaleFactor");
        this.child = child;
        this.scaleFactor = scaleFactor;
    }

    @NotNull
    public final GuiComponent getChild() {
        return this.child;
    }

    @NotNull
    public final Supplier<Float> getScaleFactor() {
        return this.scaleFactor;
    }

    @Override
    public int getWidth() {
        return (int)(((Number)this.scaleFactor.get()).floatValue() * (float)this.child.getWidth());
    }

    @Override
    public int getHeight() {
        return (int)(((Number)this.scaleFactor.get()).floatValue() * (float)this.child.getHeight());
    }

    @Override
    public <T> T foldChildren(T initial, @NotNull BiFunction<GuiComponent, T, T> visitor) {
        Intrinsics.checkNotNullParameter(visitor, (String)"visitor");
        return visitor.apply(this.child, (GuiComponent)initial);
    }

    @Override
    public void render(@NotNull GuiImmediateContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        context.getRenderContext().pushMatrix();
        Float f = this.scaleFactor.get();
        Intrinsics.checkNotNullExpressionValue((Object)f, (String)"get(...)");
        float s = ((Number)f).floatValue();
        context.getRenderContext().scale(s, s, 1.0f);
        this.child.render(context.scaled(s));
        context.getRenderContext().popMatrix();
    }

    @Override
    public boolean keyboardEvent(@NotNull KeyboardEvent event, @NotNull GuiImmediateContext context) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Float f = this.scaleFactor.get();
        Intrinsics.checkNotNullExpressionValue((Object)f, (String)"get(...)");
        return this.child.keyboardEvent(event, context.scaled(((Number)f).floatValue()));
    }

    @Override
    public boolean mouseEvent(@NotNull MouseEvent mouseEvent, @NotNull GuiImmediateContext context) {
        Intrinsics.checkNotNullParameter((Object)mouseEvent, (String)"mouseEvent");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Float f = this.scaleFactor.get();
        Intrinsics.checkNotNullExpressionValue((Object)f, (String)"get(...)");
        return this.child.mouseEvent(mouseEvent, context.scaled(((Number)f).floatValue()));
    }
}

