/*
 * Decompiled with CFR 0.152.
 */
package com.nekiplay.hypixelcry.deps.moulconfig.gui.component;

import com.nekiplay.hypixelcry.deps.moulconfig.GuiTextures;
import com.nekiplay.hypixelcry.deps.moulconfig.common.MyResourceLocation;
import com.nekiplay.hypixelcry.deps.moulconfig.gui.GuiComponent;
import com.nekiplay.hypixelcry.deps.moulconfig.gui.GuiImmediateContext;
import com.nekiplay.hypixelcry.deps.moulconfig.gui.MouseEvent;
import com.nekiplay.hypixelcry.deps.moulconfig.observer.GetSetter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0011\b\u0016\u0018\u00002\u00020\u0001B5\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\f\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000e\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\rJ\u0017\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0015\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0014\u0010\u0013J\u001f\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0018R\u001d\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0019\u001a\u0004\b\u001a\u0010\u001bR\u0017\u0010\u0005\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001c\u001a\u0004\b\u001d\u0010\u001eR\u0017\u0010\u0006\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u001c\u001a\u0004\b\u001f\u0010\u001eR\u0017\u0010\u0007\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u001c\u001a\u0004\b \u0010\u001eR\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010!R\"\u0010\"\u001a\u00020\u00178\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\"\u0010#\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'\u00a8\u0006("}, d2={"Lcom/nekiplay/hypixelcry/deps/moulconfig/gui/component/SliderComponent;", "Lcom/nekiplay/hypixelcry/deps/moulconfig/gui/GuiComponent;", "Lcom/nekiplay/hypixelcry/deps/moulconfig/observer/GetSetter;", "", "value", "minValue", "maxValue", "minStep", "", "width", "<init>", "(Lio/github/notenoughupdates/moulconfig/observer/GetSetter;FFFI)V", "getWidth", "()I", "getHeight", "Lcom/nekiplay/hypixelcry/deps/moulconfig/gui/GuiImmediateContext;", "context", "", "render", "(Lio/github/notenoughupdates/moulconfig/gui/GuiImmediateContext;)V", "setValueFromContext", "Lcom/nekiplay/hypixelcry/deps/moulconfig/gui/MouseEvent;", "mouseEvent", "", "(Lio/github/notenoughupdates/moulconfig/gui/MouseEvent;Lio/github/notenoughupdates/moulconfig/gui/GuiImmediateContext;)Z", "Lcom/nekiplay/hypixelcry/deps/moulconfig/observer/GetSetter;", "getValue", "()Lio/github/notenoughupdates/moulconfig/observer/GetSetter;", "F", "getMinValue", "()F", "getMaxValue", "getMinStep", "I", "clicked", "Z", "getClicked", "()Z", "setClicked", "(Z)V", "common"})
public class SliderComponent
extends GuiComponent {
    @NotNull
    private final GetSetter<Float> value;
    private final float minValue;
    private final float maxValue;
    private final float minStep;
    private final int width;
    private boolean clicked;

    public SliderComponent(@NotNull GetSetter<Float> value, float minValue, float maxValue, float minStep, int width) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.value = value;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.minStep = minStep;
        this.width = width;
    }

    @NotNull
    public final GetSetter<Float> getValue() {
        return this.value;
    }

    public final float getMinValue() {
        return this.minValue;
    }

    public final float getMaxValue() {
        return this.maxValue;
    }

    public final float getMinStep() {
        return this.minStep;
    }

    public final boolean getClicked() {
        return this.clicked;
    }

    public final void setClicked(boolean bl) {
        this.clicked = bl;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return 16;
    }

    @Override
    public void render(@NotNull GuiImmediateContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (this.clicked) {
            this.setValueFromContext(context);
        }
        Float f = this.value.get();
        Intrinsics.checkNotNullExpressionValue((Object)f, (String)"get(...)");
        float value = ((Number)f).floatValue();
        context.getRenderContext().color(1.0f, 1.0f, 1.0f, 1.0f);
        MyResourceLocation myResourceLocation = GuiTextures.SLIDER_ON_CAP;
        Intrinsics.checkNotNullExpressionValue((Object)myResourceLocation, (String)"SLIDER_ON_CAP");
        this.mc.bindTexture(myResourceLocation);
        context.getRenderContext().drawTexturedRect(0.0f, 0.0f, 4.0f, context.getHeight());
        MyResourceLocation myResourceLocation2 = GuiTextures.SLIDER_OFF_CAP;
        Intrinsics.checkNotNullExpressionValue((Object)myResourceLocation2, (String)"SLIDER_OFF_CAP");
        this.mc.bindTexture(myResourceLocation2);
        context.getRenderContext().drawTexturedRect(this.width - 4, 0.0f, 4.0f, context.getHeight());
        int sliderPosition = (int)((value - this.minValue) / (this.maxValue - this.minValue) * (float)context.getWidth());
        if (sliderPosition > 5) {
            MyResourceLocation myResourceLocation3 = GuiTextures.SLIDER_ON_SEGMENT;
            Intrinsics.checkNotNullExpressionValue((Object)myResourceLocation3, (String)"SLIDER_ON_SEGMENT");
            this.mc.bindTexture(myResourceLocation3);
            context.getRenderContext().drawTexturedRect(4.0f, 0.0f, sliderPosition - 4, context.getHeight());
        }
        if (sliderPosition < context.getWidth() - 5) {
            MyResourceLocation myResourceLocation4 = GuiTextures.SLIDER_OFF_SEGMENT;
            Intrinsics.checkNotNullExpressionValue((Object)myResourceLocation4, (String)"SLIDER_OFF_SEGMENT");
            this.mc.bindTexture(myResourceLocation4);
            context.getRenderContext().drawTexturedRect(sliderPosition, 0.0f, context.getWidth() - 4 - sliderPosition, context.getHeight());
        }
        for (int i2 = 0; i2 < 4; ++i2) {
            int notchX = context.getWidth() * i2 / 4 - 1;
            MyResourceLocation myResourceLocation5 = notchX > sliderPosition ? GuiTextures.SLIDER_OFF_NOTCH : GuiTextures.SLIDER_ON_NOTCH;
            Intrinsics.checkNotNull((Object)myResourceLocation5);
            this.mc.bindTexture(myResourceLocation5);
            context.getRenderContext().drawTexturedRect(notchX, (float)(context.getHeight() - 4) / 2.0f, 2.0f, 4.0f);
        }
        MyResourceLocation myResourceLocation6 = GuiTextures.SLIDER_BUTTON;
        Intrinsics.checkNotNullExpressionValue((Object)myResourceLocation6, (String)"SLIDER_BUTTON");
        this.mc.bindTexture(myResourceLocation6);
        context.getRenderContext().drawTexturedRect(sliderPosition - 4, 0.0f, 8.0f, context.getHeight());
    }

    public final void setValueFromContext(@NotNull GuiImmediateContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        float v = (float)context.getMouseX() * (this.maxValue - this.minValue) / (float)context.getWidth() + this.minValue;
        v = (float)Math.min((double)v, (double)this.maxValue);
        v = (float)Math.max((double)v, (double)this.minValue);
        v = (float)Math.round(v / this.minStep) * this.minStep;
        this.value.set(Float.valueOf(v));
    }

    @Override
    public boolean mouseEvent(@NotNull MouseEvent mouseEvent, @NotNull GuiImmediateContext context) {
        Intrinsics.checkNotNullParameter((Object)mouseEvent, (String)"mouseEvent");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!context.getRenderContext().isMouseButtonDown(0)) {
            this.clicked = false;
        }
        if (context.isHovered() && mouseEvent instanceof MouseEvent.Click && ((MouseEvent.Click)mouseEvent).getMouseState() && ((MouseEvent.Click)mouseEvent).getMouseButton() == 0) {
            this.clicked = true;
        }
        if (this.clicked) {
            this.setValueFromContext(context);
            return true;
        }
        return false;
    }
}

