/*
 * Decompiled with CFR 0.152.
 */
package com.nekiplay.hypixelcry.deps.moulconfig.gui.component;

import com.nekiplay.hypixelcry.deps.moulconfig.GuiTextures;
import com.nekiplay.hypixelcry.deps.moulconfig.common.MyResourceLocation;
import com.nekiplay.hypixelcry.deps.moulconfig.gui.GuiComponent;
import com.nekiplay.hypixelcry.deps.moulconfig.gui.GuiImmediateContext;
import com.nekiplay.hypixelcry.deps.moulconfig.gui.MouseEvent;
import com.nekiplay.hypixelcry.deps.moulconfig.internal.LerpUtils;
import com.nekiplay.hypixelcry.deps.moulconfig.internal.LerpingInteger;
import com.nekiplay.hypixelcry.deps.moulconfig.observer.GetSetter;

public class SwitchComponent
extends GuiComponent {
    final GetSetter<Boolean> value;
    final LerpingInteger animation;
    private boolean lastValue;

    public SwitchComponent(GetSetter<Boolean> value, int timeToReachTarget) {
        this.value = value;
        this.lastValue = value.get();
        this.animation = new LerpingInteger(value.get() != false ? 100 : 0, timeToReachTarget);
    }

    @Override
    public int getWidth() {
        return 48;
    }

    @Override
    public int getHeight() {
        return 14;
    }

    @Override
    public void render(GuiImmediateContext context) {
        context.getRenderContext().color(1.0f, 1.0f, 1.0f, 1.0f);
        this.mc.bindTexture(GuiTextures.TOGGLE_BAR);
        context.getRenderContext().drawTexturedRect(0.0f, 0.0f, context.getWidth(), context.getHeight());
        boolean val = this.value.get();
        if (this.lastValue != val) {
            this.animation.setTarget(val ? 100 : 0);
            this.animation.resetTimer();
            this.lastValue = val;
        } else {
            this.animation.tick();
        }
        float animationPercentage = LerpUtils.sigmoidZeroOne((float)this.animation.getValue() / 100.0f);
        MyResourceLocation buttonLocation = animationPercentage < 0.2f ? GuiTextures.TOGGLE_OFF : (animationPercentage < 0.4f ? GuiTextures.TOGGLE_ON : (animationPercentage < 0.6f ? GuiTextures.TOGGLE_TWO : (animationPercentage < 0.8f ? GuiTextures.TOGGLE_THREE : GuiTextures.TOGGLE_ON)));
        this.mc.bindTexture(buttonLocation);
        context.getRenderContext().drawTexturedRect(animationPercentage * (float)(context.getWidth() - 12), 0.0f, 12.0f, context.getHeight());
    }

    @Override
    public boolean mouseEvent(MouseEvent event, GuiImmediateContext context) {
        super.mouseEvent(event, context);
        if (!(event instanceof MouseEvent.Click)) {
            return false;
        }
        MouseEvent.Click click = (MouseEvent.Click)event;
        if (context.isHovered() && click.getMouseButton() == 0 && click.getMouseState()) {
            this.value.set(this.value.get() == false);
            return true;
        }
        return false;
    }

    public String toString() {
        return "SwitchComponent(value=" + this.value + ", animation=" + this.animation + ", lastValue=" + this.lastValue + ")";
    }
}

