/*
 * Decompiled with CFR 0.152.
 */
package com.nekiplay.hypixelcry.deps.moulconfig.gui.component;

import com.nekiplay.hypixelcry.deps.moulconfig.common.IFontRenderer;
import com.nekiplay.hypixelcry.deps.moulconfig.common.IMinecraft;
import com.nekiplay.hypixelcry.deps.moulconfig.gui.GuiComponent;
import com.nekiplay.hypixelcry.deps.moulconfig.gui.GuiImmediateContext;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.regex.Pattern;

public class TextComponent
extends GuiComponent {
    final IFontRenderer fontRenderer;
    final Supplier<String> string;
    final int suggestedWidth;
    final TextAlignment alignment;
    final boolean shadow;
    final boolean split;
    private String lastString;
    private int lastWidth = -1;
    private List<String> lastSplit;
    private static final Pattern colorPattern = Pattern.compile("\u00a7[a-f0-9r]");

    public TextComponent(String string, int width, TextAlignment alignment) {
        this(IMinecraft.instance.getDefaultFontRenderer(), () -> string, width, alignment, false, false);
    }

    public TextComponent(String string, int width) {
        this(IMinecraft.instance.getDefaultFontRenderer(), () -> string, width, TextAlignment.LEFT, false, false);
    }

    public TextComponent(String string) {
        this(string, IMinecraft.instance.getDefaultFontRenderer().getStringWidth(string));
    }

    @Override
    public int getWidth() {
        return this.suggestedWidth + 4;
    }

    @Override
    public int getHeight() {
        return 2 + (this.fontRenderer.getHeight() + 2) * this.split(this.string.get(), this.getWidth()).size();
    }

    public List<String> split(String text, int width) {
        if (!this.split) {
            return Collections.singletonList(text);
        }
        if (Objects.equals(text, this.lastString) && width == this.lastWidth) {
            return this.lastSplit;
        }
        this.lastString = text;
        this.lastWidth = width;
        this.lastSplit = this.fontRenderer.splitText(text, width);
        return this.lastSplit;
    }

    @Override
    public void render(GuiImmediateContext context) {
        context.getRenderContext().pushMatrix();
        List<String> lines = this.split(this.string.get(), context.getWidth());
        for (String line : lines) {
            int length = this.fontRenderer.getStringWidth(line);
            if (length > context.getWidth()) {
                context.getRenderContext().drawStringScaledMaxWidth(line, this.fontRenderer, 2, 2, this.shadow, context.getWidth(), -1);
            } else {
                switch (this.alignment) {
                    case LEFT: {
                        context.getRenderContext().drawString(this.fontRenderer, line, 2, 2, -1, this.shadow);
                        break;
                    }
                    case CENTER: {
                        context.getRenderContext().drawString(this.fontRenderer, line, context.getWidth() / 2 - length / 2 + 2, 2, -1, this.shadow);
                        break;
                    }
                    case RIGHT: {
                        context.getRenderContext().drawString(this.fontRenderer, line, context.getWidth() - length + 2, 2, -1, this.shadow);
                    }
                }
            }
            context.getRenderContext().translate(0.0f, this.fontRenderer.getHeight() + 2, 0.0f);
        }
        context.getRenderContext().popMatrix();
    }

    public TextComponent(IFontRenderer fontRenderer, Supplier<String> string, int suggestedWidth, TextAlignment alignment, boolean shadow, boolean split) {
        this.fontRenderer = fontRenderer;
        this.string = string;
        this.suggestedWidth = suggestedWidth;
        this.alignment = alignment;
        this.shadow = shadow;
        this.split = split;
    }

    public static enum TextAlignment {
        LEFT,
        CENTER,
        RIGHT;

    }
}

