/*
 * Decompiled with CFR 0.152.
 */
package com.nekiplay.hypixelcry.deps.moulconfig.gui.editors;

import com.nekiplay.hypixelcry.deps.moulconfig.DescriptionRendereringBehaviour;
import com.nekiplay.hypixelcry.deps.moulconfig.common.IFontRenderer;
import com.nekiplay.hypixelcry.deps.moulconfig.common.IMinecraft;
import com.nekiplay.hypixelcry.deps.moulconfig.common.RenderContext;
import com.nekiplay.hypixelcry.deps.moulconfig.gui.GuiComponent;
import com.nekiplay.hypixelcry.deps.moulconfig.gui.GuiContext;
import com.nekiplay.hypixelcry.deps.moulconfig.gui.GuiImmediateContext;
import com.nekiplay.hypixelcry.deps.moulconfig.gui.GuiOptionEditor;
import com.nekiplay.hypixelcry.deps.moulconfig.gui.KeyboardEvent;
import com.nekiplay.hypixelcry.deps.moulconfig.gui.MouseEvent;
import com.nekiplay.hypixelcry.deps.moulconfig.gui.component.CenterComponent;
import com.nekiplay.hypixelcry.deps.moulconfig.gui.component.PanelComponent;
import com.nekiplay.hypixelcry.deps.moulconfig.processor.ProcessedOption;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ComponentEditor
extends GuiOptionEditor {
    private static final int HEIGHT = 45;
    @Nullable
    private GuiComponent overlay;
    private int overlayX;
    private int overlayY;
    private int lastRenderX;
    private int lastRenderY;
    private int lastRenderWidth;
    private int lastRenderHeight;

    protected ComponentEditor(ProcessedOption option) {
        super(option);
    }

    @NotNull
    public abstract GuiComponent getDelegate();

    public void closeOverlay() {
        this.overlay = null;
    }

    public boolean isOverlayOpen() {
        return this.overlay != null;
    }

    public void openOverlay(GuiComponent overlay, int overlayX, int overlayY) {
        this.overlay = overlay;
        this.overlayX = overlayX;
        this.overlayY = overlayY;
    }

    @Nullable
    public GuiComponent getOverlayDelegate() {
        return this.overlay;
    }

    public GuiImmediateContext getImmContext(int x, int y, int width, int height, RenderContext renderContext) {
        IMinecraft instance = IMinecraft.instance;
        return new GuiImmediateContext(renderContext, x, y, width, height, instance.getMouseX() - x, instance.getMouseY() - y, instance.getMouseX(), instance.getMouseY(), (float)instance.getMouseXHF() - (float)x, (float)instance.getMouseYHF() - (float)y);
    }

    protected GuiComponent wrapComponent(GuiComponent component) {
        return new EditorComponentWrapper(new CenterComponent(component));
    }

    @Override
    public int getHeight() {
        return Math.max(this.getDelegate().getHeight(), super.getHeight());
    }

    @Override
    public final boolean mouseInput(int x, int y, int width, int mouseX, int mouseY, MouseEvent mouseEvent) {
        return this.getDelegate().mouseEvent(mouseEvent, this.getImmContext(x, y, width, this.getHeight(), IMinecraft.instance.provideTopLevelRenderContext()));
    }

    @Override
    public final boolean keyboardInput(KeyboardEvent keyboardEvent) {
        GuiImmediateContext ctx = this.getImmContext(this.lastRenderX, this.lastRenderY, this.lastRenderWidth, this.lastRenderHeight, IMinecraft.instance.provideTopLevelRenderContext());
        GuiComponent overlay = this.getOverlayDelegate();
        if (overlay != null) {
            overlay.foldRecursive(null, (comp, _void) -> {
                comp.setContext(this.getDelegate().getContext());
                return _void;
            });
            if (overlay.keyboardEvent(keyboardEvent, ctx)) {
                return true;
            }
        }
        return this.getDelegate().keyboardEvent(keyboardEvent, ctx);
    }

    @Override
    public void setGuiContext(GuiContext guiContext) {
        this.getDelegate().foldRecursive(null, (comp, _void) -> {
            comp.setContext(guiContext);
            return _void;
        });
    }

    @Override
    public final void render(RenderContext renderContext, int x, int y, int width) {
        this.lastRenderX = x;
        this.lastRenderY = y;
        this.lastRenderWidth = width;
        this.lastRenderHeight = this.getHeight();
        GuiImmediateContext context = this.getImmContext(x, y, width, this.getHeight(), renderContext);
        context.getRenderContext().pushMatrix();
        context.getRenderContext().translate(context.getRenderOffsetX(), context.getRenderOffsetY(), 0.0f);
        this.getDelegate().render(context);
        context.getRenderContext().popMatrix();
    }

    @Override
    public final boolean mouseInputOverlay(int x, int y, int width, int mouseX, int mouseY, MouseEvent event) {
        if (this.overlay == null) {
            return false;
        }
        this.overlay.foldRecursive(null, (comp, _void) -> {
            comp.setContext(this.getDelegate().getContext());
            return _void;
        });
        return this.overlay.mouseEvent(event, this.getImmContext(this.overlayX, this.overlayY, this.overlay.getWidth(), this.overlay.getHeight(), IMinecraft.instance.provideTopLevelRenderContext()));
    }

    @Override
    public final void renderOverlay(RenderContext context, int x, int y, int width) {
        if (this.overlay == null) {
            return;
        }
        this.overlay.foldRecursive(null, (comp, _void) -> {
            comp.setContext(this.getDelegate().getContext());
            return _void;
        });
        GuiImmediateContext ctx = this.getImmContext(this.overlayX, this.overlayY, this.overlay.getWidth(), this.overlay.getHeight(), context);
        ctx.getRenderContext().translate(this.overlayX, this.overlayY, 0.0f);
        this.overlay.render(ctx);
    }

    public int getOverlayX() {
        return this.overlayX;
    }

    public int getOverlayY() {
        return this.overlayY;
    }

    public class EditorComponentWrapper
    extends PanelComponent {
        public EditorComponentWrapper(GuiComponent component) {
            super(component);
        }

        @Override
        public int getWidth() {
            return super.getWidth() + 150;
        }

        @Override
        public int getHeight() {
            if (ComponentEditor.this.option.getConfig().getDescriptionBehaviour(ComponentEditor.this.option) != DescriptionRendereringBehaviour.EXPAND_PANEL) {
                return super.getHeight();
            }
            IFontRenderer fr = IMinecraft.instance.getDefaultFontRenderer();
            return Math.max(45, fr.splitText(ComponentEditor.this.option.getDescription(), 156).size() * (fr.getHeight() + 1) + 10);
        }

        @Override
        protected GuiImmediateContext getChildContext(GuiImmediateContext context) {
            return context.translated(5, 13, context.getWidth() / 3 - 10, context.getHeight() - 13);
        }

        @Override
        public void render(@NotNull GuiImmediateContext context) {
            context.getRenderContext().drawDarkRect(0, 0, context.getWidth(), context.getHeight() - 2);
            this.renderTitle(context);
            this.renderDescription(context);
            this.renderElement(context);
        }

        protected void renderElement(@NotNull GuiImmediateContext context) {
            context.getRenderContext().pushMatrix();
            context.getRenderContext().translate(5.0f, 13.0f, 0.0f);
            this.getElement().render(this.getChildContext(context));
            context.getRenderContext().popMatrix();
        }

        protected void renderTitle(@NotNull GuiImmediateContext context) {
            int width = context.getWidth();
            IMinecraft minecraft = context.getRenderContext().getMinecraft();
            IFontRenderer fr = minecraft.getDefaultFontRenderer();
            context.getRenderContext().drawStringCenteredScaledMaxWidth(ComponentEditor.this.option.getName(), fr, width / 6, 13.0f, true, width / 3 - 10, 0xC0C0C0);
        }

        protected void renderDescription(@NotNull GuiImmediateContext context) {
            List<String> lines;
            int descriptionHeight;
            int width = context.getWidth();
            IMinecraft minecraft = context.getRenderContext().getMinecraft();
            IFontRenderer fr = minecraft.getDefaultFontRenderer();
            float scale = 1.0f;
            int n = descriptionHeight = ComponentEditor.this.option.getConfig().getDescriptionBehaviour(ComponentEditor.this.option) != DescriptionRendereringBehaviour.EXPAND_PANEL ? 45 : context.getHeight();
            while (!((float)(lines = fr.splitText(ComponentEditor.this.option.getDescription(), (int)((float)(width * 2 / 3) / scale - 10.0f))).size() * scale * (float)(fr.getHeight() + 1) + 10.0f < (float)descriptionHeight) && !((scale -= 0.125f) < 0.0625f)) {
            }
            context.getRenderContext().pushMatrix();
            context.getRenderContext().translate(5 + width / 3, 5.0f, 0.0f);
            context.getRenderContext().scale(scale, scale, 1.0f);
            context.getRenderContext().translate(0.0f, ((float)(descriptionHeight - 10) - (float)((fr.getHeight() + 1) * (lines.size() - 1)) * scale) / 2.0f, 0.0f);
            for (String line : lines) {
                context.getRenderContext().drawString(fr, line, 0, 0, 0xC0C0C0, false);
                context.getRenderContext().translate(0.0f, fr.getHeight() + 1, 0.0f);
            }
            context.getRenderContext().popMatrix();
        }
    }
}

