/*
 * Decompiled with CFR 0.152.
 */
package com.nekiplay.hypixelcry.deps.moulconfig.gui.editors;

import com.nekiplay.hypixelcry.deps.moulconfig.ChromaColour;
import com.nekiplay.hypixelcry.deps.moulconfig.GuiTextures;
import com.nekiplay.hypixelcry.deps.moulconfig.gui.GuiComponent;
import com.nekiplay.hypixelcry.deps.moulconfig.gui.GuiImmediateContext;
import com.nekiplay.hypixelcry.deps.moulconfig.gui.MouseEvent;
import com.nekiplay.hypixelcry.deps.moulconfig.gui.component.ColorSelectComponent;
import com.nekiplay.hypixelcry.deps.moulconfig.gui.editors.ComponentEditor;
import com.nekiplay.hypixelcry.deps.moulconfig.processor.ProcessedOption;
import java.lang.reflect.Type;
import org.jetbrains.annotations.NotNull;

public class GuiOptionEditorColour
extends ComponentEditor {
    private final boolean usesString;
    GuiComponent component;

    public GuiOptionEditorColour(ProcessedOption option) {
        super(option);
        Type type = option.getType();
        if (type.equals(String.class)) {
            this.usesString = true;
        } else if (type.equals(ChromaColour.class)) {
            this.usesString = false;
        } else {
            throw new IllegalArgumentException("ConfigEditorColour may only be used on a String or ChromaColour field, but is used on " + option.getDebugDeclarationLocation());
        }
        this.component = this.wrapComponent(new GuiComponent(){

            @Override
            public int getWidth() {
                return 48;
            }

            @Override
            public int getHeight() {
                return 16;
            }

            @Override
            public void render(@NotNull GuiImmediateContext context) {
                int argb = GuiOptionEditorColour.this.get().getEffectiveColour().getRGB();
                int r = argb >> 16 & 0xFF;
                int g = argb >> 8 & 0xFF;
                int b = argb & 0xFF;
                context.getRenderContext().color((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, 1.0f);
                context.getRenderContext().bindTexture(GuiTextures.BUTTON_WHITE);
                context.getRenderContext().drawTexturedRect(0.0f, 0.0f, context.getWidth(), context.getHeight());
                context.getRenderContext().color(1.0f, 1.0f, 1.0f, 1.0f);
            }

            @Override
            public boolean mouseEvent(@NotNull MouseEvent mouseEvent, @NotNull GuiImmediateContext context) {
                MouseEvent.Click click;
                if (mouseEvent instanceof MouseEvent.Click && (click = (MouseEvent.Click)mouseEvent).getMouseState() && click.getMouseButton() == 0 && context.isHovered()) {
                    GuiOptionEditorColour.this.openOverlay(new ColorSelectComponent(0, 0, GuiOptionEditorColour.this.get().toLegacyString(), newString -> GuiOptionEditorColour.this.set((String)newString), () -> GuiOptionEditorColour.this.closeOverlay()), context.getAbsoluteMouseX(), context.getAbsoluteMouseY());
                    return true;
                }
                return false;
            }
        });
    }

    ChromaColour get() {
        Object value = this.option.get();
        if (this.usesString) {
            return ChromaColour.forLegacyString((String)value);
        }
        return (ChromaColour)value;
    }

    void set(String newString) {
        if (this.usesString) {
            this.option.set(newString);
        } else {
            this.option.set(ChromaColour.forLegacyString(newString));
        }
    }

    @Override
    @NotNull
    public GuiComponent getDelegate() {
        return this.component;
    }
}

