/*
 * Decompiled with CFR 0.152.
 */
package com.nekiplay.hypixelcry.deps.moulconfig.gui.editors;

import com.nekiplay.hypixelcry.deps.moulconfig.GuiTextures;
import com.nekiplay.hypixelcry.deps.moulconfig.common.IFontRenderer;
import com.nekiplay.hypixelcry.deps.moulconfig.common.IMinecraft;
import com.nekiplay.hypixelcry.deps.moulconfig.common.KeyboardConstants;
import com.nekiplay.hypixelcry.deps.moulconfig.common.RenderContext;
import com.nekiplay.hypixelcry.deps.moulconfig.gui.GuiOptionEditor;
import com.nekiplay.hypixelcry.deps.moulconfig.gui.KeyboardEvent;
import com.nekiplay.hypixelcry.deps.moulconfig.gui.MouseEvent;
import com.nekiplay.hypixelcry.deps.moulconfig.internal.LerpUtils;
import com.nekiplay.hypixelcry.deps.moulconfig.internal.TypeUtils;
import com.nekiplay.hypixelcry.deps.moulconfig.internal.Warnings;
import com.nekiplay.hypixelcry.deps.moulconfig.processor.ProcessedOption;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Pair;

public class GuiOptionEditorDraggableList
extends GuiOptionEditor {
    private Map<Object, String> exampleText = new HashMap<Object, String>();
    private boolean enableDeleting;
    private List<Object> activeText;
    private final boolean requireNonEmpty;
    private Object currentDragging = null;
    private int dragStartIndex = -1;
    private Pair<Integer, Integer> lastMousePosition = null;
    private long trashHoverTime = -1L;
    private int dragOffsetX = -1;
    private int dragOffsetY = -1;
    private boolean dropdownOpen = false;
    private Enum<?>[] enumConstants;
    private String exampleTextConcat;

    public GuiOptionEditorDraggableList(ProcessedOption option, String[] exampleText, boolean enableDeleting) {
        this(option, exampleText, enableDeleting, false);
    }

    public GuiOptionEditorDraggableList(ProcessedOption option, String[] exampleText, boolean enableDeleting, boolean requireNonEmpty) {
        super(option);
        this.enableDeleting = enableDeleting;
        this.activeText = (List)option.get();
        this.requireNonEmpty = requireNonEmpty;
        Class<?> elementType = TypeUtils.resolveRawType(((ParameterizedType)option.getType()).getActualTypeArguments()[0]);
        if (Enum.class.isAssignableFrom(elementType)) {
            Class<?> enumType = elementType;
            this.enumConstants = (Enum[])enumType.getEnumConstants();
            for (int i2 = 0; i2 < this.enumConstants.length; ++i2) {
                this.exampleText.put(this.enumConstants[i2], this.enumConstants[i2].toString());
            }
        } else {
            for (int i3 = 0; i3 < exampleText.length; ++i3) {
                this.exampleText.put(i3, exampleText[i3]);
            }
        }
    }

    private void saveChanges() {
        this.option.explicitNotifyChange();
    }

    private String getExampleText(Object forObject) {
        String str = this.exampleText.get(forObject);
        if (str == null) {
            str = "<unknown " + forObject + ">";
            Warnings.warnOnce("Could not find draggable list object for " + forObject + " on option " + this.option.getDebugDeclarationLocation(), forObject, this.option);
        }
        return str;
    }

    @Override
    public int getHeight() {
        int height = super.getHeight() + 13;
        for (Object object : this.activeText) {
            String str = this.getExampleText(object);
            height += 10 * str.split("\n").length;
        }
        return height;
    }

    public boolean canDeleteRightNow() {
        return this.enableDeleting && (this.activeText.size() > 1 || !this.requireNonEmpty);
    }

    @Override
    public void render(RenderContext renderContext, int x, int y, int width) {
        super.render(renderContext, x, y, width);
        int height = this.getHeight();
        IFontRenderer fr = IMinecraft.instance.getDefaultFontRenderer();
        renderContext.color(1.0f, 1.0f, 1.0f, 1.0f);
        IMinecraft.instance.bindTexture(GuiTextures.BUTTON);
        renderContext.drawTexturedRect(x + width / 6 - 24, y + 45 - 7 - 14, 48.0f, 16.0f);
        renderContext.drawStringCenteredScaledMaxWidth("Add", fr, x + width / 6, y + 45 - 7 - 6, false, 44, -13619152);
        if (this.canDeleteRightNow()) {
            float greenBlue;
            long currentTime = System.currentTimeMillis();
            if (this.trashHoverTime < 0L) {
                greenBlue = LerpUtils.clampZeroOne((float)(currentTime + this.trashHoverTime) / 250.0f);
                renderContext.color(1.0f, greenBlue, greenBlue, 1.0f);
            } else {
                greenBlue = LerpUtils.clampZeroOne((float)(250L + this.trashHoverTime - currentTime) / 250.0f);
                renderContext.color(1.0f, greenBlue, greenBlue, 1.0f);
            }
            int deleteX = x + width / 6 + 27;
            int deleteY = y + 45 - 7 - 13;
            renderContext.bindTexture(GuiTextures.DELETE);
            renderContext.setTextureMinMagFilter(RenderContext.TextureFilter.NEAREST);
            renderContext.drawTexturedRect(deleteX, deleteY, 11.0f, 14.0f);
            if (this.lastMousePosition != null && this.currentDragging == null && (Integer)this.lastMousePosition.getFirst() >= deleteX && (Integer)this.lastMousePosition.getFirst() < deleteX + 11 && (Integer)this.lastMousePosition.getSecond() >= deleteY && (Integer)this.lastMousePosition.getSecond() < deleteY + 14 && !this.dropdownOpen) {
                renderContext.scheduleDrawTooltip(Collections.singletonList("\u00a7cDelete Item"));
            }
            renderContext.color(1.0f, 1.0f, 1.0f, 1.0f);
        }
        renderContext.drawColoredRect(x + 5, y + 45, x + width - 5, y + height - 5, -2236963);
        renderContext.drawColoredRect(x + 6, y + 46, x + width - 6, y + height - 6, -16777216);
        int i2 = 0;
        int yOff = 0;
        for (Object indexObject : this.activeText) {
            String str = this.getExampleText(indexObject);
            String[] multilines = str.split("\n");
            int ySize = multilines.length * 10;
            if (i2++ != this.dragStartIndex) {
                for (int multilineIndex = 0; multilineIndex < multilines.length; ++multilineIndex) {
                    String line = multilines[multilineIndex];
                    renderContext.drawStringScaledMaxWidth(line + "\u00a7r", fr, x + 20, y + 50 + yOff + multilineIndex * 10, true, width - 20, -1);
                }
                renderContext.drawString(fr, "\u2261", x + 10, y + 49 + yOff + ySize / 2 - 4, 0xFFFFFF, true);
            }
            yOff += ySize;
        }
    }

    @Override
    public void renderOverlay(RenderContext context, int x, int y, int width) {
        super.renderOverlay(context, x, y, width);
        IFontRenderer fr = IMinecraft.instance.getDefaultFontRenderer();
        if (this.dropdownOpen) {
            ArrayList<Object> remaining = new ArrayList<Object>(this.exampleText.keySet());
            remaining.removeAll(this.activeText);
            int dropdownWidth = Math.min(width / 2 - 10, 150);
            int left = this.dragOffsetX;
            int top = this.dragOffsetY;
            int dropdownHeight = -1 + 12 * remaining.size();
            int main = -14671834;
            int outline = -12566458;
            context.drawColoredRect(left, top, left + 1, top + dropdownHeight, outline);
            context.drawColoredRect(left + 1, top, left + dropdownWidth, top + 1, outline);
            context.drawColoredRect(left + dropdownWidth - 1, top + 1, left + dropdownWidth, top + dropdownHeight, outline);
            context.drawColoredRect(left + 1, top + dropdownHeight - 1, left + dropdownWidth - 1, top + dropdownHeight, outline);
            context.drawColoredRect(left + 1, top + 1, left + dropdownWidth - 1, top + dropdownHeight - 1, main);
            int dropdownY = -1;
            for (Object e : remaining) {
                String str = this.getExampleText(e);
                if (str.isEmpty()) {
                    str = "<NONE>";
                }
                context.drawStringScaledMaxWidth(str.replaceAll("(\n.*)+", " ..."), fr, left + 3, top + 3 + dropdownY, false, dropdownWidth - 6, -6250336);
                dropdownY += 12;
            }
        } else if (this.currentDragging != null) {
            float greenBlue;
            int opacity = 128;
            long currentTime = System.currentTimeMillis();
            if (this.trashHoverTime < 0L) {
                greenBlue = LerpUtils.clampZeroOne((float)(currentTime + this.trashHoverTime) / 250.0f);
                opacity = (int)((float)opacity * greenBlue);
            } else {
                greenBlue = LerpUtils.clampZeroOne((float)(250L + this.trashHoverTime - currentTime) / 250.0f);
                opacity = (int)((float)opacity * greenBlue);
            }
            if (opacity < 20) {
                return;
            }
            int mouseX = IMinecraft.instance.getMouseX();
            int mouseY = IMinecraft.instance.getMouseY();
            String str = this.getExampleText(this.currentDragging);
            String[] multilines = str.split("\n");
            for (int multilineIndex = 0; multilineIndex < multilines.length; ++multilineIndex) {
                String line = multilines[multilineIndex];
                context.drawStringScaledMaxWidth(line + "\u00a7r", fr, this.dragOffsetX + mouseX + 10, this.dragOffsetY + mouseY + multilineIndex * 10, true, width - 20, 0xFFFFFF | opacity << 24);
            }
            int ySize = multilines.length * 10;
            context.drawString(fr, "\u2261", this.dragOffsetX + mouseX, this.dragOffsetY - 1 + mouseY + ySize / 2 - 4, 0xFFFFFF, true);
        }
    }

    @Override
    public boolean mouseInput(int x, int y, int width, int mouseX, int mouseY, MouseEvent mouseEvent) {
        block23: {
            block24: {
                MouseEvent.Click click;
                this.lastMousePosition = new Pair((Object)mouseX, (Object)mouseY);
                if (mouseEvent instanceof MouseEvent.Scroll) {
                    this.dropdownOpen = false;
                    return false;
                }
                MouseEvent.Click click2 = click = mouseEvent instanceof MouseEvent.Click ? (MouseEvent.Click)mouseEvent : null;
                if (click != null && !click.getMouseState() && !this.dropdownOpen && this.dragStartIndex >= 0 && click.getMouseButton() == 0 && mouseX >= x + width / 6 + 27 - 3 && mouseX <= x + width / 6 + 27 + 11 + 3 && mouseY >= y + 45 - 7 - 13 - 3 && mouseY <= y + 45 - 7 - 13 + 14 + 3) {
                    if (this.canDeleteRightNow()) {
                        this.activeText.remove(this.dragStartIndex);
                        this.saveChanges();
                    }
                    this.currentDragging = null;
                    this.dragStartIndex = -1;
                    return false;
                }
                if (!IMinecraft.instance.isMouseButtonDown(0) || this.dropdownOpen) {
                    this.currentDragging = null;
                    this.dragStartIndex = -1;
                    if (this.trashHoverTime > 0L && this.canDeleteRightNow()) {
                        this.trashHoverTime = -System.currentTimeMillis();
                    }
                } else if (this.currentDragging != null && mouseX >= x + width / 6 + 27 - 3 && mouseX <= x + width / 6 + 27 + 11 + 3 && mouseY >= y + 45 - 7 - 13 - 3 && mouseY <= y + 45 - 7 - 13 + 14 + 3) {
                    if (this.trashHoverTime < 0L && this.canDeleteRightNow()) {
                        this.trashHoverTime = System.currentTimeMillis();
                    }
                } else if (!this.canDeleteRightNow()) {
                    this.trashHoverTime = Long.MAX_VALUE;
                } else if (this.trashHoverTime > 0L) {
                    this.trashHoverTime = -System.currentTimeMillis();
                }
                if (click == null || !click.getMouseState()) break block24;
                int height = this.getHeight();
                if (this.dropdownOpen) {
                    ArrayList<Object> remaining = new ArrayList<Object>(this.exampleText.keySet());
                    remaining.removeAll(this.activeText);
                    int dropdownWidth = Math.min(width / 2 - 10, 150);
                    int left = this.dragOffsetX;
                    int top = this.dragOffsetY;
                    int dropdownHeight = -1 + 12 * remaining.size();
                    if (mouseX > left && mouseX < left + dropdownWidth && mouseY > top && mouseY < top + dropdownHeight) {
                        int dropdownY = -1;
                        for (Object e : remaining) {
                            if (mouseY < top + dropdownY + 12) {
                                this.activeText.add(0, e);
                                this.saveChanges();
                                if (remaining.size() == 1) {
                                    this.dropdownOpen = false;
                                }
                                return true;
                            }
                            dropdownY += 12;
                        }
                    }
                    this.dropdownOpen = false;
                    return true;
                }
                if (this.activeText.size() < this.exampleText.size() && mouseX > x + width / 6 - 24 && mouseX < x + width / 6 + 24 && mouseY > y + 45 - 7 - 14 && mouseY < y + 45 - 7 + 2) {
                    this.dropdownOpen = true;
                    this.dragOffsetX = mouseX;
                    this.dragOffsetY = mouseY;
                    return true;
                }
                if (click.getMouseButton() != 0 || mouseX <= x + 5 || mouseX >= x + width - 5 || mouseY <= y + 45 || mouseY >= y + height - 6) break block23;
                int yOff = 0;
                int i2 = 0;
                for (Object objectIndex : this.activeText) {
                    String str = this.getExampleText(objectIndex);
                    int ySize = 10 * str.split("\n").length;
                    if (mouseY < y + 50 + yOff + ySize) {
                        this.dragOffsetX = x + 10 - mouseX;
                        this.dragOffsetY = y + 50 + yOff - mouseY;
                        this.currentDragging = objectIndex;
                        this.dragStartIndex = i2;
                        break block23;
                    }
                    yOff += ySize;
                    ++i2;
                }
                break block23;
            }
            if (mouseEvent instanceof MouseEvent.Move && this.currentDragging != null) {
                int yOff = 0;
                int i3 = 0;
                for (Object objectIndex : this.activeText) {
                    if (this.dragOffsetY + mouseY + 4 < y + 50 + yOff + 10) {
                        this.activeText.remove(this.dragStartIndex);
                        this.activeText.add(i3, this.currentDragging);
                        this.saveChanges();
                        this.dragStartIndex = i3;
                        break;
                    }
                    String str = this.getExampleText(objectIndex);
                    yOff += 10 * str.split("\n").length;
                    ++i3;
                }
            }
        }
        return false;
    }

    @Override
    public boolean fulfillsSearch(String word) {
        if (this.exampleTextConcat == null) {
            this.exampleTextConcat = String.join((CharSequence)"", this.exampleText.values()).toLowerCase(Locale.ROOT);
        }
        return super.fulfillsSearch(word) || this.exampleTextConcat.contains(word);
    }

    @Override
    public boolean keyboardInput(KeyboardEvent event) {
        int key;
        if (event instanceof KeyboardEvent.KeyPressed && ((key = ((KeyboardEvent.KeyPressed)event).getKeycode()) == KeyboardConstants.INSTANCE.getUp() || key == KeyboardConstants.INSTANCE.getDown())) {
            this.dropdownOpen = false;
        }
        return super.keyboardInput(event);
    }
}

