/*
 * Decompiled with CFR 0.152.
 */
package com.nekiplay.hypixelcry.deps.moulconfig.gui.editors;

import com.nekiplay.hypixelcry.deps.moulconfig.common.IFontRenderer;
import com.nekiplay.hypixelcry.deps.moulconfig.common.IMinecraft;
import com.nekiplay.hypixelcry.deps.moulconfig.gui.GuiComponent;
import com.nekiplay.hypixelcry.deps.moulconfig.gui.GuiImmediateContext;
import com.nekiplay.hypixelcry.deps.moulconfig.gui.MouseEvent;
import com.nekiplay.hypixelcry.deps.moulconfig.gui.editors.ComponentEditor;
import com.nekiplay.hypixelcry.deps.moulconfig.processor.ProcessedOption;
import java.util.Arrays;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

public class GuiOptionEditorDropdown
extends ComponentEditor {
    private String[] values;
    private boolean useOrdinal;
    private Enum<?>[] constants;
    private String valuesForSearch;
    int componentWidth = 0;
    private GuiComponent dropdownOverlay = new GuiComponent(){

        @Override
        public int getWidth() {
            return GuiOptionEditorDropdown.this.componentWidth;
        }

        @Override
        public int getHeight() {
            return 13 + 12 * GuiOptionEditorDropdown.this.values.length;
        }

        @Override
        public boolean mouseEvent(@NotNull MouseEvent mouseEvent, @NotNull GuiImmediateContext context) {
            if (mouseEvent instanceof MouseEvent.Click) {
                MouseEvent.Click click = (MouseEvent.Click)mouseEvent;
                if (click.getMouseState()) {
                    GuiOptionEditorDropdown.this.closeOverlay();
                }
                if (click.getMouseState() && click.getMouseButton() == 0 && context.isHovered()) {
                    int top = 0;
                    int mouseY = context.getMouseY();
                    int dropdownY = 13;
                    for (int ordinal = 0; ordinal < GuiOptionEditorDropdown.this.values.length; ++ordinal) {
                        if (mouseY >= top + 3 + dropdownY && mouseY <= top + 3 + dropdownY + 12) {
                            int selected = ordinal;
                            if (GuiOptionEditorDropdown.this.constants != null) {
                                GuiOptionEditorDropdown.this.option.set(GuiOptionEditorDropdown.this.constants[selected]);
                            } else if (GuiOptionEditorDropdown.this.useOrdinal) {
                                GuiOptionEditorDropdown.this.option.set(selected);
                            } else {
                                GuiOptionEditorDropdown.this.option.set(GuiOptionEditorDropdown.this.values[selected]);
                            }
                        }
                        dropdownY += 12;
                    }
                }
                return true;
            }
            return super.mouseEvent(mouseEvent, context);
        }

        @Override
        public void render(@NotNull GuiImmediateContext context) {
            int selected = GuiOptionEditorDropdown.this.getSelectedIndex();
            String selectedString = " - Select - ";
            if (selected >= 0 && selected < GuiOptionEditorDropdown.this.values.length) {
                selectedString = GuiOptionEditorDropdown.this.values[selected];
            }
            int dropdownHeight = context.getHeight();
            int dropdownWidth = context.getWidth();
            int main = -14671834;
            int outlineColour = -1;
            context.getRenderContext().pushMatrix();
            context.getRenderContext().translate(0.0f, 0.0f, 100.0f);
            int left = 0;
            int top = 0;
            context.getRenderContext().drawColoredRect(left, top, left + 1, top + dropdownHeight, outlineColour);
            context.getRenderContext().drawColoredRect(left + 1, top, left + dropdownWidth, top + 1, outlineColour);
            context.getRenderContext().drawColoredRect(left + dropdownWidth - 1, top + 1, left + dropdownWidth, top + dropdownHeight, outlineColour);
            context.getRenderContext().drawColoredRect(left + 1, top + dropdownHeight - 1, left + dropdownWidth - 1, top + dropdownHeight, outlineColour);
            context.getRenderContext().drawColoredRect(left + 1, top + 1, left + dropdownWidth - 1, top + dropdownHeight - 1, main);
            context.getRenderContext().drawColoredRect(left + 1, top + 14 - 1, left + dropdownWidth - 1, top + 14, outlineColour);
            int dropdownY = 13;
            IFontRenderer fr = IMinecraft.instance.getDefaultFontRenderer();
            for (String option : GuiOptionEditorDropdown.this.values) {
                if (option.isEmpty()) {
                    option = "<NONE>";
                }
                context.getRenderContext().drawStringScaledMaxWidth(option, fr, left + 3, top + 3 + dropdownY, false, dropdownWidth - 6, -6250336);
                dropdownY += 12;
            }
            context.getRenderContext().drawStringScaledMaxWidth(selectedString, fr, left + 3, top + 3, false, dropdownWidth - 16, -6250336);
            context.getRenderContext().drawOpenCloseTriangle(false, context.getWidth() - 10, 4.0f, 6.0f, 6.0f);
            context.getRenderContext().popMatrix();
        }
    };
    private GuiComponent component = this.wrapComponent(new GuiComponent(){

        @Override
        public int getWidth() {
            return 80;
        }

        @Override
        public int getHeight() {
            return 14;
        }

        @Override
        public boolean mouseEvent(@NotNull MouseEvent mouseEvent, @NotNull GuiImmediateContext context) {
            if (mouseEvent instanceof MouseEvent.Click && ((MouseEvent.Click)mouseEvent).getMouseState() && context.isHovered()) {
                if (!GuiOptionEditorDropdown.this.isOverlayOpen()) {
                    GuiOptionEditorDropdown.this.componentWidth = context.getWidth();
                    GuiOptionEditorDropdown.this.openOverlay(GuiOptionEditorDropdown.this.dropdownOverlay, context.getRenderOffsetX(), context.getRenderOffsetY());
                }
                return true;
            }
            return super.mouseEvent(mouseEvent, context);
        }

        @Override
        public void render(@NotNull GuiImmediateContext context) {
            int dropdownWidth = context.getWidth();
            int selected = GuiOptionEditorDropdown.this.getSelectedIndex();
            if (selected >= GuiOptionEditorDropdown.this.values.length) {
                selected = GuiOptionEditorDropdown.this.values.length;
            }
            String selectedString = " - Select - ";
            if (selected >= 0 && selected < GuiOptionEditorDropdown.this.values.length) {
                selectedString = GuiOptionEditorDropdown.this.values[selected];
            }
            context.getRenderContext().drawDarkRect(0, 0, dropdownWidth, context.getHeight(), false);
            context.getRenderContext().drawOpenCloseTriangle(true, context.getWidth() - 10, 4.0f, 6.0f, 6.0f);
            context.getRenderContext().drawStringScaledMaxWidth(selectedString, IMinecraft.instance.getDefaultFontRenderer(), 3, 3, false, context.getWidth() - 16, -6250336);
        }
    });

    public GuiOptionEditorDropdown(ProcessedOption option, String[] values) {
        super(option);
        Class clazz = (Class)option.getType();
        if (Enum.class.isAssignableFrom(clazz)) {
            this.constants = (Enum[])clazz.getEnumConstants();
            this.values = new String[this.constants.length];
            for (int i2 = 0; i2 < this.constants.length; ++i2) {
                this.values[i2] = this.constants[i2].toString();
            }
        } else {
            this.values = values;
            assert (values.length > 0);
        }
        this.useOrdinal = clazz == Integer.TYPE || clazz == Integer.class;
    }

    @Override
    @NotNull
    public GuiComponent getDelegate() {
        return this.component;
    }

    private int getSelectedIndex() {
        Object selectedObject = this.option.get();
        if (selectedObject == null) {
            return -1;
        }
        if (this.useOrdinal) {
            return (Integer)selectedObject;
        }
        if (this.constants != null) {
            return ((Enum)selectedObject).ordinal();
        }
        return Arrays.asList(this.values).indexOf(selectedObject);
    }

    @Override
    public boolean fulfillsSearch(String word) {
        if (this.valuesForSearch == null) {
            this.valuesForSearch = String.join((CharSequence)"", this.values).toLowerCase(Locale.ROOT);
        }
        return super.fulfillsSearch(word) || this.valuesForSearch.contains(word);
    }
}

