/*
 * Decompiled with CFR 0.152.
 */
package com.nekiplay.hypixelcry.deps.moulconfig.gui.editors;

import com.nekiplay.hypixelcry.deps.moulconfig.GuiTextures;
import com.nekiplay.hypixelcry.deps.moulconfig.annotations.ConfigEditorKeybind;
import com.nekiplay.hypixelcry.deps.moulconfig.common.IMinecraft;
import com.nekiplay.hypixelcry.deps.moulconfig.common.KeyboardConstants;
import com.nekiplay.hypixelcry.deps.moulconfig.common.RenderContext;
import com.nekiplay.hypixelcry.deps.moulconfig.gui.GuiComponent;
import com.nekiplay.hypixelcry.deps.moulconfig.gui.GuiImmediateContext;
import com.nekiplay.hypixelcry.deps.moulconfig.gui.KeyboardEvent;
import com.nekiplay.hypixelcry.deps.moulconfig.gui.MouseEvent;
import com.nekiplay.hypixelcry.deps.moulconfig.gui.editors.ComponentEditor;
import com.nekiplay.hypixelcry.deps.moulconfig.internal.Warnings;
import com.nekiplay.hypixelcry.deps.moulconfig.processor.ProcessedOption;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class GuiOptionEditorKeybind
extends ComponentEditor {
    private boolean editingKeycode = false;
    GuiComponent component;

    public GuiOptionEditorKeybind(final ProcessedOption option, final int defaultKeyCode) {
        super(option);
        if (option.getType() != Integer.TYPE && option.getType() != Integer.class) {
            Warnings.warn(ConfigEditorKeybind.class + " can only be applied to int properties.");
        }
        this.component = this.wrapComponent(new GuiComponent(){

            @Override
            public int getWidth() {
                return 0;
            }

            @Override
            public int getHeight() {
                return 30;
            }

            @Override
            public void render(@NotNull GuiImmediateContext context) {
                int height = this.getHeight();
                RenderContext renderContext = context.getRenderContext();
                int width = this.getWidth();
                renderContext.color(1.0f, 1.0f, 1.0f, 1.0f);
                renderContext.bindTexture(GuiTextures.BUTTON);
                renderContext.drawTexturedRect(width / 6 - 24, height - 7 - 14, 48.0f, 16.0f);
                String keyName = IMinecraft.instance.getKeyName((Integer)option.get());
                String text = GuiOptionEditorKeybind.this.editingKeycode ? "> " + keyName + " <" : keyName;
                renderContext.drawStringCenteredScaledMaxWidth(text, IMinecraft.instance.getDefaultFontRenderer(), width / 6, height - 7 - 6, false, 38, -13619152);
                int resetX = width / 6 - 24 + 48 + 3;
                int resetY = height - 7 - 14 + 3;
                renderContext.bindTexture(GuiTextures.RESET);
                renderContext.color(1.0f, 1.0f, 1.0f, 1.0f);
                renderContext.drawTexturedRect(resetX, resetY, 10.0f, 11.0f);
                int mouseX = context.getMouseX();
                int mouseY = context.getMouseY();
                if (mouseX >= resetX && mouseX < resetX + 10 && mouseY >= resetY && mouseY < resetY + 11) {
                    renderContext.scheduleDrawTooltip(Collections.singletonList("\u00a7cReset to Default"));
                }
            }

            @Override
            public boolean mouseEvent(@NotNull MouseEvent mouseEvent, @NotNull GuiImmediateContext context) {
                if (!(mouseEvent instanceof MouseEvent.Click)) {
                    return false;
                }
                MouseEvent.Click click = (MouseEvent.Click)mouseEvent;
                if (click.getMouseState() && click.getMouseButton() != -1 && GuiOptionEditorKeybind.this.editingKeycode) {
                    GuiOptionEditorKeybind.this.editingKeycode = false;
                    int mouseButton = click.getMouseButton();
                    option.set(mouseButton);
                    return true;
                }
                if (click.getMouseState() && click.getMouseButton() == 0) {
                    int height = this.getHeight();
                    int width = this.getHeight();
                    int mouseX = context.getMouseX();
                    int mouseY = context.getMouseY();
                    if (mouseX > width / 6 - 24 && mouseX < width / 6 + 16 && mouseY > height - 7 - 14 && mouseY < height - 7 + 2) {
                        GuiOptionEditorKeybind.this.editingKeycode = true;
                        return true;
                    }
                    if (mouseX > width / 6 - 24 + 48 + 3 && mouseX < width / 6 - 24 + 48 + 13 && mouseY > height - 7 - 14 + 3 && mouseY < height - 7 - 14 + 3 + 11) {
                        option.set(defaultKeyCode);
                        return true;
                    }
                }
                return false;
            }

            @Override
            public boolean keyboardEvent(@NotNull KeyboardEvent keyboardEvent, @NotNull GuiImmediateContext context) {
                if (keyboardEvent instanceof KeyboardEvent.KeyPressed) {
                    KeyboardEvent.KeyPressed keyPressed = (KeyboardEvent.KeyPressed)keyboardEvent;
                    if (GuiOptionEditorKeybind.this.editingKeycode) {
                        if (keyPressed.getPressed()) {
                            return true;
                        }
                        GuiOptionEditorKeybind.this.editingKeycode = false;
                        int keycode = keyPressed.getKeycode();
                        if (keycode == KeyboardConstants.INSTANCE.getEscape() && keycode == 0) {
                            keycode = KeyboardConstants.INSTANCE.getNone();
                        }
                        option.set(keycode);
                        return true;
                    }
                    return false;
                }
                return GuiOptionEditorKeybind.this.editingKeycode;
            }
        });
    }

    @Override
    @NotNull
    public GuiComponent getDelegate() {
        return this.component;
    }
}

