/*
 * Decompiled with CFR 0.152.
 */
package com.nekiplay.hypixelcry.deps.moulconfig.gui.elements;

import com.nekiplay.hypixelcry.deps.moulconfig.GuiTextures;
import com.nekiplay.hypixelcry.deps.moulconfig.common.IMinecraft;
import com.nekiplay.hypixelcry.deps.moulconfig.common.MyResourceLocation;
import com.nekiplay.hypixelcry.deps.moulconfig.gui.GuiElement;
import com.nekiplay.hypixelcry.deps.moulconfig.gui.KeyboardEvent;
import com.nekiplay.hypixelcry.deps.moulconfig.gui.MouseEvent;
import com.nekiplay.hypixelcry.deps.moulconfig.internal.LerpUtils;
import com.nekiplay.hypixelcry.deps.moulconfig.internal.RenderUtils;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.renderer.GlStateManager;
import org.lwjgl.input.Mouse;

public class GuiElementBoolean
extends GuiElement {
    public int x;
    public int y;
    private Supplier<Boolean> value;
    private final int clickRadius;
    private final Consumer<Boolean> toggleCallback;
    private boolean previewValue;
    private int animation = 0;
    private long lastMillis = 0L;
    private static final int xSize = 48;
    private static final int ySize = 14;

    public GuiElementBoolean(int x, int y, Supplier<Boolean> value, Consumer<Boolean> toggleCallback) {
        this(x, y, value, 0, toggleCallback);
    }

    public GuiElementBoolean(int x, int y, Supplier<Boolean> value, int clickRadius, Consumer<Boolean> toggleCallback) {
        this.x = x;
        this.y = y;
        this.value = value;
        this.previewValue = value.get();
        this.clickRadius = clickRadius;
        this.toggleCallback = toggleCallback;
        this.lastMillis = System.currentTimeMillis();
        if (this.previewValue) {
            this.animation = 36;
        }
    }

    @Override
    public void render() {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        IMinecraft.instance.bindTexture(GuiTextures.TOGGLE_BAR);
        RenderUtils.drawTexturedRect(this.x, this.y, 48.0f, 14.0f);
        MyResourceLocation buttonLoc = GuiTextures.TOGGLE_ON;
        long currentMillis = System.currentTimeMillis();
        long deltaMillis = currentMillis - this.lastMillis;
        this.lastMillis = currentMillis;
        boolean passedLimit = false;
        if (this.previewValue != this.value.get() && (this.previewValue && this.animation > 12 || !this.previewValue && this.animation < 24)) {
            passedLimit = true;
        }
        this.animation = this.previewValue != passedLimit ? (int)((long)this.animation + deltaMillis / 10L) : (int)((long)this.animation - deltaMillis / 10L);
        this.lastMillis -= deltaMillis % 10L;
        this.animation = this.previewValue == this.value.get() ? Math.max(0, Math.min(36, this.animation)) : (!passedLimit ? (this.previewValue ? Math.max(0, Math.min(12, this.animation)) : Math.max(24, Math.min(36, this.animation))) : (this.previewValue ? Math.max(12, this.animation) : Math.min(24, this.animation)));
        int animation = (int)(LerpUtils.sigmoidZeroOne((float)this.animation / 36.0f) * 36.0f);
        if (animation < 3) {
            buttonLoc = GuiTextures.TOGGLE_OFF;
        } else if (animation < 13) {
            buttonLoc = GuiTextures.TOGGLE_ONE;
        } else if (animation < 23) {
            buttonLoc = GuiTextures.TOGGLE_TWO;
        } else if (animation < 33) {
            buttonLoc = GuiTextures.TOGGLE_THREE;
        }
        IMinecraft.instance.bindTexture(buttonLoc);
        RenderUtils.drawTexturedRect(this.x + animation, this.y, 12.0f, 14.0f);
    }

    @Override
    public boolean mouseInput(int mouseX, int mouseY, MouseEvent mouseEvent) {
        if (mouseX > this.x - this.clickRadius && mouseX < this.x + 48 + this.clickRadius && mouseY > this.y - this.clickRadius && mouseY < this.y + 14 + this.clickRadius) {
            if (Mouse.getEventButton() == 0) {
                if (Mouse.getEventButtonState()) {
                    this.previewValue = this.value.get() == false;
                } else if (this.previewValue == (this.value.get() == false)) {
                    this.toggleCallback.accept(this.value.get() == false);
                }
            }
        } else {
            this.previewValue = this.value.get();
        }
        return false;
    }

    @Override
    public boolean keyboardInput(KeyboardEvent keyboardEvent) {
        return false;
    }
}

