/*
 * Decompiled with CFR 0.152.
 */
package com.nekiplay.hypixelcry.deps.moulconfig.internal;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;

public class TypeUtils {
    public static boolean areTypesEquals(Class<?> a, Class<?> b) {
        return TypeUtils.normalizeNative(a) == TypeUtils.normalizeNative(b);
    }

    public static boolean doesAExtendB(Type a, Type b) {
        return TypeUtils.normalizeRawAll(b).isAssignableFrom(TypeUtils.normalizeRawAll(a));
    }

    public static Class<?> normalizeRawAll(Type t) {
        return TypeUtils.normalizeNative(TypeUtils.resolveRawType(t));
    }

    public static Class<?> normalizeNative(Class<?> clazz) {
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        if (clazz == Character.TYPE) {
            return Character.class;
        }
        return clazz;
    }

    public static Class<?> resolveRawType(Type t) {
        if (t instanceof Class) {
            return (Class)t;
        }
        if (t instanceof WildcardType) {
            return TypeUtils.resolveRawType(((WildcardType)t).getUpperBounds()[0]);
        }
        if (t instanceof ParameterizedType) {
            return TypeUtils.resolveRawType(((ParameterizedType)t).getRawType());
        }
        if (t instanceof GenericArrayType) {
            Class<?> component = TypeUtils.resolveRawType(((GenericArrayType)t).getGenericComponentType());
            return Array.newInstance(component, 0).getClass();
        }
        throw new IllegalArgumentException("Could not resolve type " + t + " to a raw type");
    }
}

