/*
 * Decompiled with CFR 0.152.
 */
package com.nekiplay.hypixelcry.deps.moulconfig.internal;

import com.nekiplay.hypixelcry.deps.moulconfig.GuiTextures;
import com.nekiplay.hypixelcry.deps.moulconfig.common.IMinecraft;
import com.nekiplay.hypixelcry.deps.moulconfig.internal.MCLogger;
import com.nekiplay.hypixelcry.deps.moulconfig.internal.PropertyUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class Warnings {
    public static boolean isDevEnv = IMinecraft.instance.isDevelopmentEnvironment();
    public static boolean shouldWarn = PropertyUtil.getBooleanWithFallback("moulconfig.warn", isDevEnv);
    public static boolean shouldCrash = shouldWarn && PropertyUtil.getBooleanWithFallback("moulconfig.warn.crash", isDevEnv);
    public static MCLogger logger = IMinecraft.instance.getLogger("MoulConfig");
    public static String basePackage = GuiTextures.class.getPackage().getName() + ".";
    public static String testPackage = basePackage + "test.";
    public static HashSet<Object> warnedObjects = new HashSet();

    public static void warnOnce(String warningText, Object ... warningBucketEntries) {
        if (!shouldWarn) {
            return;
        }
        List<Object> warningBucket = Arrays.asList(warningBucketEntries);
        if (warnedObjects.contains(warningBucket)) {
            return;
        }
        warnedObjects.add(warningBucket);
        Warnings.warn0(warningText, 3);
    }

    private static void warn0(String warningText, int depth) {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        int i2 = 0;
        StackTraceElement modCall = null;
        for (StackTraceElement stackTraceElement : stackTrace) {
            if (i2++ < depth || stackTraceElement.getClassName().startsWith("java.") || stackTraceElement.getClassName().startsWith("kotlin.") || stackTraceElement.getClassName().startsWith(basePackage) && !stackTraceElement.getClassName().startsWith(testPackage)) continue;
            modCall = stackTraceElement;
            break;
        }
        logger.warn("Warning: " + warningText + " at " + stackTrace[depth] + " called by " + modCall);
        if (shouldCrash) {
            throw new RuntimeException(warningText);
        }
    }

    public static void warn(String warningText, int depth) {
        if (shouldWarn) {
            Warnings.warn0(warningText, depth);
        }
    }

    public static void warn(String warningText) {
        Warnings.warn(warningText, 4);
    }
}

