/*
 * Decompiled with CFR 0.152.
 */
package com.nekiplay.hypixelcry.features.esp;

import com.nekiplay.hypixelcry.HypixelCry;
import com.nekiplay.hypixelcry.config.enums.ESPFeatures;
import com.nekiplay.hypixelcry.utils.RenderUtils;
import com.nekiplay.hypixelcry.utils.SpecialColor;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.BlockPos;
import net.minecraft.util.Vec3;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class ChestESP {
    private static final List<BlockPos> chestLocations = new ArrayList<BlockPos>();

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        chestLocations.clear();
        if (!HypixelCry.dataExtractor.isInSkyblock || HypixelCry.mc.field_71441_e == null || !HypixelCry.config.esp.chestEsp.enabled) {
            return;
        }
        double maxRangeSq = Math.pow(HypixelCry.config.esp.chestEsp.maxRange, 2.0);
        HypixelCry.mc.field_71441_e.field_147482_g.stream().filter(TileEntityChest.class::isInstance).map(tile -> (TileEntityChest)tile).filter(tile -> HypixelCry.config.esp.chestEsp.maxRange == 0 || HypixelCry.mc.field_71439_g.func_174818_b(tile.func_174877_v()) <= maxRangeSq).forEach(tile -> chestLocations.add(tile.func_174877_v()));
    }

    @SubscribeEvent
    public void onRender(RenderWorldLastEvent event) {
        if (!HypixelCry.config.esp.chestEsp.enabled || chestLocations.isEmpty()) {
            return;
        }
        Color color = SpecialColor.toSpecialColor(HypixelCry.config.esp.chestEsp.colour);
        chestLocations.forEach(pos -> {
            BlockPos centerPos = new BlockPos((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
            if (this.shouldRenderFeature(ESPFeatures.Box)) {
                RenderUtils.drawBlockBox(centerPos, color, 1, event.partialTicks);
            }
            if (this.shouldRenderFeature(ESPFeatures.Text)) {
                RenderUtils.renderWaypointText("Chest", new Vec3((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.5, (double)pos.func_177952_p() + 0.5), event.partialTicks, false, color);
            }
            if (this.shouldRenderFeature(ESPFeatures.Tracer)) {
                RenderUtils.drawTracer(centerPos, color, 1.0f, event.partialTicks);
            }
        });
    }

    private boolean shouldRenderFeature(ESPFeatures feature) {
        return HypixelCry.config.esp.chestEsp.features.contains((Object)feature);
    }
}

