/*
 * Decompiled with CFR 0.152.
 */
package com.nekiplay.hypixelcry.features.esp.farming;

import com.nekiplay.hypixelcry.HypixelCry;
import com.nekiplay.hypixelcry.config.enums.ESPFeatures;
import com.nekiplay.hypixelcry.events.world.SpawnParticleEvent;
import com.nekiplay.hypixelcry.utils.RenderUtils;
import com.nekiplay.hypixelcry.utils.SpecialColor;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumParticleTypes;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class Glowing_Mushroom {
    private static final List<BlockPos> GLOWING_MUSHROOM_POSITIONS = new ArrayList<BlockPos>();

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START || HypixelCry.mc.field_71441_e == null) {
            return;
        }
        Iterator<BlockPos> iterator = GLOWING_MUSHROOM_POSITIONS.iterator();
        while (iterator.hasNext()) {
            BlockPos pos = iterator.next();
            IBlockState state = HypixelCry.mc.field_71441_e.func_180495_p(pos);
            boolean isMushroom = state.func_177230_c() == Blocks.field_150338_P || state.func_177230_c() == Blocks.field_150337_Q;
            if (isMushroom) continue;
            iterator.remove();
        }
    }

    @SubscribeEvent
    public void onParticleSpawn(SpawnParticleEvent event) {
        if (event.particleType != EnumParticleTypes.SPELL_MOB) {
            return;
        }
        BlockPos pos = new BlockPos(event.position.field_72450_a, event.position.field_72448_b, event.position.field_72449_c);
        Block block = HypixelCry.mc.field_71441_e.func_180495_p(pos).func_177230_c();
        if (!(block != Blocks.field_150338_P && block != Blocks.field_150337_Q || GLOWING_MUSHROOM_POSITIONS.contains(pos))) {
            GLOWING_MUSHROOM_POSITIONS.add(pos);
        }
    }

    public static boolean isGlowingMushroom(BlockPos pos) {
        return GLOWING_MUSHROOM_POSITIONS.contains(pos);
    }

    @SubscribeEvent
    public void onWorldRender(RenderWorldLastEvent event) {
        if (!HypixelCry.config.esp.desertSettlement.glowingMushrooms.enabled) {
            return;
        }
        Color color = SpecialColor.toSpecialColor(HypixelCry.config.esp.desertSettlement.glowingMushrooms.colour);
        List<ESPFeatures> features = HypixelCry.config.esp.desertSettlement.glowingMushrooms.features;
        float partialTicks = event.partialTicks;
        for (BlockPos pos : GLOWING_MUSHROOM_POSITIONS) {
            if (features.contains((Object)ESPFeatures.Box)) {
                RenderUtils.drawBlockBox(pos, color, 1, partialTicks);
            }
            if (features.contains((Object)ESPFeatures.Text)) {
                BlockPos textPos = new BlockPos((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.8, (double)pos.func_177952_p() + 0.5);
                RenderUtils.renderWaypointText("Mushroom", textPos, partialTicks, false, color);
            }
            if (!features.contains((Object)ESPFeatures.Tracer)) continue;
            RenderUtils.drawTracer(pos, color, 1.0f, partialTicks);
        }
    }
}

