/*
 * Decompiled with CFR 0.152.
 */
package com.nekiplay.hypixelcry.features.esp.mining.dwarvenmines;

import com.nekiplay.hypixelcry.HypixelCry;
import com.nekiplay.hypixelcry.config.enums.ESPFeatures;
import com.nekiplay.hypixelcry.data.island.IslandType;
import com.nekiplay.hypixelcry.features.system.IslandTypeChangeChecker;
import com.nekiplay.hypixelcry.utils.RenderUtils;
import com.nekiplay.hypixelcry.utils.SpecialColor;
import java.awt.Color;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.util.Vec3;
import net.minecraft.util.Vec3i;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class Dark_Monolith {
    private BlockPos eggPosition;
    private boolean eggFound;
    private static final BlockPos[] MONOLITH_LOCATIONS = new BlockPos[]{new BlockPos(-15, 236, -92), new BlockPos(49, 202, -162), new BlockPos(56, 214, -25), new BlockPos(128, 187, 58), new BlockPos(150, 196, 190), new BlockPos(61, 204, 181), new BlockPos(91, 187, 131), new BlockPos(77, 160, 162), new BlockPos(-10, 162, 109), new BlockPos(1, 183, 25), new BlockPos(0, 170, 0), new BlockPos(-94, 201, -30), new BlockPos(-91, 221, -53), new BlockPos(-64, 206, -63)};

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (this.shouldSkipTick(event)) {
            return;
        }
        this.eggPosition = this.findEggInWorld();
        this.eggFound = this.eggPosition != null;
    }

    private boolean shouldSkipTick(TickEvent.ClientTickEvent event) {
        return event.phase == TickEvent.Phase.START || HypixelCry.mc.field_71441_e == null || !HypixelCry.config.esp.dwarvenMines.darkMonolith.enabled || !IslandType.current().equals((Object)IslandType.Dwarven_Mines);
    }

    private BlockPos findEggInWorld() {
        return Arrays.stream(MONOLITH_LOCATIONS).filter(pos -> HypixelCry.mc.field_71441_e.func_175667_e(pos)).map(this::findEggNearPosition).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private BlockPos findEggNearPosition(BlockPos center) {
        int searchRadius = 5;
        Iterable searchArea = BlockPos.func_177980_a((BlockPos)center.func_177982_a(5, 5, 5), (BlockPos)center.func_177973_b(new Vec3i(5, 5, 5)));
        for (BlockPos pos : searchArea) {
            IBlockState state = HypixelCry.mc.field_71441_e.func_180495_p(pos);
            if (state.func_177230_c() != Blocks.field_150380_bt) continue;
            return pos;
        }
        return null;
    }

    @SubscribeEvent
    public void onRender(RenderWorldLastEvent event) {
        if (!this.shouldRender()) {
            return;
        }
        Color color = SpecialColor.toSpecialColor(HypixelCry.config.esp.dwarvenMines.darkMonolith.colour);
        BlockPos centerPos = new BlockPos((double)this.eggPosition.func_177958_n() + 0.5, (double)this.eggPosition.func_177956_o() + 0.5, (double)this.eggPosition.func_177952_p() + 0.5);
        if (this.shouldRenderFeature(ESPFeatures.Box)) {
            RenderUtils.drawBlockBox(centerPos, color, 1, event.partialTicks);
        }
        if (this.shouldRenderFeature(ESPFeatures.Text)) {
            RenderUtils.renderWaypointText("Monolith", new Vec3((double)this.eggPosition.func_177958_n() + 0.5, (double)this.eggPosition.func_177956_o() + 1.5, (double)this.eggPosition.func_177952_p() + 0.5), event.partialTicks, false, color);
        }
        if (this.shouldRenderFeature(ESPFeatures.Tracer)) {
            RenderUtils.drawTracer(centerPos, color, 1.0f, event.partialTicks);
        }
    }

    private boolean shouldRender() {
        return HypixelCry.config.esp.dwarvenMines.darkMonolith.enabled && this.eggPosition != null && IslandTypeChangeChecker.getLastDetected().equals((Object)IslandType.Dwarven_Mines);
    }

    private boolean shouldRenderFeature(ESPFeatures feature) {
        return HypixelCry.config.esp.dwarvenMines.darkMonolith.features.contains((Object)feature);
    }
}

