/*
 * Decompiled with CFR 0.152.
 */
package com.nekiplay.hypixelcry.features.esp.pathFinders;

import com.nekiplay.hypixelcry.HypixelCry;
import com.nekiplay.hypixelcry.pathfinder.calculate.Path;
import com.nekiplay.hypixelcry.pathfinder.calculate.path.AStarPathFinder;
import com.nekiplay.hypixelcry.pathfinder.goal.Goal;
import com.nekiplay.hypixelcry.pathfinder.movement.CalculationContext;
import com.nekiplay.hypixelcry.utils.RenderUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.IntStream;
import net.minecraft.util.BlockPos;
import net.minecraft.util.Vec3i;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class PathFinderRenderer {
    private static final ExecutorService PATH_FINDER_EXECUTOR = Executors.newFixedThreadPool(6);
    private static final Map<String, PathData> PATHS = new ConcurrentHashMap<String, PathData>();
    private static final Queue<PathResult> PATH_RESULTS = new ConcurrentLinkedQueue<PathResult>();
    private static final double RECALCULATION_DISTANCE = 9.0;
    private static final int CHUNK_UPDATE_RADIUS = 1;

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END || HypixelCry.mc.field_71439_g == null || HypixelCry.mc.field_71441_e == null) {
            return;
        }
        BlockPos currentPos = HypixelCry.mc.field_71439_g.func_180425_c().func_177982_a(0, -1, 0);
        this.processPathResults();
        if (HypixelCry.config.misc.pathFinderESP.enabled) {
            PATHS.values().forEach(pathData -> this.updatePath(currentPos, (PathData)pathData));
        }
    }

    private void processPathResults() {
        while (!PATH_RESULTS.isEmpty()) {
            PathResult result = PATH_RESULTS.poll();
            Optional.ofNullable(PATHS.get(result.pathId)).ifPresent(data -> {
                data.blocks = result.blocks;
                data.furthestReachedIndex = 0;
                data.currentVisibleFromIndex = 0;
                data.chunksUpdated = false;
                data.needsUpdate = false;
            });
        }
    }

    private void updatePath(BlockPos currentPos, PathData pathData) {
        this.updateChunkData(currentPos, pathData);
        this.updateRemainingPath(currentPos, pathData);
        if (this.shouldRecalculatePath(currentPos, pathData)) {
            this.recalculatePath(currentPos, pathData);
        }
    }

    private void updateChunkData(BlockPos currentPos, PathData pathData) {
        int currentChunkX = currentPos.func_177958_n() >> 4;
        int currentChunkZ = currentPos.func_177952_p() >> 4;
        if (Math.abs(currentChunkX - pathData.lastChunkX) > 1 || Math.abs(currentChunkZ - pathData.lastChunkZ) > 1) {
            pathData.chunksUpdated = true;
            pathData.lastChunkX = currentChunkX;
            pathData.lastChunkZ = currentChunkZ;
        }
    }

    private void recalculatePath(BlockPos currentPos, PathData pathData) {
        PATH_FINDER_EXECUTOR.submit(() -> {
            CalculationContext ctx = new CalculationContext();
            BlockPos targetPos = this.getNearestLoadedPos(pathData.end);
            AStarPathFinder finder = new AStarPathFinder(currentPos.func_177958_n(), currentPos.func_177956_o(), currentPos.func_177952_p(), new Goal(targetPos.func_177958_n(), targetPos.func_177956_o(), targetPos.func_177952_p(), ctx), ctx);
            Optional.ofNullable(finder.calculatePath()).map(Path::getSmoothedPath).ifPresent(path -> {
                pathData.remainingPath = path;
                PATH_RESULTS.add(new PathResult(this.getPathId(pathData), (List<BlockPos>)path));
            });
        });
    }

    private String getPathId(PathData pathData) {
        return PATHS.entrySet().stream().filter(entry -> entry.getValue() == pathData).map(Map.Entry::getKey).findFirst().orElse("");
    }

    private BlockPos getNearestLoadedPos(BlockPos target) {
        int dz;
        if (HypixelCry.mc.field_71441_e.func_175667_e(target)) {
            return target;
        }
        BlockPos playerPos = HypixelCry.mc.field_71439_g.func_180425_c();
        int dx = target.func_177958_n() - playerPos.func_177958_n();
        double length = Math.sqrt(dx * dx + (dz = target.func_177952_p() - playerPos.func_177952_p()) * dz);
        if (length > 0.0) {
            dx = (int)((double)dx / length);
            dz = (int)((double)dz / length);
        }
        for (int radius = 1; radius <= 100; ++radius) {
            BlockPos checkPos = playerPos.func_177982_a(dx * radius, 0, dz * radius);
            if (HypixelCry.mc.field_71441_e.func_175667_e(checkPos)) {
                return checkPos;
            }
            for (int offset = 1; offset <= radius; ++offset) {
                BlockPos pos1 = checkPos.func_177982_a(-dz * offset, 0, dx * offset);
                BlockPos pos2 = checkPos.func_177982_a(dz * offset, 0, -dx * offset);
                if (HypixelCry.mc.field_71441_e.func_175667_e(pos1)) {
                    return pos1;
                }
                if (!HypixelCry.mc.field_71441_e.func_175667_e(pos2)) continue;
                return pos2;
            }
        }
        return target;
    }

    private boolean shouldRecalculatePath(BlockPos currentPos, PathData pathData) {
        if (pathData.needsUpdate || pathData.blocks.isEmpty()) {
            return true;
        }
        BlockPos endPos = pathData.blocks.get(pathData.blocks.size() - 1);
        if (currentPos.func_177951_i((Vec3i)endPos) < 81.0) {
            return true;
        }
        BlockPos nearest = this.findNearestPathPoint(currentPos, pathData.blocks);
        if (nearest == null || currentPos.func_177951_i((Vec3i)nearest) > 81.0) {
            return true;
        }
        return pathData.chunksUpdated && this.isPotentialBetterPathAvailable(currentPos, pathData);
    }

    private BlockPos findNearestPathPoint(BlockPos playerPos, List<BlockPos> path) {
        if (path == null || path.isEmpty()) {
            return null;
        }
        if (path.size() < 2) {
            return path.get(0);
        }
        return IntStream.range(0, path.size() - 1).mapToObj(i2 -> this.getClosestPointOnSegment(playerPos, (BlockPos)path.get(i2), (BlockPos)path.get(i2 + 1))).min(Comparator.comparingDouble(arg_0 -> ((BlockPos)playerPos).func_177951_i(arg_0))).orElse(null);
    }

    private BlockPos getClosestPointOnSegment(BlockPos point, BlockPos start, BlockPos end) {
        double lineX = end.func_177958_n() - start.func_177958_n();
        double lineY = end.func_177956_o() - start.func_177956_o();
        double lineZ = end.func_177952_p() - start.func_177952_p();
        double pointX = point.func_177958_n() - start.func_177958_n();
        double pointY = point.func_177956_o() - start.func_177956_o();
        double pointZ = point.func_177952_p() - start.func_177952_p();
        double dot = pointX * lineX + pointY * lineY + pointZ * lineZ;
        double t = Math.max(0.0, Math.min(1.0, dot / (lineX * lineX + lineY * lineY + lineZ * lineZ)));
        return new BlockPos((double)start.func_177958_n() + t * lineX, (double)start.func_177956_o() + t * lineY, (double)start.func_177952_p() + t * lineZ);
    }

    private void updateRemainingPath(BlockPos playerPos, PathData pathData) {
        if (pathData.remainingPath.isEmpty()) {
            return;
        }
        BlockPos nearest = this.findNearestPathPoint(playerPos, pathData.remainingPath);
        if (nearest == null) {
            return;
        }
        int nearestIndex = pathData.remainingPath.indexOf(nearest);
        if (nearestIndex > 0) {
            pathData.remainingPath = pathData.remainingPath.subList(nearestIndex, pathData.remainingPath.size());
        }
    }

    private boolean isPotentialBetterPathAvailable(BlockPos playerPos, PathData pathData) {
        if (pathData.blocks.isEmpty() || !HypixelCry.mc.field_71441_e.func_175667_e(pathData.end)) {
            return false;
        }
        BlockPos currentPathEnd = pathData.blocks.get(pathData.blocks.size() - 1);
        double currentDistance = currentPathEnd.func_177951_i((Vec3i)pathData.end);
        return IntStream.rangeClosed(-3, 3).anyMatch(x -> IntStream.rangeClosed(-3, 3).anyMatch(z -> {
            BlockPos testPos = playerPos.func_177982_a(x * 16, 0, z * 16);
            return HypixelCry.mc.field_71441_e.func_175667_e(testPos) && testPos.func_177951_i((Vec3i)pathData.end) < currentDistance;
        }));
    }

    @SubscribeEvent
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        if (HypixelCry.mc.field_71441_e == null || PATHS.isEmpty() || !HypixelCry.config.esp.pathFinderESP.enabled) {
            return;
        }
        PATHS.values().forEach(pathData -> this.renderPath((PathData)pathData, event.partialTicks));
    }

    private void renderPath(PathData pathData, float partialTicks) {
        if (pathData.blocks == null || pathData.blocks.isEmpty() || pathData.remainingPath.isEmpty()) {
            return;
        }
        BlockPos endPos = pathData.blocks.get(pathData.blocks.size() - 1);
        this.renderPathLines(pathData, endPos, partialTicks);
        this.renderEndPoint(pathData, endPos, partialTicks);
    }

    private void renderPathLines(PathData pathData, BlockPos endPos, float partialTicks) {
        BlockPos prevPos = pathData.remainingPath.get(0);
        for (int i2 = 1; i2 < pathData.remainingPath.size(); ++i2) {
            BlockPos currentPos = pathData.remainingPath.get(i2);
            RenderUtils.drawLine(prevPos.func_177963_a(0.0, 1.5, 0.0), currentPos.func_177963_a(0.0, 1.5, 0.0), 4.0f, pathData.color);
            if (!currentPos.equals((Object)endPos) && HypixelCry.config.esp.pathFinderESP.enableSubPoints) {
                RenderUtils.drawBlockBox(currentPos, pathData.color, 1, partialTicks);
            }
            prevPos = currentPos;
        }
    }

    private void renderEndPoint(PathData pathData, BlockPos endPos, float partialTicks) {
        RenderUtils.drawBlockBox(endPos, pathData.color, 4, partialTicks);
        RenderUtils.renderWaypointText(pathData.endText, new BlockPos((double)endPos.func_177958_n() + 0.5, (double)endPos.func_177956_o() + 2.8, (double)endPos.func_177952_p() + 0.5), partialTicks, false, pathData.color);
    }

    public static void addOrUpdatePath(String id, BlockPos end, Color color, String endText) {
        PathData newData = new PathData(end, color, endText);
        if (!end.equals(Optional.ofNullable(PATHS.get(id)).map(data -> data.end).orElse(null))) {
            newData.needsUpdate = true;
        }
        PATHS.put(id, newData);
    }

    public static void removePath(String id) {
        PATHS.remove(id);
    }

    public static void clearAllPaths() {
        PATHS.clear();
    }

    public static boolean hasPath(String id) {
        return PATHS.containsKey(id);
    }

    public static List<BlockPos> getPathBlocks(String id) {
        PathData data = PATHS.get(id);
        return data != null ? new ArrayList<BlockPos>(data.blocks) : Collections.emptyList();
    }

    public static void shutdown() {
        PATH_FINDER_EXECUTOR.shutdownNow();
    }

    private static class PathResult {
        final String pathId;
        final List<BlockPos> blocks;

        PathResult(String pathId, List<BlockPos> blocks) {
            this.pathId = pathId;
            this.blocks = blocks;
        }
    }

    public static class PathData {
        public final BlockPos end;
        public final Color color;
        public final String endText;
        public List<BlockPos> blocks = new ArrayList<BlockPos>();
        public List<BlockPos> remainingPath = new ArrayList<BlockPos>();
        public int furthestReachedIndex = 0;
        public int currentVisibleFromIndex = 0;
        public boolean needsUpdate = true;
        public int lastChunkX = Integer.MIN_VALUE;
        public int lastChunkZ = Integer.MIN_VALUE;
        public boolean chunksUpdated = false;

        public PathData(BlockPos end, Color color, String endText) {
            this.end = end;
            this.color = color;
            this.endText = endText;
        }
    }
}

