/*
 * Decompiled with CFR 0.152.
 */
package com.nekiplay.hypixelcry.features.esp.pathFinders.detections.crystalhollows;

import com.nekiplay.hypixelcry.HypixelCry;
import com.nekiplay.hypixelcry.features.esp.pathFinders.PathFinderRenderer;
import java.awt.Color;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class JungleTemple {
    public static BlockPos jungleTemple = null;
    private static volatile boolean running = false;
    private static Thread detectionThread;
    private static boolean foundAndNotified;
    private static final int SEARCH_RADIUS = 200;

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        jungleTemple = null;
        foundAndNotified = false;
        JungleTemple.stopDetection();
        if (PathFinderRenderer.hasPath("Temple")) {
            PathFinderRenderer.removePath("Temple");
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START && event.type == TickEvent.Type.CLIENT && Minecraft.func_71410_x().field_71441_e != null && Minecraft.func_71410_x().field_71439_g != null && !running && !foundAndNotified) {
            JungleTemple.startDetection((World)Minecraft.func_71410_x().field_71441_e, Minecraft.func_71410_x().field_71439_g.func_180425_c(), 200);
        }
    }

    public static void startDetection(World world, BlockPos center, int radius) {
        if (running) {
            return;
        }
        running = true;
        detectionThread = new Thread(() -> {
            BlockPos foundPos = JungleTemple.findEmeraldWithSmoothAndesiteBelow(world, center, radius);
            if (HypixelCry.config.esp.crystalHollows.pathFinder.enabledJungleTemple) {
                if (foundPos != null && !foundAndNotified) {
                    jungleTemple = foundPos;
                    foundAndNotified = true;
                    PathFinderRenderer.addOrUpdatePath("Temple", foundPos, Color.GREEN, "Temple");
                }
            } else {
                if (PathFinderRenderer.hasPath("Temple")) {
                    PathFinderRenderer.removePath("Temple");
                }
                foundAndNotified = false;
            }
            running = false;
        }, "JungleTempleDetector");
        detectionThread.start();
    }

    public static void stopDetection() {
        running = false;
        if (detectionThread != null && detectionThread.isAlive()) {
            detectionThread.interrupt();
        }
    }

    public static BlockPos findEmeraldWithSmoothAndesiteBelow(World world, BlockPos center, int radius) {
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                for (int y = -radius; y <= radius; ++y) {
                    boolean isAndesite;
                    BlockPos checkPos = center.func_177982_a(x, y, z);
                    IBlockState state = world.func_180495_p(checkPos);
                    Block block = state.func_177230_c();
                    if (block != Blocks.field_150475_bE) continue;
                    BlockPos upPos = checkPos.func_177984_a();
                    IBlockState upState = world.func_180495_p(upPos);
                    Block upBlock = upState.func_177230_c();
                    BlockPos belowPos = checkPos.func_177977_b();
                    IBlockState belowState = world.func_180495_p(belowPos);
                    Block belowBlock = belowState.func_177230_c();
                    boolean bl = isAndesite = belowBlock == Blocks.field_150348_b && upBlock == Blocks.field_150475_bE && belowState.func_177230_c().func_176201_c(belowState) == 6;
                    if (!isAndesite) continue;
                    return checkPos;
                }
            }
        }
        return null;
    }

    static {
        foundAndNotified = false;
    }
}

