/*
 * Decompiled with CFR 0.152.
 */
package com.nekiplay.hypixelcry.features.macros;

import com.nekiplay.hypixelcry.HypixelCry;
import com.nekiplay.hypixelcry.config.enums.AutoRightClickBlocks;
import com.nekiplay.hypixelcry.config.enums.AutoRightClickOpenFeatures;
import com.nekiplay.hypixelcry.events.world.BlockUpdateEvent;
import com.nekiplay.hypixelcry.features.system.IslandTypeChangeChecker;
import com.nekiplay.hypixelcry.features.system.RotationHandler;
import com.nekiplay.hypixelcry.utils.BlockUtils;
import com.nekiplay.hypixelcry.utils.PlayerUtils;
import com.nekiplay.hypixelcry.utils.RaycastUtils;
import com.nekiplay.hypixelcry.utils.helper.RotationConfiguration;
import com.nekiplay.hypixelcry.utils.helper.Target;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class AutoRightClick {
    private final Map<BlockPos, Integer> openedChests = new LinkedHashMap<BlockPos, Integer>();
    private int tickCounter = 0;
    private static final int CHEST_COOLDOWN = 1200;
    private static final int MAX_REMOVALS_PER_TICK = 20;

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (this.shouldSkipTick(event)) {
            return;
        }
        if (++this.tickCounter % 20 == 0) {
            this.cleanUpOldChests();
        }
        if (HypixelCry.mc.field_71462_r == null) {
            this.handleChestOpening();
        }
    }

    private boolean shouldSkipTick(TickEvent.ClientTickEvent event) {
        return event.phase == TickEvent.Phase.START || HypixelCry.mc.field_71441_e == null || HypixelCry.mc.field_71439_g == null || !HypixelCry.config.macros.autoRightClick.enabled || !HypixelCry.config.macros.autoRightClick.allowedIslands.contains((Object)IslandTypeChangeChecker.getLastDetected());
    }

    private void cleanUpOldChests() {
        Iterator<Map.Entry<BlockPos, Integer>> iterator = this.openedChests.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<BlockPos, Integer> entry = iterator.next();
            if (entry.getValue() >= 1200) {
                iterator.remove();
                continue;
            }
            entry.setValue(entry.getValue() + 1);
        }
    }

    public static List<BlockPos> findBlocksNearby(List<Block> blocksToFind, List<BlockPos> blackListed, float radius) {
        ArrayList<BlockPos> foundBlocks = new ArrayList<BlockPos>();
        if (HypixelCry.mc == null || HypixelCry.mc.field_71439_g == null || HypixelCry.mc.field_71441_e == null || blocksToFind == null || blocksToFind.isEmpty()) {
            return foundBlocks;
        }
        EntityPlayerSP player = HypixelCry.mc.field_71439_g;
        WorldClient world = HypixelCry.mc.field_71441_e;
        BlockPos playerPos = new BlockPos(player.field_70165_t, player.field_70163_u, player.field_70161_v);
        int radiusInt = (int)Math.ceil(radius);
        int minX = Math.max(playerPos.func_177958_n() - radiusInt, -30000000);
        int maxX = Math.min(playerPos.func_177958_n() + radiusInt, 30000000);
        int minY = Math.max(0, playerPos.func_177956_o() - radiusInt);
        int maxY = Math.min(255, playerPos.func_177956_o() + radiusInt);
        int minZ = Math.max(playerPos.func_177952_p() - radiusInt, -30000000);
        int maxZ = Math.min(playerPos.func_177952_p() + radiusInt, 30000000);
        HashSet<BlockPos> blackListSet = blackListed != null ? new HashSet<BlockPos>(blackListed) : Collections.emptySet();
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                for (int y = maxY; y >= minY; --y) {
                    Block block;
                    BlockPos checkPos = new BlockPos(x, y, z);
                    if (blackListSet.contains(checkPos) || !blocksToFind.contains(block = world.func_180495_p(checkPos).func_177230_c())) continue;
                    foundBlocks.add(checkPos);
                }
            }
        }
        foundBlocks.sort(Comparator.comparingDouble(arg_0 -> ((EntityPlayer)player).func_174818_b(arg_0)));
        return foundBlocks;
    }

    private void handleChestOpening() {
        boolean ghostHand = HypixelCry.config.macros.autoRightClick.features.contains((Object)AutoRightClickOpenFeatures.GhostHand);
        ArrayList<Block> selectedBlocks = new ArrayList<Block>();
        List<AutoRightClickBlocks> blocks = HypixelCry.config.macros.autoRightClick.blocks;
        if (blocks.contains((Object)AutoRightClickBlocks.Chest)) {
            selectedBlocks.add((Block)Blocks.field_150486_ae);
            selectedBlocks.add(Blocks.field_150447_bR);
        }
        if (blocks.contains((Object)AutoRightClickBlocks.Lever)) {
            selectedBlocks.add(Blocks.field_150442_at);
        }
        if (blocks.contains((Object)AutoRightClickBlocks.Skull)) {
            selectedBlocks.add((Block)Blocks.field_150465_bP);
        }
        if (selectedBlocks.isEmpty()) {
            return;
        }
        if (HypixelCry.config.macros.autoRightClick.features.contains((Object)AutoRightClickOpenFeatures.AutoLook)) {
            List<Object> ghostBlocks;
            BlockPos targetBlock;
            List<Vec3> points;
            float reachDistance = HypixelCry.mc.field_71442_b.func_78757_d();
            float squaredReach = reachDistance * reachDistance;
            List<BlockPos> foundBlocks = AutoRightClick.findBlocksNearby(selectedBlocks, new ArrayList<BlockPos>(this.openedChests.keySet()), reachDistance + 1.0f);
            if (!(foundBlocks.isEmpty() || RotationHandler.getInstance().isEnabled() || (points = BlockUtils.bestPointsOnBestSide(targetBlock = foundBlocks.get(0), ghostBlocks = ghostHand ? selectedBlocks : Collections.emptyList())) == null || points.isEmpty())) {
                Vec3 eyePosition = HypixelCry.mc.field_71439_g.func_174824_e(1.0f);
                points.removeIf(point -> point.func_72436_e(eyePosition) > (double)squaredReach || !this.isPointVisible((Vec3)point, eyePosition, (List<Block>)ghostBlocks));
                if (!points.isEmpty()) {
                    RotationConfiguration.RotationType rotationType = ghostHand ? RotationConfiguration.RotationType.SERVER : RotationConfiguration.RotationType.CLIENT;
                    RotationHandler.getInstance().easeTo(new RotationConfiguration(new Target(points.get(0)), (long)HypixelCry.config.macros.autoRightClick.rotationTime, rotationType, null));
                }
            }
        }
        if (ghostHand) {
            MovingObjectPosition mouseOver = RaycastUtils.rayTraceToBlocks(PlayerUtils.getEyePosition(), PlayerUtils.getLookEndPos(HypixelCry.mc.field_71442_b.func_78757_d(), true), selectedBlocks);
            this.tryOpenChest(mouseOver);
        } else if (this.isLookingAt(selectedBlocks)) {
            this.tryOpenChest(HypixelCry.mc.field_71476_x);
        }
    }

    private boolean isPointVisible(Vec3 point, Vec3 eyePosition, List<Block> ghostBlocks) {
        MovingObjectPosition result = RaycastUtils.rayTraceToBlocks(eyePosition, PlayerUtils.getLookEndPos(point, HypixelCry.mc.field_71442_b.func_78757_d()), ghostBlocks);
        return result != null && result.field_72313_a != MovingObjectPosition.MovingObjectType.MISS;
    }

    private boolean isLookingAt(List<Block> blocks) {
        return HypixelCry.mc.field_71476_x != null && HypixelCry.mc.field_71476_x.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && blocks.contains(HypixelCry.mc.field_71441_e.func_180495_p(HypixelCry.mc.field_71476_x.func_178782_a()).func_177230_c());
    }

    private void tryOpenChest(MovingObjectPosition mouseOver) {
        if (mouseOver == null || mouseOver.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK || this.openedChests.containsKey(mouseOver.func_178782_a())) {
            return;
        }
        this.simulateHumanClick(mouseOver);
    }

    private void simulateHumanClick(MovingObjectPosition mop) {
        if (mop == null || mop.func_178782_a() == null) {
            return;
        }
        boolean success = HypixelCry.mc.field_71442_b.func_178890_a(HypixelCry.mc.field_71439_g, HypixelCry.mc.field_71441_e, HypixelCry.mc.field_71439_g.field_71071_by.func_70448_g(), mop.func_178782_a(), mop.field_178784_b, mop.field_72307_f);
        HypixelCry.mc.field_71439_g.func_71038_i();
        if (success && HypixelCry.config.macros.autoRightClick.features.contains((Object)AutoRightClickOpenFeatures.Air)) {
            this.openedChests.put(mop.func_178782_a(), 0);
            HypixelCry.mc.field_71441_e.func_175656_a(mop.func_178782_a(), Blocks.field_150350_a.func_176223_P());
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        this.openedChests.clear();
    }

    @SubscribeEvent
    public void onBlockUpdate(BlockUpdateEvent event) {
        if (HypixelCry.config.macros.autoRightClick.features.contains((Object)AutoRightClickOpenFeatures.Air) && event.newState.func_177230_c() == Blocks.field_150486_ae) {
            event.setCanceled(true);
        }
    }
}

